/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.henshin.diagram.edit.helpers.HenshinBaseEditHelper;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.provider.util.HenshinColorMode;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class ColorModeHelper
extends HenshinBaseEditHelper {
    public static final String COLOR_MODE_EANNOTATION_KEY = "colorMode";
    public static final String COLOR_MODE_VALUE_KEY = "value";

    public static HenshinColorMode getColorMode(View view) {
        if (view == null) {
            return HenshinColorMode.getDefaultColorMode();
        }
        Diagram diagram = view.getDiagram();
        if (diagram == null) {
            return HenshinColorMode.getDefaultColorMode();
        }
        EAnnotation annotation = diagram.getEAnnotation(COLOR_MODE_EANNOTATION_KEY);
        if (annotation == null) {
            return HenshinColorMode.getDefaultColorMode();
        }
        String value = (String)annotation.getDetails().get((Object)COLOR_MODE_VALUE_KEY);
        if (value == null) {
            return HenshinColorMode.getDefaultColorMode();
        }
        HenshinColorMode mode = (HenshinColorMode)HenshinColorMode.REGISTRY.get(value);
        if (mode != null) {
            return mode;
        }
        return HenshinColorMode.getDefaultColorMode();
    }

    public static void setColorMode(View view, HenshinColorMode mode) {
        if (view == null) {
            return;
        }
        Diagram diagram = view.getDiagram();
        if (diagram == null) {
            return;
        }
        if (mode == HenshinColorMode.getDefaultColorMode() || mode != null && mode.getName() == null) {
            mode = null;
        }
        if (mode == null) {
            EAnnotation annotation = diagram.getEAnnotation(COLOR_MODE_EANNOTATION_KEY);
            if (annotation != null) {
                diagram.getEAnnotations().remove((Object)annotation);
            }
        } else {
            EAnnotation annotation = diagram.getEAnnotation(COLOR_MODE_EANNOTATION_KEY);
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource(COLOR_MODE_EANNOTATION_KEY);
                diagram.getEAnnotations().add((Object)annotation);
            }
            annotation.getDetails().put((Object)COLOR_MODE_VALUE_KEY, (Object)mode.getName());
        }
    }

    public static HenshinColorMode.Color getActionColor(View view, boolean foreground) {
        if (view == null) {
            return null;
        }
        if (!(view.getElement() instanceof GraphElement)) {
            return null;
        }
        GraphElement element = (GraphElement)view.getElement();
        Action action = element.getAction();
        if (action == null) {
            return null;
        }
        return ColorModeHelper.getCustomOrDefaultColor(view, HenshinColorMode.getActionColorKey((Action)action, (boolean)foreground), foreground);
    }

    public static HenshinColorMode.Color getColor(View view, String type) {
        if (view == null) {
            return null;
        }
        if (type.startsWith("BG_") || type.startsWith("FG_")) {
            return ColorModeHelper.getCustomOrDefaultColor(view, type, type.startsWith("FG_"));
        }
        HenshinColorMode mode = ColorModeHelper.getColorMode(view);
        if (mode == null) {
            return null;
        }
        return mode.getColor(type);
    }

    private static HenshinColorMode.Color getCustomOrDefaultColor(View view, String type, boolean foreground) {
        int sum;
        HenshinColorMode mode;
        HenshinColorMode.Color customColor = null;
        HenshinColorMode.Color defaultColor = null;
        if (!foreground) {
            customColor = ColorModeHelper.getCustomColor(view, foreground);
        }
        if ((mode = ColorModeHelper.getColorMode(view)) != null) {
            defaultColor = mode.getColor(type);
        }
        HenshinColorMode classic = (HenshinColorMode)HenshinColorMode.REGISTRY.get("classic");
        if (customColor != null && classic != null && (sum = customColor.red + customColor.green + customColor.blue) != 0 && sum != 765 && !customColor.equals((Object)classic.getColor(type))) {
            return customColor;
        }
        return defaultColor;
    }

    private static HenshinColorMode.Color getCustomColor(View view, boolean foreground) {
        if (foreground) {
            Color color;
            LineStyle style = (LineStyle)view.getStyle(NotationPackage.Literals.LINE_STYLE);
            if (style != null && (color = DiagramColorRegistry.getInstance().getColor(Integer.valueOf(style.getLineColor()))) != null) {
                return ColorModeHelper.getHenshinColor(color);
            }
        } else {
            Color color;
            FillStyle style = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
            if (style != null && (color = DiagramColorRegistry.getInstance().getColor(Integer.valueOf(style.getFillColor()))) != null) {
                return ColorModeHelper.getHenshinColor(color);
            }
        }
        return null;
    }

    public static Color getSWTColor(HenshinColorMode.Color c) {
        return new Color(null, c.red, c.green, c.blue);
    }

    public static HenshinColorMode.Color getHenshinColor(Color c) {
        return new HenshinColorMode.Color(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static Integer getIntegerColor(HenshinColorMode.Color c) {
        return FigureUtilities.colorToInteger((Color)ColorModeHelper.getSWTColor(c));
    }
}

