/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.commands.NegligentRemoveCommand;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapterFactory;
import org.eclipse.emf.henshin.provider.UnitItemProvider;
import org.eclipse.emf.henshin.provider.filter.IFilterProvider;
import org.eclipse.emf.henshin.provider.trans.GenericReferenceContainerItemProvider;
import org.eclipse.emf.henshin.provider.util.HenshinColorMode;
import org.eclipse.emf.henshin.provider.util.IconUtil;

public class RuleItemProvider
extends UnitItemProvider {
    protected GenericReferenceContainerItemProvider lrMappingContainer;
    protected GenericReferenceContainerItemProvider multiMappingContainer;

    public RuleItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getParent(Object object) {
        return super.getParent(object);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addCheckDanglingPropertyDescriptor(object);
            this.addInjectiveMatchingPropertyDescriptor(object);
            this.addJavaImportsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addCheckDanglingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rule_checkDangling_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rule_checkDangling_feature", "_UI_Rule_type"), (EStructuralFeature)HenshinPackage.Literals.RULE__CHECK_DANGLING, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addInjectiveMatchingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rule_injectiveMatching_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rule_injectiveMatching_feature", "_UI_Rule_type"), (EStructuralFeature)HenshinPackage.Literals.RULE__INJECTIVE_MATCHING, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addJavaImportsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rule_javaImports_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rule_javaImports_feature", "_UI_Rule_type"), (EStructuralFeature)HenshinPackage.Literals.RULE__JAVA_IMPORTS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__LHS);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__RHS);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__ATTRIBUTE_CONDITIONS);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__MULTI_RULES);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Collection<?> getChildren(Object object) {
        Collection<?> childrenList = super.getChildren(object);
        Rule rule = (Rule)object;
        if (!this.isFiltered((EStructuralFeature)HenshinPackage.eINSTANCE.getRule_Mappings())) {
            childrenList.add(this.getLrMappingContainer(rule));
        }
        if (!this.isFiltered((EStructuralFeature)HenshinPackage.eINSTANCE.getRule_MultiMappings())) {
            childrenList.add(this.getMultiMappingContainer(rule));
        }
        return childrenList;
    }

    @Override
    protected boolean isFiltered(EStructuralFeature feature) {
        if (this.adapterFactory instanceof HenshinItemProviderAdapterFactory) {
            IFilterProvider fp = ((HenshinItemProviderAdapterFactory)this.adapterFactory).getFilterProvider();
            return fp != null ? fp.isFiltered(feature) : false;
        }
        return false;
    }

    @Override
    public Object getImage(Object object) {
        Rule rule = (Rule)object;
        Object ruleImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Rule.gif"));
        Object deactivatedImage = this.getResourceLocator().getImage("full/ovr16/Del_ovr.png");
        if (!rule.isActivated()) {
            ruleImage = IconUtil.getCompositeImage(ruleImage, deactivatedImage);
        }
        return ruleImage;
    }

    @Override
    public String getText(Object object) {
        return ((Rule)object).toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Rule.class)) {
            case 9: 
            case 13: {
                this.notifyMappedNodes(notification);
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    private void notifyMappedNodes(Notification notification) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        switch (notification.getEventType()) {
            case 4: {
                mappings.add((Mapping)notification.getOldValue());
                break;
            }
            case 3: {
                mappings.add((Mapping)notification.getNewValue());
                break;
            }
            case 5: {
                mappings.addAll((Collection)notification.getNewValue());
                break;
            }
            case 6: {
                mappings.addAll((Collection)notification.getOldValue());
            }
        }
        if (!mappings.isEmpty()) {
            for (Mapping mapping : mappings) {
                HashSet edges = new HashSet();
                HashSet<Node> nodes = new HashSet<Node>();
                if (mapping.getImage() != null) {
                    nodes.add(mapping.getImage());
                    edges.addAll(mapping.getImage().getAllEdges());
                }
                if (mapping.getOrigin() != null) {
                    nodes.add(mapping.getOrigin());
                    edges.addAll(mapping.getOrigin().getAllEdges());
                }
                for (Node node : nodes) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)node, false, true));
                }
                for (Edge edge : edges) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)edge, false, true));
                }
            }
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.MODEL_ELEMENT__ANNOTATIONS, HenshinFactory.eINSTANCE.createAnnotation()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.UNIT__PARAMETERS, HenshinFactory.eINSTANCE.createParameter()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__LHS, HenshinFactory.eINSTANCE.createGraph()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__RHS, HenshinFactory.eINSTANCE.createGraph()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__ATTRIBUTE_CONDITIONS, HenshinFactory.eINSTANCE.createAttributeCondition()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__MULTI_RULES, HenshinFactory.eINSTANCE.createRule()));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        boolean qualify;
        Object childFeature = feature;
        Object childObject = child;
        boolean bl = qualify = childFeature == HenshinPackage.Literals.RULE__LHS || childFeature == HenshinPackage.Literals.RULE__RHS || childFeature == HenshinPackage.Literals.RULE__MAPPINGS || childFeature == HenshinPackage.Literals.RULE__MULTI_MAPPINGS;
        if (qualify) {
            return this.getString("_UI_CreateChild_text2", new Object[]{this.getTypeText(childObject), this.getFeatureText(childFeature), this.getTypeText(owner)});
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == HenshinPackage.Literals.RULE__MAPPINGS) {
            return new NegligentRemoveCommand(domain, owner, feature, collection);
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if ((feature == HenshinPackage.Literals.RULE__LHS || feature == HenshinPackage.Literals.RULE__RHS) && value == SetCommand.UNSET_VALUE) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    @Override
    public Object getToolTip(Object object) {
        Rule rule = (Rule)object;
        String label = "<p><b>Rule \"" + rule.getName() + "\"</b>";
        if (rule.getDescription() != null && rule.getDescription().length() > 0) {
            label = String.valueOf(label) + ": <br/> " + rule.getDescription();
        }
        label = String.valueOf(label) + "</p>";
        if (!rule.getParameters().isEmpty()) {
            label = String.valueOf(label) + "<p><b>Parameters:</b><br/></p>";
            for (Parameter p : rule.getParameters()) {
                label = String.valueOf(label) + "<li><b>" + p.getName() + "</b>: " + p.getDescription() + "</li>";
            }
        }
        return label;
    }

    @Override
    protected boolean isWrappingNeeded(Object object) {
        return false;
    }

    public GenericReferenceContainerItemProvider getLrMappingContainer(Rule rule) {
        if (this.lrMappingContainer == null) {
            this.lrMappingContainer = new GenericReferenceContainerItemProvider(this.adapterFactory, (EObject)rule, HenshinPackage.eINSTANCE.getRule_Mappings(), "_UI_Rule_mappings_feature", "full/obj16/Mapping");
            this.lrMappingContainer.setForceNoWrapping(true);
            this.getDisposable().add((Object)this.lrMappingContainer);
        }
        return this.lrMappingContainer;
    }

    public GenericReferenceContainerItemProvider getMultiMappingContainer(Rule rule) {
        if (this.multiMappingContainer == null) {
            this.multiMappingContainer = new GenericReferenceContainerItemProvider(this.adapterFactory, (EObject)rule, HenshinPackage.eINSTANCE.getRule_MultiMappings(), "_UI_Rule_multiMappings_feature", "full/obj16/Mapping");
            this.multiMappingContainer.setForceNoWrapping(true);
            this.getDisposable().add((Object)this.multiMappingContainer);
        }
        return this.multiMappingContainer;
    }

    @Override
    public Object getBackground(Object object) {
        HenshinColorMode colorMode = HenshinColorMode.getDefaultColorMode();
        if (colorMode == null) {
            return super.getBackground(object);
        }
        HenshinColorMode.Color background = colorMode.getColor("BG_RULE");
        if (background != null) {
            return background.toURI();
        }
        return super.getBackground(object);
    }
}

