/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.provider.DelegatingWrapperTrafoUnitItemProvider;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapterFactory;
import org.eclipse.emf.henshin.provider.NamedElementItemProvider;
import org.eclipse.emf.henshin.provider.ReferencedRuleItemProvider;
import org.eclipse.emf.henshin.provider.filter.IFilterProvider;
import org.eclipse.emf.henshin.provider.trans.GenericReferenceContainerItemProvider;
import org.eclipse.emf.henshin.provider.util.HenshinColorMode;

public class UnitItemProvider
extends NamedElementItemProvider {
    public static final int MAX_UNFOLD_PARAMETERS = 5;
    public static final int MAX_UNFOLD_PARAMETERMAPPINGS = 5;

    public UnitItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addActivatedPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(0, this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_NamedElement_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_NamedElement_name_feature", "_UI_NamedElement_type"), (EStructuralFeature)HenshinPackage.Literals.NAMED_ELEMENT__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addActivatedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Unit_activated_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Unit_activated_feature", "_UI_Unit_type"), (EStructuralFeature)HenshinPackage.Literals.UNIT__ACTIVATED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.UNIT__PARAMETERS);
            this.childrenFeatures.add(HenshinPackage.Literals.UNIT__PARAMETER_MAPPINGS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Collection<?> getChildren(Object object) {
        Unit tu = (Unit)object;
        List childrenList = (List)super.getChildren(object);
        if (tu.getParameterMappings().size() > 5) {
            childrenList.removeAll((Collection<?>)tu.getParameterMappings());
            int offset = 0;
            while (offset < childrenList.size()) {
                Object currentItem = childrenList.get(offset);
                if (!(currentItem instanceof Parameter)) break;
                ++offset;
            }
            if (!this.isFiltered((EStructuralFeature)HenshinPackage.eINSTANCE.getUnit_Parameters())) {
                childrenList.add(offset, new GenericReferenceContainerItemProvider(this.adapterFactory, (EObject)tu, HenshinPackage.eINSTANCE.getUnit_ParameterMappings(), "_UI_Unit_parameterMappings_feature", "full/obj16/ParameterMapping"));
            }
        } else if (this.isFiltered((EStructuralFeature)HenshinPackage.eINSTANCE.getUnit_ParameterMappings())) {
            childrenList.removeAll((Collection<?>)tu.getParameterMappings());
        }
        if (tu.getParameters().size() > 5) {
            childrenList.removeAll((Collection<?>)tu.getParameters());
            if (!this.isFiltered((EStructuralFeature)HenshinPackage.eINSTANCE.getUnit_ParameterMappings())) {
                childrenList.add(0, new GenericReferenceContainerItemProvider(this.adapterFactory, (EObject)tu, HenshinPackage.eINSTANCE.getUnit_Parameters(), "_UI_Unit_parameters_feature", "full/obj16/Parameter"));
            }
        } else if (this.isFiltered((EStructuralFeature)HenshinPackage.eINSTANCE.getUnit_Parameters())) {
            childrenList.removeAll((Collection<?>)tu.getParameters());
        }
        return childrenList;
    }

    protected boolean isFiltered(EStructuralFeature feature) {
        if (this.adapterFactory instanceof HenshinItemProviderAdapterFactory) {
            IFilterProvider fp = ((HenshinItemProviderAdapterFactory)this.adapterFactory).getFilterProvider();
            return fp != null ? fp.isFiltered(feature) : false;
        }
        return false;
    }

    @Override
    public String getText(Object object) {
        return ((Unit)object).toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Unit.class)) {
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected boolean isWrappingNeeded(Object object) {
        return object instanceof Unit;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (!this.isWrappingNeeded(object)) {
            return value;
        }
        if (value instanceof Unit) {
            if (value instanceof Rule) {
                return new ReferencedRuleItemProvider((Rule)value, object, feature, index, this.adapterFactory);
            }
            return new DelegatingWrapperTrafoUnitItemProvider(value, object, feature, index, this.adapterFactory);
        }
        return super.createWrapper(object, feature, value, index);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.UNIT__PARAMETERS, HenshinFactory.eINSTANCE.createParameter()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.UNIT__PARAMETER_MAPPINGS, HenshinFactory.eINSTANCE.createParameterMapping()));
    }

    public Object getFont(Object object) {
        return IItemFontProvider.ITALIC_FONT;
    }

    public Object getBackground(Object object) {
        HenshinColorMode colorMode = HenshinColorMode.getDefaultColorMode();
        if (colorMode == null) {
            return super.getBackground(object);
        }
        HenshinColorMode.Color background = colorMode.getColor("BG_UNIT");
        if (background != null) {
            return background.toURI();
        }
        return super.getBackground(object);
    }
}

