/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.computation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Pair;
import org.eclipse.emf.henshin.multicda.cda.Pushout;
import org.eclipse.emf.henshin.multicda.cda.ReasonFactory;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public class DeleteUseConflictReasonComputation<T extends Reason> {
    private Rule rule1;
    private Rule rule2;
    private Set<T> normalCRs;
    private Set<T> DUCRs;
    private static HenshinFactory factory = HenshinFactory.eINSTANCE;
    private static final String INTERSECTIONSEPERATOR = "_\ufffd_";

    public DeleteUseConflictReasonComputation(Rule rule1, Rule rule2, Set<T> normalCR, Set<T> DUCRs) {
        this.rule1 = rule1;
        this.rule2 = rule2;
        this.normalCRs = normalCR;
        this.DUCRs = DUCRs;
    }

    public Set<T> computeDeleteUseConflictReason() {
        HashSet<T> result = new HashSet<T>();
        for (Reason normal : this.normalCRs) {
            this.computeDeleteUseConflictReasons(normal, result);
        }
        result.addAll(Utils.computeCreateEdgeDeleteNode(this.DUCRs));
        return result;
    }

    private void computeDeleteUseConflictReasons(T s1, Set<T> result) {
        Rule rule12 = ((Span)s1).getRule1();
        Rule conflictRule2 = ((Span)s1).getRule2();
        Object span = null;
        if (DeleteUseConflictReasonComputation.findEmbeddingS1toK2(s1, this.rule1, this.rule2)) {
            Pushout pushout = new Pushout(this.rule1.getLhs(), (Span)s1, conflictRule2.getLhs(), false);
            if (Utils.findDanglingEdgesOfRule1(rule12, pushout.getRule1Mappings()).isEmpty() && Utils.findDanglingEdgesOfRule1(conflictRule2, pushout.getRule2Mappings()).isEmpty()) {
                span = s1;
            }
        } else {
            Set<Reason> ddSet = this.constructDeleteDeleteSet((Reason)s1);
            if (!ddSet.isEmpty()) {
                span = ReasonFactory.eINSTANCE.createSymmetricReason(s1, ddSet);
            }
        }
        if (span != null && !this.violatesForbid(span)) {
            int size = result.size() + 1;
            result.add(span);
            if (size != result.size()) {
                System.err.println("SIZE ERROR!!! size of result is " + result.size() + " but should " + size);
            }
        }
    }

    private boolean violatesForbid(T span) {
        for (Edge e : ((Span)span).getRule1().getLhs().getEdges()) {
            Mapping sM = ((Span)span).getMappingFromGraphToRule1(e.getSource());
            Mapping tM = ((Span)span).getMappingFromGraphToRule1(e.getTarget());
            if (sM == null || tM == null) continue;
            Node s2 = ((Span)span).getMappingIntoRule2(sM.getOrigin()).getImage();
            Node t2 = ((Span)span).getMappingIntoRule2(tM.getOrigin()).getImage();
            if (s2.getOutgoing(e.getType(), t2) != null) continue;
            for (NestedCondition nc : ((Span)span).getRule2().getLhs().getNACs()) {
                s2 = nc.getMappings().getImage(s2, null);
                t2 = nc.getMappings().getImage(t2, null);
                if (s2.getOutgoing(e.getType(), t2) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean findEmbeddingS1toK2(Reason s1, Rule rule1, Rule rule2) {
        BasicEList k2N = new BasicEList((Collection)rule2.getActionNodes(new Action(Action.Type.PRESERVE)));
        BasicEList k2E = new BasicEList((Collection)rule2.getActionEdges(new Action(Action.Type.PRESERVE)));
        DeleteUseConflictReasonComputation.removeDeleteAttributeNodes(rule1, rule2, (EList<Node>)k2N, (EList<Edge>)k2E);
        ArrayList<Mapping> s1tok2 = DeleteUseConflictReasonComputation.computeMappings(s1, (EList<Node>)k2N, (EList<Edge>)k2E);
        return !s1tok2.isEmpty();
    }

    private static void removeDeleteAttributeNodes(Rule rule1, Rule rule2, EList<Node> k2n, EList<Edge> k2e) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        Map<Node, Set<Pair<Attribute, Attribute>>> n1Attrs = Utils.getAttributeChanges(rule1);
        Map<Node, Set<Pair<Attribute, Attribute>>> n2Attrs = Utils.getAttributeChanges(rule2);
        for (Node n1 : n1Attrs.keySet()) {
            for (Node n2 : n2Attrs.keySet()) {
                if (Utils.identifySubNodeType(n1, n2) == null) continue;
                for (Pair<Attribute, Attribute> n1Attr : n1Attrs.get(n1)) {
                    for (Pair<Attribute, Attribute> n2Attr : n2Attrs.get(n2)) {
                        if (n1Attr.first != null && n2Attr.first != null && Utils.equalAttributes((Attribute)n1Attr.first, (Attribute)n2Attr.first)) {
                            toRemove.add(n2);
                            continue;
                        }
                        if (n1Attr.first != null || n2Attr.first != null || ((Attribute)n1Attr.second).getType() != ((Attribute)n2Attr.second).getType()) continue;
                        toRemove.add(n2);
                    }
                }
            }
        }
        k2n.removeAll(toRemove);
        for (Edge e : k2e) {
            if (toRemove.contains(e.getTarget())) {
                toRemove.add(e.getTarget());
            }
            if (!toRemove.contains(e.getSource())) continue;
            toRemove.add(e.getSource());
        }
        k2e.removeAll(toRemove);
    }

    private static ArrayList<Mapping> computeMappings(Reason s1, EList<Node> g2N, EList<Edge> g2E) {
        ArrayList<Mapping> G1toG2 = new ArrayList<Mapping>();
        boolean found = false;
        for (Node first : s1.getGraph().getNodes()) {
            found = false;
            for (Node second : g2N) {
                if (s1.getMappingIntoRule2(first).getImage() != second) continue;
                Mapping mapping = factory.createMapping(first, second);
                G1toG2.add(mapping);
                found = true;
                break;
            }
            if (found) continue;
            return new ArrayList<Mapping>();
        }
        for (Node first : s1.getGraph().getEdges()) {
            found = false;
            for (Node second : g2E) {
                if (s1.getMappingIntoRule2(first.getSource()).getImage() != second.getSource() || s1.getMappingIntoRule2(first.getTarget()).getImage() != second.getTarget()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return new ArrayList<Mapping>();
        }
        return G1toG2;
    }

    private Set<Reason> constructDeleteDeleteSet(Reason sp1) {
        TreeSet<Reason> result = new TreeSet<Reason>();
        for (Reason sp2 : this.DUCRs) {
            Pushout po;
            Pushout pushout;
            Reason l1Sl2;
            Reason s = this.compatibleSpans(sp1, sp2);
            if (s == null || this.isEmpty(s.getGraph()) || (l1Sl2 = this.computeL1SL2Span(this.rule1, pushout = new Pushout(sp1.getGraph(), s, sp2.getGraph(), false), this.rule2, s, sp1, sp2)) == null || !Utils.findDanglingEdgesOfRule1(this.rule1, (po = new Pushout(this.rule1.getLhs(), l1Sl2, this.rule2.getLhs(), false)).getRule1Mappings()).isEmpty() || !Utils.findDanglingEdgesOfRule1(this.rule2, po.getRule2Mappings()).isEmpty()) continue;
            result.add(sp2);
        }
        return result;
    }

    private Reason computeL1SL2Span(Rule rule1, Pushout pushout, Rule rule2, Reason sap, Reason sp1, Reason sp2) {
        ConflictReason.DeleteConflictReason uniqueSpan = null;
        Graph pushoutGraph = pushout.getResultGraph();
        Set<Mapping> mappingsInL1 = this.computeMappingStoL(pushout, rule1, sap, sp1, sp2);
        Set<Mapping> mappingsInL2 = this.computeMappingStoL(pushout, rule2, sap, sp2, sp1);
        uniqueSpan = new ConflictReason.DeleteConflictReason(mappingsInL1, pushoutGraph, mappingsInL2);
        uniqueSpan.setRule1(rule1);
        uniqueSpan.setRule2(rule2);
        return uniqueSpan;
    }

    private Set<Mapping> computeMappingStoL(Pushout pushout, Rule rule, Reason sap, Reason sp1, Reason sp2) {
        HashSet<Mapping> result = new HashSet<Mapping>();
        Graph pushoutGraph = pushout.getResultGraph();
        List<Mapping> s1ToS = pushout.getRule1Mappings();
        List<Mapping> s2ToS = pushout.getRule2Mappings();
        EList nodes = pushoutGraph.getNodes();
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Mapping createMapping;
            Mapping createMapping2;
            Graph lhs;
            Node lElement;
            Node s;
            Node node = s = (Node)iterator.next();
            Mapping c = this.getMappingFromSpan(node, s1ToS);
            Mapping d = this.getMappingFromSpan(node, s2ToS);
            if (c != null) {
                Node s1Element = c.getOrigin();
                Mapping e = null;
                Mapping e1 = sp1.getMappingIntoRule1(s1Element);
                Mapping e2 = sp2.getMappingIntoRule2(s1Element);
                if (e1 != null) {
                    e = e1;
                } else if (e2 != null) {
                    e = e2;
                } else {
                    return null;
                }
                lElement = e.getImage();
                lhs = rule.getLhs();
                nodes = lhs.getNodes();
                if (nodes.contains((Object)lElement)) {
                    createMapping2 = factory.createMapping(node, lElement);
                    result.add(createMapping2);
                    continue;
                }
                for (Node n : nodes) {
                    if (!n.getName().equals(lElement.getName())) continue;
                    createMapping = factory.createMapping(node, n);
                    result.add(createMapping);
                }
                continue;
            }
            if (d == null) continue;
            Node s2Element = d.getOrigin();
            Mapping f = null;
            Mapping f1 = sp2.getMappingIntoRule2(s2Element);
            Mapping f2 = sp1.getMappingIntoRule1(s2Element);
            if (f1 != null) {
                f = f1;
            } else if (f2 != null) {
                f = f2;
            } else {
                return null;
            }
            lElement = f.getImage();
            lhs = rule.getLhs();
            nodes = lhs.getNodes();
            if (nodes.contains((Object)lElement)) {
                createMapping2 = factory.createMapping(node, lElement);
                result.add(createMapping2);
                continue;
            }
            for (Node n : nodes) {
                if (!n.getName().equals(lElement.getName())) continue;
                createMapping = factory.createMapping(node, n);
                result.add(createMapping);
            }
        }
        return result;
    }

    private Mapping getMappingFromSpan(Node node, List<Mapping> mappings) {
        for (Mapping mapping : mappings) {
            if (!node.equals(mapping.getImage())) continue;
            return mapping;
        }
        return null;
    }

    private boolean isEmpty(Graph graph) {
        return graph.getNodes().isEmpty() && graph.getEdges().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Reason compatibleSpans(Reason sp1, Reason sp2) {
        Reason s1Apostrophe = this.compatibleElements(sp1, sp2);
        if (s1Apostrophe == null || s1Apostrophe.getGraph().getNodes().isEmpty()) return null;
        Reason s2Apostrophe = this.compatibleElements(sp2, sp1);
        if (s2Apostrophe == null || s2Apostrophe.getGraph().getNodes().isEmpty()) return null;
        Reason intersection = this.intersection(s1Apostrophe, s2Apostrophe);
        Graph sApostroph = intersection.getGraph();
        if (intersection == null || sApostroph == null) return null;
        return intersection;
    }

    private Reason intersection(Reason sp1, Reason sp2) {
        Graph result = factory.createGraph("S'");
        Graph graph1 = sp1.getGraph();
        Graph graph2 = sp2.getGraph();
        EList s1Nodes = graph1.getNodes();
        EList s1Edges = graph1.getEdges();
        EList s2Nodes = graph2.getNodes();
        EList s2Edges = graph2.getEdges();
        HashSet<Mapping> mappingsIntoSpan1 = new HashSet<Mapping>();
        HashSet<Mapping> mappingsIntoSpan2 = new HashSet<Mapping>();
        block0: for (Node node1 : s1Nodes) {
            for (Node node2 : s2Nodes) {
                if (!this.checkOriginNodes(node1, node2, sp1, sp2)) continue;
                Node newNode = factory.createNode(result, node1.getType(), node1.getName());
                Mapping mappingFromGraphToRule12 = sp1.getMappingIntoRule1(node1);
                Node mappingFromGraphToRule1 = mappingFromGraphToRule12.getImage();
                Mapping createMapping = factory.createMapping(newNode, mappingFromGraphToRule1);
                mappingsIntoSpan1.add(createMapping);
                Mapping mappingIntoRule2 = sp2.getMappingIntoRule1(node2);
                Node image = mappingIntoRule2.getImage();
                Mapping createMapping2 = factory.createMapping(newNode, image);
                mappingsIntoSpan2.add(createMapping2);
                continue block0;
            }
        }
        for (Edge e1 : s1Edges) {
            for (Edge e2 : s2Edges) {
                Node source1 = e1.getSource();
                Node source2 = e2.getSource();
                Node target1 = e1.getTarget();
                Node target2 = e2.getTarget();
                if (!this.checkEdges(e1, e2, sp1, sp2)) continue;
                Node source = null;
                Node target = null;
                EReference type = e1.getType();
                for (Node node : result.getNodes()) {
                    if (this.checkOriginNodes(node, source1, sp1, sp2) && this.checkOriginNodes(node, source2, sp1, sp2)) {
                        source = node;
                    }
                    if (!this.checkOriginNodes(node, target1, sp1, sp2) || !this.checkOriginNodes(node, target2, sp1, sp2)) continue;
                    target = node;
                }
                if (source == null || target == null) continue;
                factory.createEdge(source, target, type);
            }
        }
        ConflictReason.DeleteConflictReason span = new ConflictReason.DeleteConflictReason(mappingsIntoSpan1, result, mappingsIntoSpan2);
        return span;
    }

    private Reason compatibleElements(Reason sp1, Reason sp2) {
        Graph compatibleGraph = factory.createGraph("Compatible");
        EList s1Nodes = sp1.getGraph().getNodes();
        HashSet<Mapping> mappingsIntoSpan1 = new HashSet<Mapping>();
        HashSet<Mapping> mappingsIntoSpan2 = new HashSet<Mapping>();
        for (Node x : s1Nodes) {
            try {
                Node y = this.existCompatibleElement(x, sp1, sp2);
                if (y == null) continue;
                EClass xType = x.getType();
                String newName = String.valueOf(x.getName()) + INTERSECTIONSEPERATOR + y.getName();
                Node newNode = factory.createNode(compatibleGraph, xType, newName);
                Mapping createMapping = factory.createMapping(newNode, x);
                Mapping createMapping2 = factory.createMapping(newNode, y);
                mappingsIntoSpan1.add(createMapping);
                mappingsIntoSpan2.add(createMapping2);
            }
            catch (NotCompatibleException notCompatibleException) {
                return null;
            }
        }
        ConflictReason.DeleteConflictReason comSpan = new ConflictReason.DeleteConflictReason(mappingsIntoSpan1, compatibleGraph, mappingsIntoSpan2);
        return comSpan;
    }

    private Node existCompatibleElement(Node x, Reason sp1, Reason sp2) throws NotCompatibleException {
        EList s1Nodes = sp1.getGraph().getNodes();
        EList s2Nodes = sp2.getGraph().getNodes();
        if (s1Nodes.contains((Object)x)) {
            for (Node y : s2Nodes) {
                int result = this.checkEqualityR1(x, y, sp1, sp2);
                if (result == 2) {
                    return y;
                }
                if (result != 1) continue;
                throw new NotCompatibleException();
            }
            return null;
        }
        throw new NotCompatibleException();
    }

    private int checkEqualityR1(Node x, Node y, Reason sp1, Reason sp2) {
        Mapping s11 = sp1.getMappingIntoRule1(x);
        Mapping s21 = sp2.getMappingIntoRule2(y);
        Mapping s12 = sp1.getMappingIntoRule2(x);
        Mapping s22 = sp2.getMappingIntoRule1(y);
        if (s11 != null && s21 != null && s12 != null && s22 != null) {
            return (s11.getImage() == s21.getImage() ? 1 : 0) + (s12.getImage() == s22.getImage() ? 1 : 0);
        }
        return 0;
    }

    private boolean checkEdges(Edge e1, Edge e2, Reason sp1, Reason sp2) {
        EReference e1Type = e1.getType();
        Node e1Source = e1.getSource();
        Node e1target = e1.getTarget();
        EReference e2Type = e2.getType();
        Node e2Source = e2.getSource();
        Node e2target = e2.getTarget();
        if (!e1Type.equals(e2Type)) {
            return false;
        }
        if (!this.checkOriginNodes(e1Source, e2Source, sp1, sp2)) {
            return false;
        }
        return this.checkOriginNodes(e1target, e2target, sp1, sp2);
    }

    private boolean checkOriginNodes(Node originNode, Node originNode2, Reason sp1, Reason sp2) {
        return sp1.getMappingIntoRule1(originNode).getImage() == sp2.getMappingIntoRule2(originNode2).getImage() && sp1.getMappingIntoRule2(originNode).getImage() == sp2.getMappingIntoRule1(originNode2).getImage();
    }

    public static class NotCompatibleException
    extends Exception {
        private static final long serialVersionUID = 3555111140711032351L;

        public NotCompatibleException() {
            super("Ein Fehler bei der Delete Use Conflict Reason berechnung ist aufgetaucht.");
        }
    }
}

