/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.core;

import graph.Graph;
import laxcondition.Operator;
import laxcondition.Quantifier;
import nestedcondition.Formula;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.QuantifiedCondition;
import nestedcondition.True;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class NestedConditionPreparer {
    private NestedConstraint constraint;
    private NestedconditionFactory factory;

    public NestedConditionPreparer(NestedConstraint constraint) {
        this.constraint = constraint;
        this.factory = NestedconditionFactory.eINSTANCE;
    }

    public boolean prepare() {
        if (this.eliminateNotNot()) {
            return this.prepare();
        }
        if (this.eliminateImplies()) {
            return this.prepare();
        }
        if (this.eliminateEquivalent()) {
            return this.prepare();
        }
        if (this.eliminateForAll()) {
            return this.prepare();
        }
        if (this.reduceArgumentsList()) {
            return this.prepare();
        }
        return true;
    }

    private boolean reduceArgumentsList() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.reduceArg(eObject)) continue;
            return true;
        }
        return false;
    }

    public boolean eliminateForAllANotExistsC() {
        NestedCondition condition = this.constraint.getCondition();
        if (this.isOfFormForAllANotExistsC(condition)) {
            Graph startGraph = this.constraint.getDomain();
            QuantifiedCondition oldForall = (QuantifiedCondition)this.constraint.getCondition();
            Formula oldNot = (Formula)oldForall.getCondition();
            QuantifiedCondition oldExist = (QuantifiedCondition)oldNot.getArguments().get(0);
            oldNot.setDomain(startGraph);
            oldExist.setDomain(startGraph);
            oldExist.getMorphism().getNodeMappings().clear();
            oldExist.getMorphism().setFrom(startGraph);
            oldExist.getMorphism().setTo(oldExist.getCodomain());
            this.constraint.setCondition((NestedCondition)oldNot);
            System.out.println("The constraint is of form ForAllNotExist C and is refactored to Not Exists C.");
            return true;
        }
        return false;
    }

    public boolean isOfFormForAllANotExistsC(NestedCondition condition) {
        QuantifiedCondition existCondition;
        Formula notFormula;
        QuantifiedCondition forallCondition;
        NestedCondition conFormula;
        return this.isForAllCondition((EObject)condition) && this.isNotFormula((EObject)(conFormula = (forallCondition = (QuantifiedCondition)condition).getCondition())) && this.isExistCondition((EObject)(notFormula = (Formula)conFormula).getArguments().get(0)) && (existCondition = (QuantifiedCondition)notFormula.getArguments().get(0)).getCondition() instanceof True;
    }

    public boolean isOfFormNotExistsC(NestedCondition condition) {
        QuantifiedCondition existCondition;
        Formula notFormula;
        return this.isNotFormula((EObject)condition) && this.isExistCondition((EObject)(notFormula = (Formula)condition).getArguments().get(0)) && (existCondition = (QuantifiedCondition)notFormula.getArguments().get(0)).getCondition() instanceof True;
    }

    public boolean isOfFormExistsC(NestedCondition condition) {
        QuantifiedCondition existCondition;
        return this.isExistCondition((EObject)condition) && (existCondition = (QuantifiedCondition)condition).getCondition() instanceof True;
    }

    private boolean isExistCondition(EObject eObject) {
        if (eObject instanceof QuantifiedCondition) {
            QuantifiedCondition cond = (QuantifiedCondition)eObject;
            return cond.getQuantifier().equals((Object)Quantifier.EXISTS);
        }
        return false;
    }

    private boolean reduceArg(EObject eObject) {
        Formula formula;
        if ((this.isAndFormula(eObject) || this.isOrFormula(eObject)) && (formula = (Formula)eObject).getArguments().size() > 2) {
            NestedCondition arg1 = (NestedCondition)formula.getArguments().get(0);
            NestedCondition arg2 = (NestedCondition)formula.getArguments().get(1);
            Formula newFormula = this.factory.createFormula();
            newFormula.setOperator(formula.getOperator());
            newFormula.setDomain(formula.getDomain());
            formula.getArguments().set(0, (Object)newFormula);
            formula.getArguments().remove(1);
            newFormula.getArguments().add((Object)arg1);
            newFormula.getArguments().add((Object)arg2);
            return true;
        }
        return false;
    }

    private boolean eliminateForAll() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.isForAllCondition(eObject)) continue;
            QuantifiedCondition outerCondition = (QuantifiedCondition)eObject;
            NestedCondition cond = outerCondition.getCondition();
            Formula outerFormula = this.factory.createFormula();
            outerFormula.setOperator(Operator.NOT);
            outerFormula.setDomain(outerCondition.getDomain());
            EObject container = outerCondition.eContainer();
            this.insert(container, (NestedCondition)outerCondition, (NestedCondition)outerFormula);
            outerFormula.getArguments().add((Object)outerCondition);
            outerCondition.setQuantifier(Quantifier.EXISTS);
            Formula innerFormula = this.factory.createFormula();
            innerFormula.setOperator(Operator.NOT);
            innerFormula.setDomain(outerCondition.getCodomain());
            outerCondition.setCondition((NestedCondition)innerFormula);
            innerFormula.getArguments().add((Object)cond);
            return true;
        }
        return false;
    }

    private boolean eliminateEquivalent() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.isEquivalentFormula(eObject)) continue;
            Formula formula = (Formula)eObject;
            Formula firstArg = (Formula)this.getCopy((EObject)formula);
            Formula secondArg = (Formula)this.getCopy((EObject)formula);
            this.swapArguments(secondArg);
            firstArg.setOperator(Operator.IMPLIES);
            secondArg.setOperator(Operator.IMPLIES);
            formula.setOperator(Operator.AND);
            formula.getArguments().set(0, (Object)firstArg);
            formula.getArguments().set(1, (Object)secondArg);
            return true;
        }
        return false;
    }

    private void swapArguments(Formula formula) {
        NestedCondition arg1 = (NestedCondition)formula.getArguments().get(0);
        NestedCondition arg2 = (NestedCondition)formula.getArguments().get(1);
        formula.getArguments().set(0, (Object)arg2);
        formula.getArguments().set(1, (Object)arg1);
    }

    private EObject getCopy(EObject original) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject copy = copier.copy(original);
        copier.copyReferences();
        return copy;
    }

    private boolean eliminateImplies() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.isImpliesFormula(eObject)) continue;
            Formula formula = (Formula)eObject;
            NestedCondition arg1 = (NestedCondition)formula.getArguments().get(0);
            Formula notFormula = this.factory.createFormula();
            notFormula.setDomain(formula.getDomain());
            notFormula.setOperator(Operator.NOT);
            formula.setOperator(Operator.OR);
            formula.getArguments().set(0, (Object)notFormula);
            notFormula.getArguments().add((Object)arg1);
            return true;
        }
        return false;
    }

    private boolean eliminateNotNot() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            Formula formula;
            EObject eObject = (EObject)iter.next();
            if (!this.isNotFormula(eObject) || !this.isNotFormula((EObject)(formula = (Formula)eObject).getArguments().get(0))) continue;
            Formula innerFormula = (Formula)formula.getArguments().get(0);
            NestedCondition innerCondition = (NestedCondition)innerFormula.getArguments().get(0);
            EObject container = formula.eContainer();
            return this.insert(container, (NestedCondition)formula, innerCondition);
        }
        return false;
    }

    private boolean insert(EObject container, NestedCondition oldContent, NestedCondition newContent) {
        if (container instanceof NestedConstraint) {
            NestedConstraint constraint = (NestedConstraint)container;
            constraint.setCondition(newContent);
            return true;
        }
        if (container instanceof QuantifiedCondition) {
            QuantifiedCondition qlc = (QuantifiedCondition)container;
            qlc.setCondition(newContent);
            return true;
        }
        if (container instanceof Formula) {
            Formula f = (Formula)container;
            int index = f.getArguments().indexOf((Object)oldContent);
            f.getArguments().set(index, (Object)newContent);
            return true;
        }
        return false;
    }

    private boolean isNotFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.NOT);
        }
        return false;
    }

    private boolean isAndFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.AND);
        }
        return false;
    }

    private boolean isOrFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.OR);
        }
        return false;
    }

    private boolean isImpliesFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.IMPLIES);
        }
        return false;
    }

    private boolean isEquivalentFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.EQUIVALENT);
        }
        return false;
    }

    private boolean isForAllCondition(EObject eObject) {
        if (eObject instanceof QuantifiedCondition) {
            QuantifiedCondition cond = (QuantifiedCondition)eObject;
            return cond.getQuantifier().equals((Object)Quantifier.FORALL);
        }
        return false;
    }

    public NestedCondition getCondition() {
        return this.constraint.getCondition();
    }
}

