/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.ocl2gc.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import laxcondition.LaxconditionPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class TranslatorResourceSet
extends ResourceSetImpl {
    private URI baseDir;

    public TranslatorResourceSet(String baseDir) {
        EcorePackage.eINSTANCE.getName();
        LaxconditionPackage.eINSTANCE.getName();
        if (baseDir != null) {
            if (!(baseDir = new File(baseDir).getAbsolutePath()).endsWith(File.separator)) {
                baseDir = String.valueOf(baseDir) + File.separator;
            }
            this.baseDir = URI.createFileURI((String)baseDir);
            this.setURIConverter((URIConverter)new BaseDirURIConverter());
        }
    }

    public void saveEObject(EObject object, String path) {
        this.saveEObject(object, URI.createFileURI((String)path));
    }

    public void saveEObject(EObject object, URI uri) {
        Resource resource = this.createResource(uri);
        resource.getContents().clear();
        resource.getContents().add((Object)object);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        try {
            resource.save(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class BaseDirURIConverter
    extends ExtensibleURIConverterImpl {
        private BaseDirURIConverter() {
        }

        public URI normalize(URI uri) {
            if (uri.isFile() && uri.isRelative() && TranslatorResourceSet.this.baseDir != null) {
                return uri.resolve(TranslatorResourceSet.this.baseDir);
            }
            return super.normalize(uri);
        }
    }
}

