/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.Integrator;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.Lefter;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.TranslatorResourceSet;

public class GC2AppCondCommand {
    private static final String HENSHIN = ".henshin";
    private IFile henshinFile = null;
    private Rule rule = null;
    private NestedConstraint constraint;
    public long translationTime = 0L;
    public boolean enableOptimizer = false;

    public GC2AppCondCommand() {
    }

    public GC2AppCondCommand(IFile henshinFile) {
        this.henshinFile = henshinFile;
    }

    public void integrateAndleft(NestedConstraint constraint, Rule rule) {
        if (rule != null) {
            this.rule = rule;
            this.constraint = constraint;
            Module module = rule.getModule();
            EcoreUtil.Copier copy = new EcoreUtil.Copier();
            Rule ruleCopyOriginal = (Rule)copy.copy((EObject)rule);
            copy.copyReferences();
            String UpdatedRuleName = String.valueOf(rule.getName()) + "_updated_" + constraint.getName();
            if (module.getUnit(UpdatedRuleName) != null) {
                Date date = new GregorianCalendar().getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
                UpdatedRuleName = String.valueOf(UpdatedRuleName) + sdf.format(date);
            }
            rule.setName(UpdatedRuleName);
            long start = System.currentTimeMillis();
            Integrator integrator = new Integrator(constraint, rule);
            System.out.println(String.valueOf(this.getClass().getName()) + ":" + this.enableOptimizer);
            integrator.setEnableOptimizer(this.enableOptimizer);
            integrator.integrate();
            NestedCondition condition = integrator.getShiftedCondition();
            if (condition == null) {
                System.out.println("Return in The class name: " + this.getClass().getSimpleName() + "<-");
                return;
            }
            System.out.println(condition);
            System.out.println(condition.getDomain());
            constraint.setDomain(condition.getDomain());
            constraint.setCondition(condition);
            Formula existingFormula = rule.getLhs().getFormula();
            Lefter lefter = new Lefter(rule);
            lefter.enableOptimizer = this.enableOptimizer;
            lefter.left();
            this.enableOptimizer = false;
            if (existingFormula != null) {
                And henshinAnd = HenshinFactory.eINSTANCE.createAnd();
                henshinAnd.setLeft(existingFormula);
                henshinAnd.setRight(rule.getLhs().getFormula());
                rule.getLhs().setFormula((Formula)henshinAnd);
            }
            long stop = System.currentTimeMillis();
            this.translationTime = stop - start;
            module.getUnits().add((Object)ruleCopyOriginal);
            this.persistTheUpdatedRuleInPlace(module);
        }
    }

    private EList<Edge> getEdgesTypedContainment(Graph graph) {
        BasicEList containmentEdges = new BasicEList();
        for (Edge edge : graph.getEdges()) {
            if (!edge.getType().isContainment()) continue;
            containmentEdges.add((Object)edge);
        }
        return containmentEdges;
    }

    public void integrateAndleftInPlace(NestedConstraint constraint, Rule rule) {
        if (rule != null) {
            this.rule = rule;
            this.constraint = constraint;
            long start = System.currentTimeMillis();
            Integrator integrator = new Integrator(constraint, rule);
            System.out.println(String.valueOf(this.getClass().getName()) + ":" + this.enableOptimizer);
            integrator.setEnableOptimizer(this.enableOptimizer);
            integrator.integrate();
            NestedCondition condition = integrator.getShiftedCondition();
            if (condition == null) {
                System.out.println("Return in The class name: " + this.getClass().getSimpleName() + "<-");
                return;
            }
            System.out.println(condition);
            System.out.println(condition.getDomain());
            constraint.setDomain(condition.getDomain());
            constraint.setCondition(condition);
            Formula existingFormula = rule.getLhs().getFormula();
            Lefter lefter = new Lefter(rule);
            lefter.enableOptimizer = this.enableOptimizer;
            lefter.left();
            if (existingFormula != null) {
                And henshinAnd = HenshinFactory.eINSTANCE.createAnd();
                henshinAnd.setLeft(existingFormula);
                henshinAnd.setRight(rule.getLhs().getFormula());
                rule.getLhs().setFormula((Formula)henshinAnd);
            }
            long stop = System.currentTimeMillis();
            this.translationTime = stop - start;
        }
    }

    private void persistTheUpdatedRuleInPlace(Module module) {
        String path = this.henshinFile.getLocation().toOSString();
        TranslatorResourceSet resourceSet = new TranslatorResourceSet(path);
        resourceSet.saveEObject((EObject)module, path);
        try {
            this.henshinFile.getParent().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

