/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.ui.views;

import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.emf.databinding.internal.EMFObservableValueDecorator;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.wrapper.TransactionalVariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityTransactionHelper;

public class ObservableFeatureConstraintValue<T>
implements IObservableValue<String> {
    IObservableValue<String> value;
    boolean shouldUpdate;

    ObservableFeatureConstraintValue(IObservableValue<String> value) {
        this.value = value;
    }

    public Realm getRealm() {
        return this.value.getRealm();
    }

    public void addChangeListener(IChangeListener listener) {
        this.value.addChangeListener(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.value.removeChangeListener(listener);
    }

    public void addStaleListener(IStaleListener listener) {
        this.value.addStaleListener(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        this.value.removeStaleListener(listener);
    }

    public boolean isStale() {
        return this.value.isStale();
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.value.addDisposeListener(listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        this.value.removeDisposeListener(listener);
    }

    public boolean isDisposed() {
        return this.value.isDisposed();
    }

    public void dispose() {
        this.value.dispose();
    }

    public Object getValueType() {
        return this.value.getValueType();
    }

    public String getValue() {
        VariabilityRule rule = this.getTargetVariabilityRule();
        if (rule != null) {
            return rule.getFeatureConstraint();
        }
        return (String)this.value.getValue();
    }

    public void setValue(String value) {
        this.shouldUpdate = false;
        VariabilityRule rule = this.getTargetVariabilityRule();
        if (rule != null) {
            VariabilityTransactionHelper.setAnnotationValue((ModelElement)rule, (String)"featureConstraint", (String)value);
        }
        this.shouldUpdate = true;
    }

    public void addValueChangeListener(IValueChangeListener<? super String> listener) {
        this.value.addValueChangeListener(listener);
    }

    public void removeValueChangeListener(IValueChangeListener<? super String> listener) {
        this.value.removeValueChangeListener(listener);
    }

    private VariabilityRule getTargetVariabilityRule() {
        EMFObservableValueDecorator emfValue;
        if (this.value instanceof EMFObservableValueDecorator && (emfValue = (EMFObservableValueDecorator)this.value).getObserved() != null && emfValue.getObserved() instanceof Rule) {
            return TransactionalVariabilityFactory.INSTANCE.createVariabilityRule((Rule)emfValue.getObserved());
        }
        return null;
    }

    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }
}

