/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrTypeMember;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleEvent;
import agg.attribute.impl.TupleObject;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarMember;
import agg.attribute.view.impl.OpenViewSetting;
import agg.util.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

public class ValueTuple
extends TupleObject
implements AttrInstance,
AttrMsgCode {
    private static final long serialVersionUID = -8398830346220181522L;
    protected DeclTuple type;
    protected ContextView context = null;
    protected transient String errorMsg;

    public ValueTuple(AttrTupleManager manager, DeclTuple type) {
        this(manager, type, null, null);
    }

    public ValueTuple(AttrTupleManager manager, DeclTuple type, ContextView context) {
        this(manager, type, context, null);
    }

    public ValueTuple(AttrTupleManager manager, DeclTuple type, ContextView context, ValueTuple parent) {
        super(manager, null);
        this.resetContextView(context);
        this.setType(type);
        if (this.getContextView() == null) {
            this.warn("Context = null", new RuntimeException());
        }
        this.errorMsg = "";
    }

    @Override
    protected void propagateEvent(TupleEvent e) {
        OpenViewSetting myOpenView = (OpenViewSetting)this.manager.getDefaultOpenView();
        if (e.id == 10) {
            this.refreshParents();
            myOpenView.reorderTuple(this);
        }
        if (e.id == 20) {
            this.refreshParents();
            myOpenView.reorderTuple(this);
        }
        this.fireAttrChanged(e.cloneWithNewSource(this));
    }

    public void refreshParents() {
        if (this.type != null) {
            Vector memberCopy = new Vector(this.members);
            this.members.clear();
            int i = 0;
            while (i < this.type.getSize()) {
                DeclMember currentDecl = this.type.getDeclMemberAt(i);
                if (currentDecl != null) {
                    boolean oldEntry = false;
                    int j = 0;
                    while (j < memberCopy.size()) {
                        if (((ValueMember)memberCopy.get(j)).getDecl() == currentDecl) {
                            ValueMember vm = (ValueMember)memberCopy.get(j);
                            this.members.add(vm);
                            oldEntry = true;
                            break;
                        }
                        ++j;
                    }
                    if (!oldEntry) {
                        this.members.add(this.newMember(currentDecl));
                    }
                }
                ++i;
            }
        }
    }

    public void resetContextView(ContextView view) {
        this.context = view;
    }

    protected ContextView getContextView() {
        return this.context;
    }

    @Override
    protected void assignParent(TupleObject newParent) {
        super.assignParent(newParent);
        if (this.parent != null) {
            this.copyEntries((ValueTuple)this.parent);
        }
    }

    protected void setType(DeclTuple type) {
        this.type = type;
        if (this.type != null) {
            this.type.addObserver(this);
            this.adaptToType();
            if (this.parent != null) {
                this.copyEntries((AttrInstance)((Object)this.parent));
            }
        }
    }

    protected void adaptToType() {
        int i = 0;
        while (i < this.getTupleType().getSize()) {
            if (this.getTupleType().getDeclMemberAt(i) != null) {
                this.addMember(this.newMember(this.getTupleType().getDeclMemberAt(i)));
            }
            ++i;
        }
    }

    protected ValueMember newMember(DeclMember decl) {
        return new ValueMember(this, decl);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public AttrContext getContext() {
        return this.getContextView();
    }

    @Override
    public void log() {
        String line = "";
        int i = 0;
        while (i < this.getNumberOfEntries()) {
            line = String.valueOf(line) + this.getLogEntry(i);
            ++i;
        }
        this.logPrintln(line);
    }

    protected String getLogEntry(int index) {
        return "\n    " + index + ". (" + this.getTypeAsString(index) + ") " + this.getNameAsString(index) + " = " + this.getValueAsString(index);
    }

    @Override
    public DeclTuple getTupleType() {
        return this.type;
    }

    @Override
    public void updateMemberAdded(TupleEvent e) {
        if (e.getSource() instanceof DeclTuple) {
            this.addMember(this.newMember(this.getTupleType().getDeclMemberAt(e.getIndex())));
        }
        this.propagateEvent(e);
    }

    @Override
    public void updateMemberDeleted(TupleEvent e) {
        if (e.getSource() instanceof DeclTuple) {
            this.deleteMemberAt(e.getIndex());
            this.propagateEvent(e);
        }
    }

    @Override
    public void updateMemberRetyped(TupleEvent e) {
        ValueMember m;
        if (e.getSource() instanceof DeclTuple && (m = this.getValueMemberAt(e.getIndex())) != null) {
            m.typeChanged();
        }
        this.propagateEvent(e);
    }

    public void updateMemberValueChanged(TupleEvent e) {
        ValueMember val = (ValueMember)e.getSource().getMemberAt(e.getIndex());
        this.getValueMemberAt(e.getIndex()).copy(val);
        this.propagateEvent(e);
    }

    public ValueMember getValueMemberAt(int index) {
        return (ValueMember)this.getMemberAt(index);
    }

    public ValueMember getValueMemberAt(String name) {
        return (ValueMember)this.getMemberAt(name);
    }

    @Override
    public String getValueAsString(int entryIndex) {
        if (this.getMemberAt(entryIndex) != null) {
            return this.getMemberAt(entryIndex).toString();
        }
        return "";
    }

    @Override
    public void copy(AttrInstance source) {
        ValueTuple from = (ValueTuple)source;
        if (!this.type.compareTo(from.getTupleType())) {
            System.out.println("ValueTuple.copy(AttrInstance)::  Tried to copy from an AttrInstance with a different type!");
            throw new AttrImplException("Tried to copy from an AttrInstance with a different type!");
        }
        this.manager = from.manager;
        int length = from.getSize();
        int i = 0;
        while (i < length) {
            ValueMember val = this.getValueMemberAt(i);
            ValueMember valfrom = from.getValueMemberAt(i);
            if (val != null) {
                val.copy(valfrom);
                if (valfrom instanceof VarMember) {
                    ((VarMember)val).setMark(((VarMember)valfrom).getMark());
                } else if (valfrom instanceof CondMember) {
                    ((CondMember)val).setMark(((CondMember)valfrom).getMark());
                }
            }
            ++i;
        }
    }

    @Override
    public void copyEntries(AttrInstance source) {
        DeclTuple dstType;
        ValueTuple from = (ValueTuple)source;
        DeclTuple srcType = from.getTupleType();
        if (!(srcType.compareTo(dstType = this.type) || srcType.isSubclassOf(dstType) || dstType.isSubclassOf(srcType))) {
            return;
        }
        int length = Math.min(srcType.getSize(), dstType.getSize());
        int i = 0;
        while (i < length) {
            ValueMember valfrom;
            ValueMember val = this.getValueMemberAt(i);
            if (val != null && (valfrom = from.getValueMemberAt(val.getName())) != null) {
                val.copy(valfrom);
                val.setTransient(valfrom.isTransient);
            }
            ++i;
        }
    }

    public void copyEntriesToSimilarMembers(AttrInstance source) {
        DeclTuple dstType;
        ValueTuple from = (ValueTuple)source;
        DeclTuple srcType = from.getTupleType();
        if (!(srcType.compareTo(dstType = this.type) || srcType.isSubclassOf(dstType) || dstType.isSubclassOf(srcType))) {
            return;
        }
        int i = 0;
        while (i < dstType.getSize()) {
            ValueMember valfrom;
            ValueMember val = this.getValueMemberAt(i);
            if (val != null && (valfrom = from.getValueMemberAt(val.getName())) != null && val.getDeclaration().getTypeName().equals(valfrom.getDeclaration().getTypeName())) {
                val.copy(valfrom);
                val.setTransient(valfrom.isTransient);
            }
            ++i;
        }
    }

    public void adoptEntriesWhereEmpty(AttrInstance source) {
        DeclTuple dstType;
        ValueTuple from = (ValueTuple)source;
        DeclTuple srcType = from.getTupleType();
        if (!(srcType.compareTo(dstType = this.type) || srcType.isSubclassOf(dstType) || dstType.isSubclassOf(srcType))) {
            throw new RuntimeException("The specified source has a wrong type.\n");
        }
        int length = Math.min(srcType.getSize(), dstType.getSize());
        int i = 0;
        while (i < length) {
            ValueMember dst = this.getValueMemberAt(i);
            ValueMember src = from.getValueMemberAt(i);
            if (src != null && dst.isEmpty() && !src.isEmpty()) {
                dst.copy(src);
            }
            ++i;
        }
    }

    @Override
    public void unsetValue() {
        int i = 0;
        while (i < this.getSize()) {
            ValueMember val = this.getValueMemberAt(i);
            if (val.getDecl().getHoldingTuple() == this.getTupleType()) {
                val.setExpr(null);
            }
            ++i;
        }
    }

    public void unsetValueOfUsedVariable(AttrContext cntxt) {
        int i = 0;
        while (i < this.getSize()) {
            VarMember var;
            ValueMember val = this.getValueMemberAt(i);
            if (val.isSet() && val.getExpr().isVariable() && (var = cntxt.getVariables().getVarMemberAt(val.getExprAsText())) != null) {
                var.setExpr(null);
            }
            ++i;
        }
    }

    public void unsetValueAsExpr() {
        int i = 0;
        while (i < this.getSize()) {
            ValueMember val = this.getValueMemberAt(i);
            if (val.getDecl().getHoldingTuple() == this.getTupleType() && val.isSet() && val.getExpr().isComplex()) {
                val.setExpr(null);
            }
            ++i;
        }
    }

    @Override
    public void apply(AttrInstance rightSide, AttrContext attrcontext) {
        AttrContext matchContext = attrcontext;
        ValueTuple rightTuple = (ValueTuple)rightSide;
        if (matchContext == null) {
            matchContext = rightTuple.getContext();
        }
        int i = 0;
        while (i < Math.min(this.getSize(), ((ValueTuple)rightSide).getSize())) {
            ValueMember left = this.getValueMemberAt(i);
            ValueMember right = rightTuple.getValueMemberAt(left.getName());
            if (left != null && right != null) {
                left.apply(right, matchContext);
            }
            ++i;
        }
    }

    @Override
    public void apply(AttrInstance rightSide, AttrContext attrcontext, boolean allowVariableWithoutValue) {
        this.apply(rightSide, attrcontext, allowVariableWithoutValue, false);
    }

    public void apply(AttrInstance rightSide, AttrContext attrcontext, boolean allowVariableWithoutValue, boolean equalVariableName) {
        if (!allowVariableWithoutValue) {
            this.apply(rightSide, attrcontext);
            return;
        }
        AttrContext matchContext = attrcontext;
        ValueTuple rightTuple = (ValueTuple)rightSide;
        if (matchContext == null) {
            matchContext = rightTuple.getContext();
        }
        int i = 0;
        while (i < this.getSize()) {
            ValueMember left = this.getValueMemberAt(i);
            ValueMember right = rightTuple.getValueMemberAt(left.getName());
            if (left != null && right != null) {
                left.apply(right, matchContext, allowVariableWithoutValue, equalVariableName);
            }
            ++i;
        }
    }

    @Override
    public int getNumberOfFreeVariables(AttrContext ctx) {
        ContextView contview = (ContextView)ctx;
        int nFree = 0;
        Vector<String> names = new Vector<String>(10, 10);
        int i = 0;
        while (i < this.getSize()) {
            String varName;
            ValueMember val = this.getValueMemberAt(i);
            if (val != null && val.getExpr() != null && val.getExpr().isVariable() && !val.isValid() && !names.contains(varName = val.getExpr().toString())) {
                names.addElement(varName);
                if (contview == null || contview.getExpr(varName) != null) {
                    ++nFree;
                }
            }
            ++i;
        }
        return nFree;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (this.isEmpty()) {
            return;
        }
        int num = this.getSize();
        int i = 0;
        while (i < num) {
            ValueMember val = this.getValueMemberAt(i);
            if (val != null && val.isSet()) {
                h.addObject("", val, true);
            }
            ++i;
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        Enumeration<Element> en = h.getEnumeration("", null, true, "Attribute");
        while (en.hasMoreElements()) {
            String name;
            ValueMember mem;
            h.peekElement(en.nextElement());
            AttrTypeMember typeMem = (AttrTypeMember)h.getObject("type", null, false);
            if (typeMem != null && (mem = this.getValueMemberAt(name = typeMem.getName())) != null) {
                h.enrichObject(mem);
            }
            h.close();
        }
    }

    public boolean canMatchTo(ValueTuple target, ContextView attrcontext) {
        int i = 0;
        while (i < this.getSize()) {
            ValueMember src = this.getValueMemberAt(i);
            if (src != null) {
                String name = src.getName();
                ValueMember tar = target.getValueMemberAt(name);
                if (!(src.getExpr() == null && tar.getExpr() == null || src.canMatchTo(tar, attrcontext))) {
                    this.errorMsg = src.getErrorMsg();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean canMatchChild2Parent(ValueTuple target, ContextView attrcontext) {
        int i = 0;
        while (i < this.getSize()) {
            String name;
            ValueMember tar;
            ValueMember src = this.getValueMemberAt(i);
            if (!(src == null || (tar = target.getValueMemberAt(name = src.getName())) == null || src.getExpr() == null && tar.getExpr() == null || src.canMatchTo(tar, attrcontext))) {
                this.errorMsg = src.getErrorMsg();
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] matchTo(ValueTuple target, ContextView attrcontext) {
        Vector<String> matches = new Vector<String>();
        String match = null;
        if (!this.canMatchTo(target, attrcontext)) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nAttribute don't match.";
            throw new AttrImplException(9);
        }
        int i = 0;
        while (i < this.getSize()) {
            String name;
            ValueMember tar;
            ValueMember src = this.getValueMemberAt(i);
            if (src != null && (match = src.matchTo(tar = target.getValueMemberAt(name = src.getName()), attrcontext)) != null) {
                matches.addElement(match);
            }
            ++i;
        }
        Object[] assignedVariables = new String[matches.size()];
        matches.copyInto(assignedVariables);
        return assignedVariables;
    }

    public String[] matchChild2Parent(ValueTuple target, ContextView attrcontext) {
        Vector<String> matches = new Vector<String>();
        String match = null;
        if (!this.canMatchChild2Parent(target, attrcontext)) {
            this.errorMsg = String.valueOf(this.errorMsg) + "\nAttribute don't match.";
            throw new AttrImplException(9);
        }
        int i = 0;
        while (i < this.getSize()) {
            String name;
            ValueMember tar;
            ValueMember src = this.getValueMemberAt(i);
            if (src != null && (tar = target.getValueMemberAt(name = src.getName())) != null && (match = src.matchTo(tar, attrcontext)) != null) {
                matches.addElement(match);
            }
            ++i;
        }
        Object[] assignedVariables = new String[matches.size()];
        matches.copyInto(assignedVariables);
        return assignedVariables;
    }

    @Override
    public void logPrintln(boolean logTopic, String msg) {
        super.logPrintln(logTopic, msg);
        if (logTopic) {
            int i = 0;
            while (i < this.getSize()) {
                System.out.println(this.getValueMemberAt(i));
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + " ";
        int i = 0;
        while (i < this.getSize()) {
            result = String.valueOf(result) + this.getValueMemberAt(i) + "  ";
            ++i;
        }
        return result;
    }

    public void setValueAt(String valueText, int index) {
        if (this.getValueMemberAt(index) != null) {
            this.getValueMemberAt(index).setExprAsText(valueText);
        }
    }

    public void setValueAt(ValueMember value, int index) {
        if (this.getValueMemberAt(index) != null) {
            this.getValueMemberAt(index).copy(value);
        }
    }

    @Override
    public boolean isValueSetAt(String name) {
        if (this.getValueMemberAt(name) != null) {
            return !this.getValueMemberAt(name).isEmpty();
        }
        return false;
    }

    public boolean isValueSetAt(int index) {
        if (this.getValueMemberAt(index) != null) {
            return !this.getValueMemberAt(index).isEmpty();
        }
        return false;
    }

    @Override
    public Object getValueAt(String name) {
        if (this.getValueMemberAt(name) != null) {
            return this.getValueMemberAt(name).getExprAsObject();
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, String name) {
        if (this.getValueMemberAt(name) != null) {
            this.getValueMemberAt(name).setExprAsObject(value);
        }
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.getSize()) {
            if (!this.getValueMemberAt(i).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void setExprValueAt(String expr, String name) {
        if (this.getValueMemberAt(name) != null) {
            this.getValueMemberAt(name).setExprAsEvaluatedText(expr);
        }
    }

    @Override
    public void setExprAt(String expr, String name) {
        if (this.getValueMemberAt(name) != null) {
            this.getValueMemberAt(name).setExprAsText(expr);
        }
    }

    public ValueMember getEntryAt(int index) {
        return this.getValueMemberAt(index);
    }

    public ValueMember getEntryAt(String name) {
        return this.getValueMemberAt(name);
    }

    public ValueMember getEntryWithValueAsText(String valueText) {
        int i = 0;
        while (i < this.getSize()) {
            ValueMember member = this.getValueMemberAt(i);
            if (member.isSet() && member.getExprAsText().equals(valueText)) {
                return member;
            }
            ++i;
        }
        return null;
    }

    public Vector<String> getAllVariableNamesOfExpressions() {
        Vector<String> resultVector = new Vector<String>();
        int i = 0;
        while (i < this.getSize()) {
            ValueMember member = this.getValueMemberAt(i);
            if (member.isSet() && member.getExpr().isComplex()) {
                Vector<String> names = member.getAllVariableNamesOfExpression();
                int j = 0;
                while (j < names.size()) {
                    String name = names.elementAt(j);
                    if (!resultVector.contains(name)) {
                        resultVector.addElement(name);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resultVector;
    }

    public Vector<String> getAllVariableNames() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.getNumberOfEntries()) {
            ValueMember member = this.getValueMemberAt(i);
            Vector<String> names = member.getAllVariableNamesOfExpression();
            int j = 0;
            while (j < names.size()) {
                String name = names.elementAt(j);
                if (!result.contains(name)) {
                    result.addElement(name);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean compareTo(AttrInstance another) {
        ValueTuple vt = (ValueTuple)another;
        if (!this.type.compareTo(vt.getTupleType())) {
            return false;
        }
        int length = this.getSize();
        int i = 0;
        while (i < length) {
            ValueMember v = this.getValueMemberAt(i);
            ValueMember v1 = vt.getValueMemberAt(i);
            if (v.getExpr() != null || v1.getExpr() != null) {
                if (v.getExpr() == null && v1.getExpr() != null) {
                    return false;
                }
                if (v.getExpr() != null && v1.getExpr() == null) {
                    return false;
                }
                if (!v.getExpr().equals(v1.getExpr())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void reflectTransientFrom(AttrInstance another) {
        ValueTuple vt = (ValueTuple)another;
        int length = this.getSize();
        int i = 0;
        while (i < length) {
            ValueMember v = this.getValueMemberAt(i);
            ValueMember v1 = vt.getValueMemberAt(v.getName());
            if (v1 != null && v1.isTransient) {
                v.setTransient(true);
            }
            ++i;
        }
    }

    public void showValue() {
        System.out.println("Attribute tuple value: ");
        int i = 0;
        while (i < this.getSize()) {
            ValueMember v = this.getValueMemberAt(i);
            if (v != null) {
                System.out.println(String.valueOf(v.getDeclaration().getTypeName()) + " : " + v.getName() + " : " + v.getExpr());
            }
            ++i;
        }
        System.out.println("================================");
    }
}

