/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdRule;
import agg.gui.AGGAppl;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.dialog.FormulaGraphGUI;
import agg.gui.treeview.nodedata.ApplFormulaTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.path.GrammarTreeNode;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.agt.MultiRule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MultiRulePopupMenu
extends JPopupMenu {
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    GraGraTreeNodeData data;
    EdRule rule;
    int posX;
    int posY;
    private JMenuItem miDelete;
    private JMenuItem miDisabled;
    private JMenuItem miAC;
    private JMenuItem miAC1;
    private JMenuItem miFormula;
    private JMenuItem miNAC;
    private JMenuItem miNAC1;
    private JMenuItem miPAC;
    private JMenuItem miComment;
    private JMenuItem miAttrContext;

    public MultiRulePopupMenu(GraGraTreeView tree) {
        super("Multi Rule");
        this.treeView = tree;
        this.miAC = this.add(new JMenuItem("New GAC (General Application Condition)"));
        this.miAC.setActionCommand("newNestedAC");
        this.miAC.addActionListener(this.treeView.getActionAdapter());
        this.miAC1 = new JMenuItem("Make GAC due to RHS");
        this.add(this.miAC1);
        this.miAC1.setActionCommand("makeGACFromRHS");
        this.miAC1.addActionListener(this.treeView.getActionAdapter());
        this.miFormula = this.add(new JMenuItem("Set Formula above GACs"));
        this.miFormula.setActionCommand("setFormulaAboveACs");
        this.miFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiRulePopupMenu.this.setFormula();
            }
        });
        this.addSeparator();
        this.miNAC = this.add(new JMenuItem("New NAC                                 Shift+Alt+N"));
        this.miNAC.setActionCommand("newNAC");
        this.miNAC.addActionListener(this.treeView.getActionAdapter());
        this.miNAC1 = this.add(new JMenuItem("Make NAC due to RHS               "));
        this.miNAC1.setActionCommand("makeNACFromRHS");
        this.miNAC1.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miPAC = this.add(new JMenuItem("New PAC                                 "));
        this.miPAC.setActionCommand("newPAC");
        this.miPAC.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miAttrContext = this.add(new JMenuItem("Attribute Context"));
        this.miAttrContext.setActionCommand("attrContext");
        this.miAttrContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AGGAppl)MultiRulePopupMenu.this.treeView.getFrame()).getGraGraEditor().loadRuleAttrContextInEditor(MultiRulePopupMenu.this.rule);
            }
        });
        this.addSeparator();
        this.miDelete = this.add(new JMenuItem("Delete                                              Delete"));
        this.miDelete.setActionCommand("deleteRule");
        this.miDelete.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miDisabled = new JCheckBoxMenuItem("disabled");
        this.miDisabled.setActionCommand("disableRule");
        this.miDisabled.addActionListener(this.treeView.getActionAdapter());
        this.add(this.miDisabled);
        this.addSeparator();
        this.miComment = this.add(new JMenuItem("Textual Comments"));
        this.miComment.setActionCommand("commentRule");
        this.miComment.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        int pl;
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && (pl = this.treeView.getTree().getPathForLocation(x, y).getPath().length) == 4) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.data = (GraGraTreeNodeData)this.node.getUserObject();
            this.rule = this.treeView.getRule((DefaultMutableTreeNode)this.path.getLastPathComponent());
            if (this.rule != null && this.rule.getBasisRule() instanceof MultiRule) {
                GrammarTreeNode.expand(this.treeView, this.node, this.path);
                this.posX = x;
                this.posY = y;
                return true;
            }
        }
        return false;
    }

    void setFormula() {
        block2: {
            String f;
            boolean formulaChanged;
            String ownerName = "rule : " + this.rule.getBasisRule().getName();
            FormulaGraphGUI d = new FormulaGraphGUI(this.treeView.getFrame(), ownerName, " Graph editor of Formula above General Application Conditions ", " An empty graph is the case where all nodes are connected by AND.", true);
            d.setExportJPEG(this.treeView.getGraphicsExportJPEG());
            String oldformula = this.rule.getBasisRule().getFormulaStr();
            List<EdNestedApplCond> allNestedACs = this.rule.getEnabledACs();
            List<NestedApplCond> list = this.makeFrom(allNestedACs);
            d.setVarsAsObjs(allNestedACs, oldformula);
            d.setLocation(this.posX + 20, this.posY + 20);
            while (true) {
                d.setVisible(true);
                if (d.isCanceled()) break block2;
                formulaChanged = d.isChanged();
                f = d.getFormula();
                if (this.rule.getBasisRule().setFormula(f, list)) break;
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "The formula definition failed. Please correct.", " Formula failed ", 2);
            }
            f = this.rule.getBasisRule().getFormulaStr();
            if (formulaChanged) {
                this.insertFormulaIntoRuleTreeNode(f, allNestedACs);
                this.rule.getGraGra().setChanged(true);
            }
        }
    }

    private List<NestedApplCond> makeFrom(List<EdNestedApplCond> list) {
        Vector<NestedApplCond> result = new Vector<NestedApplCond>(list.size(), 0);
        int i = 0;
        while (i < list.size()) {
            result.add(list.get(i).getNestedMorphism());
            ++i;
        }
        return result;
    }

    void insertFormulaIntoRuleTreeNode(String f, List<EdNestedApplCond> allVarsObj) {
        Object child;
        if (f.length() > 0 && (child = this.treeView.getTreeModel().getChild(this.node, 0)) != null) {
            if (((GraGraTreeNodeData)((DefaultMutableTreeNode)child).getUserObject()).isApplFormula()) {
                this.treeView.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)child);
            }
            if (!"true".equals(f)) {
                ApplFormulaTreeNodeData conddata = new ApplFormulaTreeNodeData(f, true, this.rule);
                conddata.setString(f);
                DefaultMutableTreeNode condnode = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condnode);
                this.treeView.getTreeModel().insertNodeInto(condnode, this.node, 0);
            }
        }
    }
}

