/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTextualComment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TypeGraphPopupMenu
extends JPopupMenu {
    private JMenuItem disabled;
    private JMenuItem enabledInheritance;
    private JMenuItem enabled;
    private JMenuItem enabledMax;
    private JMenuItem enabledMaxMin;
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    EdGraph graph;

    public TypeGraphPopupMenu(GraGraTreeView tree) {
        super("Type Graph");
        this.treeView = tree;
        ButtonGroup states = new ButtonGroup();
        this.disabled = new JRadioButtonMenuItem("disabled");
        this.disabled.setActionCommand("checkTypeGraph.DISABLED");
        this.disabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeGraphPopupMenu.this.setTypeGraphLevel(0);
            }
        });
        states.add(this.disabled);
        this.add(this.disabled);
        this.enabled = new JRadioButtonMenuItem("enabled");
        this.enabled.setActionCommand("checkTypeGraph.ENABLED");
        this.enabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeGraphPopupMenu.this.setTypeGraphLevel(10);
            }
        });
        states.add(this.enabled);
        this.add(this.enabled);
        this.enabledMax = new JRadioButtonMenuItem("enabled with max");
        this.enabledMax.setActionCommand("checkTypeGraph.ENABLED_MAX");
        this.enabledMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeGraphPopupMenu.this.setTypeGraphLevel(20);
            }
        });
        states.add(this.enabledMax);
        this.add(this.enabledMax);
        this.enabledMaxMin = new JRadioButtonMenuItem("enabled with min and max");
        this.enabledMaxMin.setActionCommand("checkTypeGraph.ENABLED_MAX_MIN");
        this.enabledMaxMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeGraphPopupMenu.this.setTypeGraphLevel(30);
            }
        });
        states.add(this.enabledMaxMin);
        this.add(this.enabledMaxMin);
        this.addSeparator();
        JMenuItem mi = this.add(new JMenuItem("Delete                  Delete"));
        mi.setActionCommand("deleteTypeGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TypeGraphPopupMenu.this.treeView.hasMultipleSelection()) {
                    TypeGraphPopupMenu.this.treeView.delete("selected");
                } else {
                    TypeGraphPopupMenu.this.treeView.deleteTypeGraph(TypeGraphPopupMenu.this.node, TypeGraphPopupMenu.this.path, true);
                }
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentTypeGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeGraphPopupMenu.this.editComments();
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && this.treeView.getTree().getPathForLocation(x, y).getPath().length == 3) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.graph = this.treeView.getGraph(this.node);
            EdGraGra gragra = this.treeView.getGraGra((DefaultMutableTreeNode)this.path.getPathComponent(1));
            if (this.graph != null && this.graph.isTypeGraph() && gragra != null) {
                int level = gragra.getLevelOfTypeGraphCheck();
                if (level == 0) {
                    this.disabled.setSelected(true);
                } else if (level == 5) {
                    this.enabledInheritance.setSelected(true);
                } else if (level == 10) {
                    this.enabled.setSelected(true);
                } else if (level == 20) {
                    this.enabledMax.setSelected(true);
                } else if (level == 30) {
                    this.enabledMaxMin.setSelected(true);
                } else {
                    this.disabled.setSelected(false);
                    this.enabledInheritance.setSelected(false);
                    this.enabled.setSelected(false);
                    this.enabledMax.setSelected(false);
                    this.enabledMaxMin.setSelected(false);
                }
                return true;
            }
        }
        return false;
    }

    public void setTypeGraphLevel(int level) {
        if (this.path != null) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getPathComponent(1);
            EdGraGra gragra = this.treeView.getGraGra(parent);
            if (gragra.getTypeSet().getBasisTypeSet().getTypeGraph() == null) {
                return;
            }
            if (this.treeView.setLevelOfTypeGraphCheck(gragra, level, true)) {
                this.treeView.updateTypeGraphTreeNode(this.node, gragra);
            }
        }
    }

    void editComments() {
        if (this.graph != null) {
            GraGraTextualComment comments;
            this.treeView.cancelCommentsEdit();
            Point p = this.treeView.getPopupMenuLocation();
            if (p == null) {
                p = new Point(200, 200);
            }
            if ((comments = new GraGraTextualComment(this.treeView.getFrame(), p.x, p.y, this.graph.getBasisGraph())) != null) {
                comments.setVisible(true);
            }
        }
    }
}

