/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MatchHelper;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.PACStarMorphism;
import agg.xt_basis.ParallelRule;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Match
extends OrdinaryMorphism
implements XMLObject {
    private Rule itsRule;
    private boolean matchValid;
    private transient NACStarMorphism itsCurrentNACstar;
    private Hashtable<OrdinaryMorphism, NACStarMorphism> itsNACstars;
    private transient PACStarMorphism itsCurrentPACstar;
    private Hashtable<OrdinaryMorphism, PACStarMorphism> itsPACstars;
    private boolean condsTIDGchecked = false;
    private boolean ignoreInParam;

    protected Match() {
    }

    protected Match(Rule rule, Graph graph) {
        super(rule.getLeft(), graph);
        this.itsAttrContext = this.itsAttrManager.newContext(1, rule.getAttrContext());
        this.itsRule = rule;
        this.itsName = "MatchOf_" + rule.getName();
        if (!rule.getNACsList().isEmpty()) {
            this.itsNACstars = new Hashtable(rule.getNACsList().size());
        }
        if (!rule.getPACsList().isEmpty()) {
            this.itsPACstars = new Hashtable(rule.getPACsList().size());
        }
    }

    @Override
    public void dispose() {
        this.condsTIDGchecked = false;
        if (this.itsNACstars != null) {
            Iterator<NACStarMorphism> nacStars = this.itsNACstars.values().iterator();
            while (nacStars.hasNext()) {
                nacStars.next().dispose();
            }
            this.itsNACstars.clear();
            this.itsCurrentNACstar = null;
        }
        if (this.itsPACstars != null) {
            Iterator<PACStarMorphism> pacStars = this.itsPACstars.values().iterator();
            while (pacStars.hasNext()) {
                pacStars.next().dispose();
            }
            this.itsPACstars.clear();
            this.itsCurrentPACstar = null;
        }
        this.itsRule = null;
        super.dispose();
    }

    @Override
    public void finalize() {
    }

    @Override
    public boolean canComplete() {
        if (this.itsCompleter.getProperties().get(0) && !(this.itsRule instanceof ParallelRule) && (this.itsOrig.getNodesCount() > this.itsImag.getNodesCount() || this.itsOrig.getArcsCount() > this.itsImag.getArcsCount())) {
            return false;
        }
        Vector<Type> origTypes = this.itsOrig.getUsedTypes();
        Vector<Type> imagTypes = this.itsImag.getUsedAndInheritedTypes();
        int i = 0;
        while (i < origTypes.size()) {
            if (!imagTypes.contains(origTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.condsTIDGchecked = false;
        if (this.itsNACstars != null) {
            Enumeration<OrdinaryMorphism> nacs = this.itsNACstars.keys();
            while (nacs.hasMoreElements()) {
                NACStarMorphism nacStar = this.itsNACstars.get(nacs.nextElement());
                nacStar.dispose();
            }
            this.itsNACstars.clear();
        }
        if (this.itsPACstars != null) {
            Enumeration<OrdinaryMorphism> pacs = this.itsPACstars.keys();
            while (pacs.hasMoreElements()) {
                PACStarMorphism pacStar = this.itsPACstars.get(pacs.nextElement());
                pacStar.dispose();
            }
            this.itsPACstars.clear();
        }
    }

    public void resetTarget(Graph g) {
        Enumeration<OrdinaryMorphism> keys;
        this.clear();
        this.itsCompleter.resetSolver(false);
        this.itsImag = g;
        this.itsCompleter.resetTypeMap(this.itsImag);
        this.typeObjectsMapChanged = true;
        if (this.itsNACstars != null) {
            keys = this.itsNACstars.keys();
            while (keys.hasMoreElements()) {
                this.itsNACstars.get(keys.nextElement()).setTarget(this.itsImag);
            }
        }
        if (this.itsPACstars != null) {
            keys = this.itsPACstars.keys();
            while (keys.hasMoreElements()) {
                this.itsPACstars.get(keys.nextElement()).setTarget(this.itsImag);
            }
        }
    }

    public final Rule getRule() {
        return this.itsRule;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getLastErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public void clearErrorMsg() {
        super.clearErrorMsg();
    }

    public boolean checkAbstractGraphObject(Type abstractNodeType) {
        Iterator<Node> en = this.itsImag.getNodesSet().iterator();
        while (en.hasNext()) {
            if (!this.getTarget().isCompleteGraph() || !abstractNodeType.isAbstract() || !en.next().getType().equals(abstractNodeType)) continue;
            return false;
        }
        return true;
    }

    public void adjustAttrInputParameter(boolean inputParameterOnly) {
        VarTuple vtR = (VarTuple)this.itsRule.getAttrContext().getVariables();
        VarTuple vtM = (VarTuple)this.itsAttrContext.getVariables();
        int i = 0;
        while (i < vtR.getNumberOfEntries()) {
            VarMember vmR = vtR.getVarMemberAt(i);
            VarMember vmM = vtM.getVarMemberAt(vmR.getName());
            if (vmM != null) {
                if (vmR.getExpr() != null) {
                    if (inputParameterOnly) {
                        if (vmR.isInputParameter()) {
                            vmM.setExprAsText(vmR.getExprAsText());
                        }
                    } else {
                        vmM.setExprAsText(vmR.getExprAsText());
                    }
                }
                vmM.setInputParameter(vmR.isInputParameter());
            }
            ++i;
        }
    }

    public void adjustAttrCondition() {
        CondTuple ctRule = (CondTuple)this.itsRule.getAttrContext().getConditions();
        CondTuple ct = (CondTuple)this.itsAttrContext.getConditions();
        int i = 0;
        while (i < ct.getNumberOfEntries()) {
            CondMember cm = ct.getCondMemberAt(i);
            CondMember cmRule = ctRule.getCondMemberAt(i);
            if (cm != null && cmRule != null && cm.getExprAsText().equals(cmRule.getExprAsText())) {
                cm.setMark(cmRule.getMark());
                cm.setEnabled(cmRule.isEnabled());
            }
            ++i;
        }
    }

    public void unsetInputParameter(boolean inputParameterOnly) {
        VarTuple vt = (VarTuple)this.itsAttrContext.getVariables();
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            VarMember vm = vt.getVarMemberAt(i);
            if (inputParameterOnly) {
                if (vm.isInputParameter()) {
                    vm.setExpr(null);
                }
            } else {
                vm.setExpr(null);
            }
            ++i;
        }
    }

    public void allowToIgnoreInputParameter(boolean b) {
        this.ignoreInParam = b;
    }

    public boolean allowedToIgnoreInputParameter() {
        return this.ignoreInParam;
    }

    public void resetVariableDomainOfCompletionStrategy(boolean b) {
        this.itsCompleter.resetVariableDomain(b);
    }

    @Override
    public void setCompletionStrategy(MorphCompletionStrategy s, boolean rewrite) {
        super.setCompletionStrategy(s, rewrite);
        if (this.itsRule != null) {
            this.itsCompleter.enableParallelSearch(this.itsRule.parallelMatching);
            this.itsCompleter.setStartParallelSearchByFirst(this.itsRule.startParallelMatchByFirstCSPVar);
        }
    }

    @Override
    public void setCompletionStrategy(MorphCompletionStrategy s) {
        super.setCompletionStrategy(s);
        if (this.itsRule != null) {
            this.itsCompleter.enableParallelSearch(this.itsRule.parallelMatching);
            this.itsCompleter.setStartParallelSearchByFirst(this.itsRule.startParallelMatchByFirstCSPVar);
        }
    }

    private void adjustCompletionStrategy() {
        if (this.typeObjectsMapChanged) {
            if (this.itsRule.parallelMatching) {
                this.itsCompleter.reset();
                this.itsTouchedFlag = false;
                this.itsCompleter.resetSolverVariables();
                this.itsCompleter.resetSolverQuery_Type();
            } else {
                this.itsCompleter.resetVariableDomain(true);
                this.itsCompleter.reinitializeSolver(false);
            }
            this.typeObjectsMapChanged = false;
        } else if (this.itsRule.parallelMatching && this.itsRule.startParallelMatchByFirstCSPVar) {
            this.itsCompleter.reset();
            this.itsTouchedFlag = false;
            this.itsCompleter.resetSolverVariables();
        }
        if (this.partialMorphCompletion) {
            this.itsCompleter.setPartialMorphism(this);
            this.partialMorphCompletion = false;
        }
    }

    @Override
    public boolean nextCompletionWithConstantsChecking() {
        this.adjustCompletionStrategy();
        boolean result = super.nextCompletion();
        return result;
    }

    @Override
    public boolean nextCompletionWithConstantsAndVariablesChecking() {
        this.adjustCompletionStrategy();
        boolean result = super.nextCompletion();
        return result;
    }

    public boolean areTotalIdentDanglAttrGluingSatisfied() {
        boolean res = true;
        if (!this.isTotal()) {
            this.errorMsg = "Match is not total!";
            res = false;
        } else if (!this.isIdentSatisfied()) {
            this.errorMsg = "Identification condition is violated!";
            res = false;
        } else if (!this.isDanglingSatisfied()) {
            this.errorMsg = "Dangling condition is violated!";
            res = false;
        } else if (!this.attributesOfGlueObjectsCorrect()) {
            this.errorMsg = "Non-injective match failed!\n" + this.errorMsg;
            res = false;
        }
        this.condsTIDGchecked = true;
        this.matchValid = res;
        return res;
    }

    public boolean areTotalIdentDanglSatisfied() {
        boolean res = true;
        if (!this.isTotal()) {
            this.errorMsg = "Match is not total!";
            res = false;
        } else if (!this.isIdentSatisfied()) {
            this.errorMsg = "Identification condition is violated!";
            res = false;
        } else if (!this.isDanglingSatisfied()) {
            this.errorMsg = "Dangling condition is violated!";
            res = false;
        }
        return res;
    }

    public boolean isParallelArcSatisfied() {
        if (!this.itsOrig.getTypeSet().isArcParallel() && this.itsRule.isCreating()) {
            for (Arc a : this.itsRule.getImage().getArcsSet()) {
                if (!this.itsRule.isArcCreating(a)) continue;
                Enumeration<GraphObject> enSrc = this.itsRule.getInverseImage(a.getSource());
                while (enSrc.hasMoreElements()) {
                    Enumeration<GraphObject> enTar = this.itsRule.getInverseImage(a.getTarget());
                    while (enTar.hasMoreElements()) {
                        Node src = (Node)enSrc.nextElement();
                        Node tar = (Node)enTar.nextElement();
                        if (src.hasArc(a.getType(), tar)) {
                            if (this.itsRule.isArcDeleting(src, a.getType(), tar)) continue;
                            this.errorMsg = "No parallel edges allowed.";
                            return false;
                        }
                        if (((Node)this.getImage(src)).hasArc(a.getType(), (Node)this.getImage(tar))) {
                            this.errorMsg = "No parallel edges allowed.";
                            return false;
                        }
                        if (this.getImage().getTypeSet().isArcDirected() || !((Node)this.getImage(tar)).hasArc(a.getType(), (Node)this.getImage(src))) continue;
                        this.errorMsg = "No parallel edges allowed.";
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public final boolean isValid() {
        return this.isValid(false);
    }

    @Override
    public boolean nextCompletion() {
        TypeError error;
        if (this.getOriginal().getTypeSet().getLevelOfTypeGraphCheck() == 30 && (error = this.itsRule.checkNewNodeRequiresArc()) != null) {
            this.errorMsg = error.getMessage();
            return false;
        }
        this.adjustCompletionStrategy();
        boolean result = super.nextCompletion();
        return result;
    }

    public final boolean isValid(boolean allowVariables) {
        boolean result;
        if (!this.condsTIDGchecked) {
            this.matchValid = this.areTotalIdentDanglAttrGluingSatisfied();
        }
        if (result = this.matchValid) {
            int typeLevel = this.getImage().getTypeSet().getLevelOfTypeGraphCheck();
            if (typeLevel > 10 && this.getRule().getConstraints().isEmpty() && this.itsRule.isInjective() && this.isInjective()) {
                result = this.isTypeMultiplicitySatisfied();
            }
            if (result && (!this.getRule().getConstraints().isEmpty() || !this.itsRule.isInjective() && typeLevel > 10) || !this.isInjective() && typeLevel > 10) {
                OrdinaryMorphism isocopy = this.getImage().isomorphicCopy();
                if (isocopy != null) {
                    isocopy.getImage().setName(this.getImage().getName());
                    isocopy.getImage().setCompleteGraph(this.getImage().isCompleteGraph());
                    OrdinaryMorphism com = this.compose(isocopy);
                    if (com != null) {
                        Match m2 = BaseFactory.theFactory().makeMatch(this.getRule(), com);
                        OrdinaryMorphism comatch = null;
                        if (m2 != null) {
                            comatch = this.makeTestStep(m2, allowVariables);
                            if (comatch == null) {
                                result = false;
                            } else {
                                result = result && this.isConsistent(comatch, m2);
                                comatch.dispose();
                            }
                            m2.dispose();
                        }
                        com.dispose();
                    } else {
                        result = false;
                    }
                    isocopy.dispose(false, true);
                    if (typeLevel > 10) {
                        this.getTarget().getTypeSet().setLevelOfTypeGraphCheck(10);
                    }
                    this.getTarget().getTypeSet().setLevelOfTypeGraphCheck(typeLevel);
                } else {
                    result = false;
                }
            }
        }
        this.matchValid = result;
        if (this.matchValid) {
            this.clearErrorMsg();
        }
        return this.matchValid;
    }

    public boolean checkAttrCondition() {
        CondTuple conds = (CondTuple)this.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isEnabled() && cond.getMark() == 0 && cond.isDefinite() && !cond.isTrue()) {
                this.errorMsg = "Attribute condition  [ " + cond.getExprAsText() + " ]  failed.";
                ((VarTuple)this.getAttrContext().getVariables()).unsetVariables();
                this.removeAllMappings();
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean areGACsSatisfied() {
        return this.itsRule.evalFormula();
    }

    public boolean areNACsSatisfied() {
        if (this.getCompletionStrategy().getProperties().get(3)) {
            List<OrdinaryMorphism> nacs = this.itsRule.getNACsList();
            int l = 0;
            while (l < nacs.size()) {
                OrdinaryMorphism nac = nacs.get(l);
                if (nac.isEnabled() && this.checkNAC(nac) != null) {
                    this.errorMsg = "NAC  \"" + nac.getName() + "\"  is violated!";
                    return false;
                }
                ++l;
            }
        }
        return true;
    }

    public boolean arePACsSatisfied() {
        if (this.getCompletionStrategy().getProperties().get(4)) {
            List<OrdinaryMorphism> pacs = this.itsRule.getPACsList();
            int l = 0;
            while (l < pacs.size()) {
                OrdinaryMorphism pac = pacs.get(l);
                if (pac.isEnabled() && this.checkPAC(pac) == null) {
                    this.errorMsg = "PAC  \"" + pac.getName() + "\"  is violated!";
                    return false;
                }
                ++l;
            }
        }
        return true;
    }

    public boolean areNACsSatisfied(boolean withVars) {
        if (withVars) {
            if (this.getCompletionStrategy().getProperties().get(3)) {
                List<OrdinaryMorphism> nacs = this.itsRule.getNACsList();
                int l = 0;
                while (l < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(l);
                    if (nac.isEnabled() && this.checkNAC(nac, true) != null) {
                        this.errorMsg = "NAC  \"" + nac.getName() + "\"  is violated!";
                        return false;
                    }
                    ++l;
                }
            }
            return true;
        }
        return this.areNACsSatisfied();
    }

    public boolean arePACsSatisfied(boolean withVars) {
        if (withVars) {
            if (this.getCompletionStrategy().getProperties().get(4)) {
                List<OrdinaryMorphism> pacs = this.itsRule.getPACsList();
                int l = 0;
                while (l < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(l);
                    if (pac.isEnabled() && this.checkPAC(pac, true) == null) {
                        this.errorMsg = "PAC  \"" + pac.getName() + "\"  is violated!";
                        return false;
                    }
                    ++l;
                }
            }
            return true;
        }
        return this.arePACsSatisfied();
    }

    public final Morphism checkNAC(OrdinaryMorphism nac) {
        this.itsCurrentNACstar = this.itsNACstars.get(nac);
        if (this.itsCurrentNACstar == null) {
            this.itsCurrentNACstar = MatchHelper.createNACstar(nac, this);
            this.itsNACstars.put(nac, this.itsCurrentNACstar);
        } else {
            this.itsCurrentNACstar.reinit(this.getAttrContext());
        }
        Morphism m = MatchHelper.checkNACStar(this.itsCurrentNACstar, nac, this, false);
        if (m != null) {
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  is violated!";
        }
        return m;
    }

    public final Morphism checkNAC(OrdinaryMorphism nac, boolean withVars) {
        if (withVars) {
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(true);
        }
        this.itsCurrentNACstar = this.itsNACstars.get(nac);
        if (this.itsCurrentNACstar == null) {
            this.itsCurrentNACstar = MatchHelper.createNACstar(nac, this, withVars);
            this.itsNACstars.put(nac, this.itsCurrentNACstar);
        } else {
            this.itsCurrentNACstar.reinit(this.getAttrContext());
        }
        Morphism m = MatchHelper.checkNACStar(this.itsCurrentNACstar, nac, this, withVars);
        if (withVars) {
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        }
        if (m != null) {
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  is violated!";
        }
        return m;
    }

    public final Morphism checkPAC(OrdinaryMorphism pac) {
        this.itsCurrentPACstar = this.itsPACstars.get(pac);
        if (this.itsCurrentPACstar == null) {
            this.itsCurrentPACstar = MatchHelper.createPACstar(pac, this);
            this.itsPACstars.put(pac, this.itsCurrentPACstar);
        } else {
            this.itsCurrentPACstar.reinit(this.getAttrContext());
        }
        Morphism m = MatchHelper.checkPACStar(this.itsCurrentPACstar, pac, this, false);
        if (m == null) {
            this.errorMsg = "PAC  \"" + pac.getName() + "\"  is violated!";
        }
        return m;
    }

    public final Morphism checkPAC(OrdinaryMorphism pac, boolean withVars) {
        if (withVars) {
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(true);
        }
        this.itsCurrentPACstar = this.itsPACstars.get(pac);
        if (this.itsCurrentPACstar == null) {
            this.itsCurrentPACstar = MatchHelper.createPACstar(pac, this, withVars);
            this.itsPACstars.put(pac, this.itsCurrentPACstar);
        } else {
            this.itsCurrentPACstar.reinit(this.getAttrContext());
        }
        Morphism m = MatchHelper.checkPACStar(this.itsCurrentPACstar, pac, this, withVars);
        if (withVars) {
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        }
        if (m == null) {
            this.errorMsg = "PAC  \"" + pac.getName() + "\"  is violated!";
        }
        return m;
    }

    public void enableInputParameter(boolean enable) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember vm = vars.getVarMemberAt(i);
            if (vm.isInputParameter()) {
                vm.setEnabled(enable);
                this.enableAttrConditionWithInputParameter(vm.getName(), enable);
            }
            ++i;
        }
    }

    private void enableAttrConditionWithInputParameter(String ipName, boolean enable) {
        CondTuple conds = (CondTuple)this.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getNumberOfEntries()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.getAllVariables().contains(ipName)) {
                cond.setEnabled(enable);
            }
            ++i;
        }
    }

    public void unsetVariables() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        VarTuple rulevars = (VarTuple)this.itsRule.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember vm = vars.getVarMemberAt(i);
            VarMember rulevm = rulevars.getVarMemberAt(i);
            if (!vm.isInputParameter()) {
                ((ContextView)this.getAttrContext()).removeValue(vm.getName());
                ((ContextView)this.itsRule.getAttrContext()).removeValue(rulevm.getName());
            }
            ++i;
        }
    }

    public boolean isAttrConditionSatisfied() {
        CondTuple ct = (CondTuple)this.getAttrContext().getConditions();
        int k = 0;
        while (k < ct.getSize()) {
            CondMember cm = ct.getCondMemberAt(k);
            if (cm.isEnabled() && cm.getMark() == 0 && !cm.isTrue()) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean hasInputParamInAttrCondition() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        CondTuple ct = (CondTuple)this.getAttrContext().getConditions();
        int i = 0;
        while (i < ct.getSize()) {
            CondMember cm = ct.getCondMemberAt(i);
            if (cm.isEnabled()) {
                Vector<String> names = cm.getAllVariables();
                int k = 0;
                while (k < names.size()) {
                    String n = names.get(k);
                    VarMember var = vars.getVarMemberAt(n);
                    if (var != null && var.isInputParameter()) {
                        return true;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isIdentSatisfied() {
        this.errorMsg = MatchHelper.isIdentSatisfied(this);
        return this.errorMsg == null || this.errorMsg.equals("");
    }

    public boolean isDanglingSatisfied() {
        this.errorMsg = MatchHelper.isDanglingSatisfied(this);
        return this.errorMsg == null || this.errorMsg.equals("");
    }

    @Override
    protected void checkEdgeSourceTargetCompatibility(GraphObject orig, GraphObject image) throws BadMappingException {
        MatchHelper.checkSourceTargetCompatibilityOfEdge(this, orig, image);
    }

    public boolean isTypeMultiplicitySatisfied() {
        this.errorMsg = MatchHelper.isTypeMultiplicitySatisfied(this);
        return this.errorMsg == null || this.errorMsg.equals("");
    }

    public boolean isTypeMaxMultiplicitySatisfied() {
        this.errorMsg = MatchHelper.isTypeMultiplicitySatisfied(this);
        return this.errorMsg == null || this.errorMsg.equals("");
    }

    private OrdinaryMorphism makeTestStep(Match m2, boolean allowVariables) {
        OrdinaryMorphism co_match = MatchHelper.makeTestStep(m2, allowVariables, false);
        if (co_match == null) {
            this.errorMsg = MatchHelper.errorMsg;
        }
        return co_match;
    }

    private boolean isConsistent(OrdinaryMorphism testComatch, OrdinaryMorphism testMatch) {
        this.errorMsg = MatchHelper.isConsistent(this.itsRule, testComatch, testMatch);
        return this.errorMsg == null || this.errorMsg.equals("");
    }

    private boolean attributesOfGlueObjectsCorrect() {
        this.errorMsg = MatchHelper.attributesOfGlueObjectsCorrect(this);
        return this.errorMsg == null || this.errorMsg.equals("");
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Match", this);
        this.writeMorphism(h);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Match", this)) {
            this.readMorphism(h);
            h.close();
        }
    }
}

