/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.AttrType;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.NodeTypeImpl;
import agg.xt_basis.Type;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;

public class Node
extends GraphObject
implements XMLObject {
    public boolean xyAttr = false;
    protected final LinkedHashSet<Arc> itsOutgoingArcs = new LinkedHashSet();
    protected final LinkedHashSet<Arc> itsIncomingArcs = new LinkedHashSet();

    protected Node(Type type, Graph context) {
        this.itsContext = context;
        this.itsType = type;
        this.itsContextUsage = this.hashCode();
        this.addXYPosAttrs(this.itsContext != null && this.itsContext.xyAttr);
        if (!this.itsType.isAttrTypeEmpty() && this.itsAttr == null) {
            this.itsAttr = AttrTupleManager.getDefaultManager().newInstance(this.itsType.getAttrType(), context.getAttrContext());
        }
        if (this.itsAttr != null) {
            this.itsAttr.addObserver(this);
        }
    }

    public Node(AttrInstance attr, Type type, Graph context) {
        this.itsContext = context;
        this.itsType = type;
        this.itsContextUsage = this.hashCode();
        this.itsAttr = attr;
        this.addXYPosAttrs(this.itsContext != null && this.itsContext.xyAttr);
        if (this.itsAttr != null) {
            this.itsAttr.addObserver(this);
        }
    }

    private void addXYPosAttrs(boolean xyPosAttrs) {
        if (xyPosAttrs) {
            AttrType attrType;
            this.xyAttr = true;
            if (this.itsAttr == null) {
                if (this.itsType.getAttrType() == null) {
                    ((NodeTypeImpl)this.itsType).setAttributeType(AttrTupleManager.getDefaultManager().newType());
                }
                this.itsAttr = AttrTupleManager.getDefaultManager().newInstance(this.itsType.getAttrType(), this.itsContext.getAttrContext());
            }
            if (!((DeclTuple)(attrType = this.itsType.getAttrType())).containsName("thisX")) {
                attrType.addMember(DefaultInformationFacade.self().getJavaHandler(), "int", "thisX");
            }
            if (!((DeclTuple)attrType).containsName("thisY")) {
                attrType.addMember(DefaultInformationFacade.self().getJavaHandler(), "int", "thisY");
            }
        }
    }

    protected Node(Node orig, Graph context) {
        this(orig.getType(), context);
        if (orig.getAttribute() != null) {
            if (this.itsAttr == null) {
                this.createAttributeInstance();
            }
            ((ValueTuple)this.itsAttr).copyEntries(orig.getAttribute());
        }
        if (!"".equals(orig.getObjectName())) {
            this.setObjectName(orig.getObjectName());
        }
    }

    public void dispose() {
        this.itsOutgoingArcs.clear();
        this.itsIncomingArcs.clear();
        if (this.itsAttr != null) {
            this.itsAttr.removeObserver(this);
            ((ValueTuple)this.itsAttr).dispose();
            this.itsAttr = null;
        }
        this.itsType = null;
        this.itsContext = null;
        this.itsContextUsage = -1;
    }

    public void finalize() {
    }

    protected synchronized void addOut(GraphObject obj) {
        this.itsOutgoingArcs.add((Arc)obj);
    }

    protected synchronized void addIn(GraphObject obj) {
        this.itsIncomingArcs.add((Arc)obj);
    }

    protected synchronized void removeOut(GraphObject obj) {
        this.itsOutgoingArcs.remove(obj);
    }

    protected synchronized void removeIn(GraphObject obj) {
        this.itsIncomingArcs.remove(obj);
    }

    public final int getNumberOfArcs() {
        return this.itsOutgoingArcs.size() + this.itsIncomingArcs.size();
    }

    public final Iterator<Arc> getIncomingArcs() {
        return this.itsIncomingArcs.iterator();
    }

    public final List<Arc> getIncomingArcsVec() {
        return new ArrayList<Arc>(this.itsIncomingArcs);
    }

    public final Iterator<Arc> getIncomingArcsIterator() {
        return this.itsIncomingArcs.iterator();
    }

    public final HashSet<Arc> getIncomingArcsSet() {
        return this.itsIncomingArcs;
    }

    @Override
    public final int getNumberOfIncomingArcs() {
        return this.itsIncomingArcs.size();
    }

    public final int getNumberOfIncomingArcs(Type t) {
        int n = 0;
        for (Arc go : this.itsIncomingArcs) {
            if (!go.getType().compareTo(t)) continue;
            ++n;
        }
        return n;
    }

    public final int getNumberOfIncomingArcsOfTypeFromSourceType(Type t, Type srcType) {
        int n = 0;
        for (Arc go : this.itsIncomingArcs) {
            if (!go.getType().compareTo(t) || !srcType.isParentOf(go.getSource().getType())) continue;
            ++n;
        }
        return n;
    }

    public final int getNumberOfIncomingArcs(Type t, Type src) {
        int n = 0;
        for (Arc go : this.itsIncomingArcs) {
            if (!go.getType().compareTo(t)) continue;
            if (src.isParentOf(go.getSourceType())) {
                ++n;
                continue;
            }
            if (this.itsContext.isCompleteGraph() || !go.getSourceType().isParentOf(src)) continue;
            ++n;
        }
        return n;
    }

    public final List<Arc> getIncomingArcs(Type t, Type src) {
        Vector<Arc> result = new Vector<Arc>(2);
        for (Arc go : this.itsIncomingArcs) {
            if (!go.getType().compareTo(t)) continue;
            if (src.isParentOf(go.getSourceType())) {
                result.add(go);
                continue;
            }
            if (this.itsContext.isCompleteGraph() || !go.getSourceType().isParentOf(src)) continue;
            result.add(go);
        }
        return result;
    }

    public boolean hasIncomingArcFrom(Type t) {
        for (Arc a : this.itsIncomingArcs) {
            if (!t.isParentOf(a.getSourceType()) && !a.getSourceType().isParentOf(t)) continue;
            return true;
        }
        return false;
    }

    public final Iterator<Arc> getOutgoingArcs() {
        return this.itsOutgoingArcs.iterator();
    }

    @Override
    public final int getNumberOfOutgoingArcs() {
        return this.itsOutgoingArcs.size();
    }

    public final List<Arc> getOutgoingArcsVec() {
        return new ArrayList<Arc>(this.itsOutgoingArcs);
    }

    public final HashSet<Arc> getOutgoingArcsSet() {
        return this.itsOutgoingArcs;
    }

    public final Iterator<Arc> getOutgoingArcsIterator() {
        return this.itsOutgoingArcs.iterator();
    }

    public final int getNumberOfOutgoingArcs(Type t) {
        int n = 0;
        for (Arc go : this.itsOutgoingArcs) {
            if (!go.getType().compareTo(t)) continue;
            ++n;
        }
        return n;
    }

    public final int getNumberOfOutgoingArcsOfTypeToTargetType(Type t, Type tarType) {
        int n = 0;
        for (Arc go : this.itsOutgoingArcs) {
            if (!go.getType().compareTo(t) || !tarType.isParentOf(go.getTarget().getType())) continue;
            ++n;
        }
        return n;
    }

    public final int getNumberOfOutgoingArcs(Type t, Type tar) {
        int n = 0;
        for (Arc go : this.itsOutgoingArcs) {
            if (!go.getType().compareTo(t)) continue;
            if (tar.isParentOf(go.getTargetType())) {
                ++n;
                continue;
            }
            if (this.itsContext.isCompleteGraph() || !go.getTargetType().isParentOf(tar)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasArc(Type arct, Node tar) {
        return this.getOutgoingArc(arct, tar) != null;
    }

    public final List<Arc> getOutgoingArcs(Type t, Type tar) {
        Vector<Arc> result = new Vector<Arc>(2);
        for (Arc go : this.itsOutgoingArcs) {
            if (!go.getType().compareTo(t)) continue;
            if (tar.isParentOf(go.getTargetType())) {
                result.add(go);
                continue;
            }
            if (this.itsContext.isCompleteGraph() || !go.getTargetType().isParentOf(tar)) continue;
            result.add(go);
        }
        return result;
    }

    public final Arc getOutgoingArc(Type t, Node tar) {
        for (Arc go : this.itsOutgoingArcs) {
            if (go.getTarget() != tar || !go.getType().compareTo(t)) continue;
            return go;
        }
        return null;
    }

    public boolean hasOutgoingArcTo(Type t) {
        for (Arc a : this.itsOutgoingArcs) {
            if (!t.isParentOf(a.getTargetType()) && !a.getTargetType().isParentOf(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getNumberOfInOutArcs() {
        int nb = this.itsIncomingArcs.size() + this.itsOutgoingArcs.size();
        return nb;
    }

    @Override
    public String convertToKey() {
        return this.getType().convertToKey();
    }

    @Override
    public String resetTypeKey() {
        return this.getType().resetKey();
    }

    @Override
    public boolean compareTo(GraphObject o) {
        if (!o.isNode()) {
            return false;
        }
        Node n = (Node)o;
        if (!this.itsType.isParentOf(n.getType())) {
            return false;
        }
        if (!(this.itsAttr == null && n.getAttribute() == null || this.attrExists() && n.attrExists() && this.itsAttr.compareTo(n.getAttribute()))) {
            return false;
        }
        return this.compareMultiplicityTo(n);
    }

    protected boolean compareMultiplicityTo(Node n) {
        if (this.itsContext.isTypeGraph()) {
            int n_minmax;
            int minmax = this.itsType.getSourceMin();
            if (minmax != (n_minmax = n.getType().getSourceMin())) {
                return false;
            }
            minmax = this.itsType.getSourceMax();
            if (minmax != (n_minmax = n.getType().getSourceMax())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Node", this);
        if (!this.visible) {
            h.addAttr("visible", "false");
        }
        if (!this.getObjectName().equals("")) {
            h.addAttr("name", this.getObjectName());
        }
        h.addObject("type", this.itsType, false);
        if (this.itsContext != null && this.itsContext.isTypeGraph()) {
            int minmax = this.itsType.getSourceMin();
            if (minmax != -1) {
                h.addAttr("sourcemin", Integer.toString(minmax));
            }
            if ((minmax = this.itsType.getSourceMax()) != -1) {
                h.addAttr("sourcemax", Integer.toString(minmax));
            }
        }
        h.addObject("", this.itsAttr, true);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Node", this)) {
            AttrInstance attri;
            String str = h.readAttr("visible");
            str = h.readAttr("visible");
            this.visible = !str.equals("false");
            str = h.readAttr("name");
            this.setObjectName(str);
            if (this.itsType.getAttrType() != null || this.itsType.hasInheritedAttribute() || this.itsContext != null && this.itsContext.xyAttr) {
                this.createAttributeInstance();
            }
            if ((attri = this.itsAttr) != null) {
                if (this.itsContext != null && this.itsContext.xyAttr) {
                    this.xyAttr = true;
                    AttrType attrType = this.itsType.getAttrType();
                    if (!((DeclTuple)attrType).containsName("thisX")) {
                        attrType.addMember(DefaultInformationFacade.self().getJavaHandler(), "int", "thisX");
                    }
                    if (!((DeclTuple)attrType).containsName("thisY")) {
                        attrType.addMember(DefaultInformationFacade.self().getJavaHandler(), "int", "thisY");
                    }
                }
                h.enrichObject(attri);
            }
            h.close();
            if (this.itsContext != null && this.itsContext.getAttrContext() != null && this.itsAttr != null) {
                ValueTuple value = (ValueTuple)this.itsAttr;
                int i = 0;
                while (i < value.getSize()) {
                    ValueMember val = value.getValueMemberAt(i);
                    if (val.isSet() && val.getExpr().isVariable()) {
                        ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                        VarTuple variable = (VarTuple)viewContext.getVariables();
                        VarMember var = variable.getVarMemberAt(val.getExprAsText());
                        if (this.getContext().isNacGraph()) {
                            var.setMark(2);
                        } else if (this.getContext().isPacGraph()) {
                            var.setMark(3);
                        } else if (viewContext.doesAllowComplexExpressions()) {
                            var.setMark(1);
                        } else {
                            var.setMark(0);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public final boolean isArc() {
        return false;
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    public final boolean isIsolated() {
        return this.itsOutgoingArcs.isEmpty() && this.itsIncomingArcs.isEmpty();
    }

    public String toString() {
        String result = "";
        String t = this.itsType.getStringRepr();
        result = this.itsAttr != null ? " ([" + this.hashCode() + "] " + "Node: " + t + ")  " + this.itsAttr.toString() : " ([" + this.hashCode() + "] " + "Node: " + t + ") ";
        return result;
    }

    @Override
    public void attributeChanged(AttrEvent ev) {
        if (this.itsContext != null) {
            Pair<Node, AttrEvent> p = new Pair<Node, AttrEvent>(this, ev);
            if (this.itsContext.isTypeGraph() && ev.getID() == 70) {
                this.propagateAttrValueToChildNode();
            }
            this.itsContext.propagateChange(new Change(11, p));
        }
    }

    private void propagateAttrValueToChildNode() {
        Enumeration<Type> children = this.getType().getChildren().elements();
        while (children.hasMoreElements()) {
            Node childNode;
            Type cht = children.nextElement();
            Vector<Node> chnodes = this.itsContext.getNodesByParentType(cht);
            if (chnodes == null || (childNode = (Node)chnodes.get(0)) == this) continue;
            this.setValueToChildMember(childNode);
        }
    }

    private void setValueToChildMember(Node childNode) {
        int i = 0;
        while (i < ((ValueTuple)this.itsAttr).getNumberOfEntries()) {
            ValueMember vm = ((ValueTuple)this.itsAttr).getValueMemberAt(i);
            if (vm.isSet() && childNode.getAttribute() != null && ((ValueTuple)childNode.getAttribute()).getValueAt(vm.getName()) == null) {
                ((ValueTuple)childNode.getAttribute()).setExprValueAt(vm.getExprAsText(), vm.getName());
            }
            ++i;
        }
    }

    public void propagateAttrValueFromParentNode() {
        if (!this.itsContext.isTypeGraph()) {
            return;
        }
        Enumeration<Type> parents = this.getType().getParents().elements();
        while (parents.hasMoreElements()) {
            Node parNode;
            Type part = parents.nextElement();
            Vector<Node> parnodes = this.itsContext.getNodesByParentType(part);
            if (parnodes == null || (parNode = (Node)parnodes.get(0)) == this) continue;
            this.setValueFromParentMember(parNode);
        }
    }

    private void setValueFromParentMember(Node parentNode) {
        if (parentNode.getAttribute() != null && this.itsAttr == null) {
            this.createAttributeInstance();
            int i = 0;
            while (i < ((ValueTuple)this.itsAttr).getNumberOfEntries()) {
                ValueMember vm = ((ValueTuple)this.itsAttr).getValueMemberAt(i);
                ValueMember parvm = ((ValueTuple)parentNode.getAttribute()).getValueMemberAt(vm.getName());
                if (parvm != null && !vm.isSet() && parvm.isSet()) {
                    ((ValueTuple)this.itsAttr).setExprValueAt(parvm.getExprAsText(), parvm.getName());
                }
                ++i;
            }
        }
    }
}

