/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.units;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public class SpanMappings {
    public Span span;
    public HashMap<Node, Node> rule1ToS1;
    public HashMap<Node, Node> s1ToRule1;
    public HashMap<Node, Node> rule2ToS1;
    public HashMap<Node, Node> s1ToRule2;
    private Map<Edge, Edge> edgesS1Rule1;
    private Map<Edge, Edge> edgesS1Rule2;
    private Map<Edge, Edge> edgesRule1S1;
    private Map<Edge, Edge> edgesRule2S1;

    public SpanMappings(Span span) {
        this.span = span;
        this.rule1ToS1 = new HashMap();
        this.s1ToRule1 = new HashMap();
        for (Mapping mapping : span.getMappingsInRule1()) {
            this.s1ToRule1.put(mapping.getOrigin(), mapping.getImage());
            this.rule1ToS1.put(mapping.getImage(), mapping.getOrigin());
        }
        this.rule2ToS1 = new HashMap();
        this.s1ToRule2 = new HashMap();
        for (Mapping mapping : span.getMappingsInRule2()) {
            this.s1ToRule2.put(mapping.getOrigin(), mapping.getImage());
            this.rule2ToS1.put(mapping.getImage(), mapping.getOrigin());
        }
    }

    public Map<Edge, Edge> getEdgeMappingsS1Rule1() {
        if (this.edgesS1Rule1 == null) {
            this.computeEdgeMappings();
        }
        return this.edgesS1Rule1;
    }

    public Map<Edge, Edge> getEdgeMappingsS1Rule2() {
        if (this.edgesS1Rule2 == null) {
            this.computeEdgeMappings();
        }
        return this.edgesS1Rule2;
    }

    public Map<Edge, Edge> getEdgeMappingsRule1S1() {
        if (this.edgesRule1S1 == null) {
            this.computeEdgeMappings();
        }
        return this.edgesRule1S1;
    }

    public Map<Edge, Edge> getEdgeMappingsRule2S1() {
        if (this.edgesRule2S1 == null) {
            this.computeEdgeMappings();
        }
        return this.edgesRule2S1;
    }

    public void computeEdgeMappings() {
        Edge counterpart;
        this.edgesS1Rule1 = new HashMap<Edge, Edge>();
        this.edgesRule1S1 = new HashMap<Edge, Edge>();
        EList edges = this.span.getGraph().getEdges();
        for (Edge edgeS1 : edges) {
            Node sourceRule1 = this.s1ToRule1.get(edgeS1.getSource());
            Node targetRule1 = this.s1ToRule1.get(edgeS1.getTarget());
            counterpart = null;
            for (Edge eR1 : sourceRule1.getOutgoing(edgeS1.getType())) {
                if (eR1.getTarget() != targetRule1) continue;
                counterpart = eR1;
            }
            if (counterpart == null) continue;
            this.edgesS1Rule1.put(edgeS1, counterpart);
            this.edgesRule1S1.put(counterpart, edgeS1);
        }
        this.edgesS1Rule2 = new HashMap<Edge, Edge>();
        this.edgesRule2S1 = new HashMap<Edge, Edge>();
        for (Edge eSpan : edges) {
            Node sourceRule2 = this.s1ToRule2.get(eSpan.getSource());
            Node targetRule2 = this.s1ToRule2.get(eSpan.getTarget());
            counterpart = null;
            for (Edge eR2 : sourceRule2.getOutgoing(eSpan.getType())) {
                if (eR2.getTarget() != targetRule2) continue;
                counterpart = eR2;
            }
            if (counterpart == null) continue;
            this.edgesS1Rule2.put(eSpan, counterpart);
            this.edgesRule2S1.put(counterpart, eSpan);
        }
    }
}

