/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer;

import graph.Graph;
import graph.util.extensions.GraphPrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.util.GraphAdapter;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.CopyCommand;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class HenshinNACPrinter {
    private Formula henFormula;
    private static final String HENSHIN = ".henshin";
    private StringBuffer result;
    private int openBrackets = 0;
    private boolean shortversion;
    private GraphPrinter graphPrinter;
    private Rule henRule;
    private EPackage ePackage;
    private String texfolderPath;
    private String outputFilePath;
    private boolean isRHS = false;
    public static final String RIGHTARROW = "\\hookrightarrow";

    public HenshinNACPrinter(Rule henRule, EPackage ePackage, boolean shortversion) {
        this.shortversion = shortversion;
        this.henRule = henRule;
        this.henFormula = this.henRule.getLhs().getFormula();
        this.ePackage = ePackage;
    }

    public void setHenFormula(Formula henFormula) {
        this.henFormula = henFormula;
        this.isRHS = true;
    }

    public void printDocument() {
        this.graphPrinter = new GraphPrinter(null);
        this.result = new StringBuffer(this.graphPrinter.printPreambel2());
        this.result.append("\\begin{document}\n");
        String henshinRuleNameInLatex = this.henRule.getName();
        if (henshinRuleNameInLatex.contains("_")) {
            henshinRuleNameInLatex = henshinRuleNameInLatex.replaceAll("_", "\\\\_");
        }
        String header = null;
        header = this.shortversion ? "ShortVersion" : "LongVersion";
        header = this.isRHS ? String.valueOf(header) + "-RightApplicationCondition-Rule-" : String.valueOf(header) + "-NegativeApplicationCondition-Rule-";
        this.result.append("$\\begin{array}{l} \n");
        this.printHenFormula(this.henFormula);
        for (AttributeCondition henAttributeCondition : this.henRule.getAttributeConditions()) {
            this.result.append(" " + this.cr() + "\\land" + this.cr() + " ");
            this.result.append(String.valueOf(this.left()) + " ");
            this.result.append(henAttributeCondition.getConditionText());
            this.result.append(" " + this.right());
        }
        this.result.append("\n\\end{array}$");
        this.result.append("\n\\end{document}");
        this.saveFile();
    }

    private void printHenFormula(Formula formula) {
        if (formula instanceof NestedCondition) {
            this.printHenNestedCondition((NestedCondition)formula);
        }
        if (formula instanceof UnaryFormula) {
            this.printHenUnaryFormula((UnaryFormula)formula);
        }
        if (formula instanceof BinaryFormula) {
            this.printHenBinaryFormula((BinaryFormula)formula);
        }
    }

    private void printHenNestedCondition(NestedCondition henNCond) {
        Graph printGraph;
        GraphAdapter graphAdapter;
        this.result.append("\\exists ");
        this.result.append(String.valueOf(this.left()) + " ");
        if (!this.shortversion) {
            graphAdapter = new GraphAdapter(henNCond.getHost(), this.ePackage);
            graphAdapter.adaptFromHenshin();
            printGraph = graphAdapter.getGraph();
            this.graphPrinter = new GraphPrinter(printGraph);
            this.result.append(this.graphPrinter.printGraph());
            this.result.append(" \\hookrightarrow ");
        }
        graphAdapter = new GraphAdapter(henNCond.getConclusion(), this.ePackage);
        graphAdapter.adaptFromHenshin();
        printGraph = graphAdapter.getGraph();
        this.graphPrinter = new GraphPrinter(printGraph);
        this.result.append(this.graphPrinter.printGraph());
        if (henNCond.getConclusion().getFormula() != null) {
            this.result.append(" , " + this.cr());
            this.printHenFormula(henNCond.getConclusion().getFormula());
        }
        this.result.append(" " + this.right());
    }

    private void printHenUnaryFormula(UnaryFormula formula) {
        this.result.append("\\neg ");
        this.printHenFormula(formula.getChild());
    }

    private void printHenBinaryFormula(BinaryFormula formula) {
        this.result.append(" (");
        if (formula instanceof And) {
            this.printHenFormula(formula.getLeft());
            this.result.append(" " + this.cr() + "\\land" + this.cr() + " ");
            this.printHenFormula(formula.getRight());
        }
        if (formula instanceof Or) {
            this.printHenFormula(formula.getLeft());
            this.result.append(" " + this.cr() + "\\lor" + " ");
            this.printHenFormula(formula.getRight());
        }
        if (formula instanceof Xor) {
            this.printHenFormula(formula.getLeft());
            this.result.append(" " + this.cr() + "\\veebar" + " ");
            this.printHenFormula(formula.getRight());
        }
        this.result.append(") ");
    }

    private String right() {
        --this.openBrackets;
        return "\\right)";
    }

    private String left() {
        ++this.openBrackets;
        return "\\left(";
    }

    private String cr() {
        String ret = "\n";
        int i = 0;
        while (i < this.openBrackets) {
            ret = String.valueOf(ret) + "\\right. ";
            ++i;
        }
        ret = String.valueOf(ret) + "\\cr ";
        i = 0;
        while (i < this.openBrackets) {
            ret = String.valueOf(ret) + "\\left. ";
            ++i;
        }
        return String.valueOf(ret) + "\n";
    }

    private void saveFile() {
        String nameMark = null;
        IFile ifile = null;
        try {
            ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.henRule.eResource().getURI().path()));
            nameMark = ifile.getName().replaceFirst(HENSHIN, "");
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            Date date = new GregorianCalendar().getTime();
            nameMark = String.valueOf(nameMark) + "_" + sdf.format(date);
            nameMark = this.shortversion ? String.valueOf(nameMark) + "SV" : String.valueOf(nameMark) + "LV";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (nameMark == null) {
            nameMark = this.henRule.getName();
        }
        URI uri = this.getActualProject().getLocationURI();
        this.texfolderPath = uri.getPath().concat("\\tex\\");
        File texFolderFile = new File(this.texfolderPath);
        if (!texFolderFile.exists()) {
            CopyCommand copyFileCommand = new CopyCommand(uri);
            copyFileCommand.copy();
        }
        if (this.isRHS) {
            this.outputFilePath = this.getFolderPath().concat("RAC_of_" + nameMark + ".tex");
            this.isRHS = false;
        } else {
            this.outputFilePath = this.getFolderPath().concat("NAC_of_" + nameMark + ".tex");
        }
        File file = new File(this.outputFilePath);
        Writer writer = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                writer.write(this.result.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    writer.close();
                    this.getActualProject().refreshLocal(2, null);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
                this.getActualProject().refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private IProject getActualProject() {
        IProject actualProject = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            try {
                IEditorInput input;
                IEditorPart editorPart = window.getActivePage().getActiveEditor();
                if (editorPart != null && (input = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)input;
                    actualProject = fileInput.getFile().getProject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return actualProject;
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public String getFolderPath() {
        return this.texfolderPath;
    }
}

