/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.henshin_text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterKind implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    IN(1, "IN", "IN"),
    OUT(2, "OUT", "OUT"),
    INOUT(3, "INOUT", "INOUT"),
    VAR(4, "VAR", "VAR");

    public static final int UNKNOWN_VALUE = 0;
    public static final int IN_VALUE = 1;
    public static final int OUT_VALUE = 2;
    public static final int INOUT_VALUE = 3;
    public static final int VAR_VALUE = 4;
    private static final ParameterKind[] VALUES_ARRAY;
    public static final List<ParameterKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterKind[]{UNKNOWN, IN, OUT, INOUT, VAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterKind get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return IN;
            }
            case 2: {
                return OUT;
            }
            case 3: {
                return INOUT;
            }
            case 4: {
                return VAR;
            }
        }
        return null;
    }

    private ParameterKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

