/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.conqat;

import java.util.List;
import org.conqat.engine.model_clones.model.IModelGraph;
import org.conqat.engine.model_clones.model.INode;
import org.conqat.engine.model_clones.model.ModelGraphMock;
import org.eclipse.emf.henshin.variability.mergein.conqat.ConqatAttributeNode;
import org.eclipse.emf.henshin.variability.mergein.conqat.ConqatEdge;
import org.eclipse.emf.henshin.variability.mergein.conqat.ConqatNode;
import org.eclipse.emf.henshin.variability.mergein.conqat.HenshinToConqatGraphElementMap;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinAttributeNode;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;

public class HenshinToConqatGraphConverter {
    HenshinToConqatGraphElementMap map;
    List<HenshinGraph> henshinGraphs;

    public HenshinToConqatGraphConverter(List<HenshinGraph> henshinGraphs, HenshinToConqatGraphElementMap map) {
        this.henshinGraphs = henshinGraphs;
        this.map = map;
    }

    public IModelGraph createConqatGraph() {
        ModelGraphMock resultGraph = new ModelGraphMock();
        for (HenshinGraph henshinGraph : this.henshinGraphs) {
            IModelGraph tempGraph = this.createConqatGraph(henshinGraph);
            resultGraph.getNodes().addAll(tempGraph.getNodes());
            resultGraph.getEdges().addAll(tempGraph.getEdges());
        }
        return resultGraph;
    }

    public IModelGraph createConqatGraph(HenshinGraph henshinGraph) {
        ModelGraphMock graph = new ModelGraphMock();
        for (HenshinNode node : henshinGraph.vertexSet()) {
            this.addNodeToGraph(node, (IModelGraph)graph);
        }
        for (HenshinEdge edge : henshinGraph.edgeSet()) {
            HenshinNode source = (HenshinNode)henshinGraph.getEdgeSource(edge);
            HenshinNode target = (HenshinNode)henshinGraph.getEdgeTarget(edge);
            this.addEdgeToGraph(edge, source, target, (IModelGraph)graph);
        }
        return graph;
    }

    private boolean addNodeToGraph(HenshinNode node, IModelGraph graph) {
        ConqatNode newNode = node instanceof HenshinAttributeNode ? new ConqatAttributeNode((HenshinAttributeNode)node) : new ConqatNode(node);
        graph.getNodes().add(newNode);
        this.map.put(node, newNode);
        return true;
    }

    private boolean addEdgeToGraph(HenshinEdge edge, HenshinNode source, HenshinNode target, IModelGraph graph) {
        INode sourceNode = this.map.get(source);
        INode targetNode = this.map.get(target);
        if (sourceNode != null && targetNode != null) {
            ConqatEdge newEdge = new ConqatEdge(edge, sourceNode, targetNode);
            graph.getEdges().add(newEdge);
            this.map.put(edge, newEdge);
            return true;
        }
        return false;
    }
}

