/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdTypeSet;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import java.util.Enumeration;
import java.util.Vector;

public class EdNAC
extends EdGraph {
    private OrdinaryMorphism morphism;
    private String name;
    private transient EdRule myRule;

    public EdNAC() {
        this.name = "Unnamed_NAC";
    }

    public EdNAC(EdTypeSet types) {
        super(types);
        this.name = "Unnamed_NAC";
    }

    public EdNAC(OrdinaryMorphism m) {
        super(m.getImage());
        this.morphism = m;
        this.name = this.getBasisGraph().getName();
        this.morphism.addObserver(this);
        this.getBasisGraph().addObserver(this);
    }

    public EdNAC(OrdinaryMorphism m, EdTypeSet types) {
        super(m.getImage(), types);
        this.morphism = m;
        this.name = this.getBasisGraph().getName();
        this.morphism.addObserver(this);
        this.getBasisGraph().addObserver(this);
    }

    @Override
    public void dispose() {
        this.morphism.deleteObserver(this);
        super.dispose();
        this.myRule = null;
        this.morphism = null;
    }

    public void setName(String str) {
        this.name = str;
        if (this.getBasisGraph() != null) {
            this.getBasisGraph().setName(str);
        }
        if (this.morphism != null) {
            this.morphism.setName(str);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EdRule getRule() {
        return this.myRule;
    }

    public void setRule(EdRule er) {
        this.myRule = er;
    }

    public OrdinaryMorphism getMorphism() {
        return this.morphism;
    }

    public EdGraphObject getImage(EdGraphObject orig) {
        GraphObject im = this.morphism.getImage(orig.getBasisObject());
        return this.findGraphObject(im);
    }

    public Vector<EdGraphObject> getOriginal(EdGraphObject image) {
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(2);
        Enumeration<GraphObject> en = this.morphism.getInverseImage(image.getBasisObject());
        while (en.hasMoreElements()) {
            GraphObject obj = en.nextElement();
            EdGraphObject go = this.myRule.getLeft().findGraphObject(obj);
            if (go == null) continue;
            vec.add(go);
        }
        return vec;
    }
}

