/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.AttrType;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.parser.ExcludePair;
import agg.parser.ExcludePairHelper;
import agg.parser.InvalidAlgorithmException;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.ConcurrentRule;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.InverseRuleConstructData;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TestStep;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DependencyPair
extends ExcludePair {
    protected boolean switchDependency;
    protected boolean makeConcurrentRules;
    protected boolean completeConcurrency = true;
    protected boolean maxOverlapping;
    protected List<ConcurrentRule> concurrentRules;
    protected OrdinaryMorphism isoRight1;
    protected OrdinaryMorphism isoLeft1;
    protected Hashtable<OrdinaryMorphism, Pair<OrdinaryMorphism, OrdinaryMorphism>> leftNAC2extLeft;
    protected Hashtable<OrdinaryMorphism, Pair<OrdinaryMorphism, OrdinaryMorphism>> leftPAC2extLeft;

    @Override
    public void dispose() {
        super.dispose();
    }

    public void enableSwitchDependency(boolean b) {
        this.switchDependency = b;
    }

    public void enableProduceConcurrentRule(boolean b) {
        this.makeConcurrentRules = b;
    }

    public void setCompleteConcurrency(boolean b) {
        this.completeConcurrency = b;
        this.maxOverlapping = !this.completeConcurrency;
    }

    public List<ConcurrentRule> getConcurrentRules() {
        return this.concurrentRules;
    }

    protected Rule makeInverseRule(Rule r) {
        Rule inverseRule;
        InverseRuleConstructData inverseConstruct = r.getInverseConstructData();
        if (inverseConstruct != null && (inverseRule = inverseConstruct.getInverseRule()) != null) {
            inverseRule.isReadyToTransform();
            this.isoLeft1 = inverseConstruct.getLorig2Rinv();
            this.isoRight1 = inverseConstruct.getRorig2Linv();
            if (r.hasNACs()) {
                this.leftNAC2extLeft = inverseConstruct.getNACsStore();
            }
            if (r.hasPACs()) {
                this.leftPAC2extLeft = inverseConstruct.getPACsStore();
            }
            if (!inverseConstruct.isExtended()) {
                if (this.extendAbstractInverseRule(r, inverseRule, this.isoRight1)) {
                    inverseConstruct.setExtended(true);
                    inverseRule.isReadyToTransform();
                    return inverseRule;
                }
                return null;
            }
            return inverseRule;
        }
        return null;
    }

    private void convertNACsLeft2Right(Rule r, Rule inverseRule, OrdinaryMorphism isoRHS) {
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int i = 0;
        while (i < nacs.size()) {
            OrdinaryMorphism nacL = nacs.get(i);
            if (r.isACShiftPossible(nacL)) {
                int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
                r.getTypeSet().setLevelOfTypeGraph(10);
                OrdinaryMorphism nacR = this.convertNACLeft2Right(r, nacL);
                r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
                if (nacR != null) {
                    Collection<TypeError> error = r.getTypeSet().checkType(nacR.getTarget());
                    if (error == null || error.isEmpty()) {
                        OrdinaryMorphism inverseNAC = BaseFactory.theFactory().createMorphism(inverseRule.getLeft(), nacR.getTarget());
                        if (!(!nacR.completeDiagram(isoRHS, inverseNAC) || nacR.isRightTotal() && nacR.doesIgnoreAttrs())) {
                            inverseNAC.setName(nacR.getName());
                            inverseNAC.setEnabled(nacL.isEnabled());
                            inverseRule.addNAC(inverseNAC);
                        }
                    } else {
                        nacR.dispose(false, true);
                    }
                }
            }
            ++i;
        }
    }

    private void replaceAttrValueFromTo(GraphObject from, GraphObject to) {
        if (from.getAttribute() != null && to.getAttribute() != null) {
            ValueTuple valuefrom = (ValueTuple)from.getAttribute();
            ValueTuple valueto = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < valuefrom.getSize()) {
                ValueMember vmfrom = valuefrom.getValueMemberAt(i);
                ValueMember vmto = valueto.getValueMemberAt(i);
                if (vmto != null) {
                    if (!vmfrom.isSet()) {
                        vmto.setExpr(null);
                    } else {
                        vmto.setExprAsText(vmfrom.getExprAsText());
                    }
                    if (!vmto.isTransient()) {
                        vmto.setTransient(vmfrom.isTransient());
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OrdinaryMorphism convertNACLeft2Right(Rule r, OrdinaryMorphism nac) {
        OrdinaryMorphism isoLHS = r.getLeft().isomorphicCopy();
        if (isoLHS == null) {
            return null;
        }
        OrdinaryMorphism extLHSbyNAC = this.extendLeftGraphByNAC(isoLHS, nac, false);
        this.applyAttrContextOfAC(extLHSbyNAC, nac);
        Graph extLeftGraph = extLHSbyNAC.getTarget();
        Match m = BaseFactory.theFactory().createMatch(r, extLeftGraph, true, "1");
        m.getTarget().setCompleteGraph(false);
        for (Node n : r.getLeft().getNodesSet()) {
            Node img = (Node)isoLHS.getImage(n);
            if (img == null) continue;
            try {
                m.addMapping(n, img);
            }
            catch (BadMappingException ex) {
                m.dispose();
                extLHSbyNAC.dispose();
                isoLHS.dispose(false, true);
                return null;
            }
        }
        for (Arc a : r.getLeft().getArcsSet()) {
            Arc img = (Arc)isoLHS.getImage(a);
            if (img == null) continue;
            try {
                m.addMapping(a, img);
            }
            catch (BadMappingException ex) {
                m.dispose();
                extLHSbyNAC.dispose();
                isoLHS.dispose(false, true);
                return null;
            }
        }
        if (!m.isTotal() || !m.isDanglingSatisfied()) {
            m.dispose();
            extLHSbyNAC.dispose();
            isoLHS.dispose(false, true);
            return null;
        }
        try {
            OrdinaryMorphism nacR = (OrdinaryMorphism)TestStep.execute(m, true, this.equalVariableNameOfAttrMapping);
            for (Arc a : r.getTarget().getArcsSet()) {
                Arc aImg = (Arc)nacR.getImage(a);
                if (r.getInverseImage(a).hasMoreElements() && nac.getImage(r.getInverseImage(a).nextElement()) != null) continue;
                try {
                    nacR.getTarget().destroyArc(aImg, false, false);
                }
                catch (TypeException ex) {
                    nacR.dispose();
                    m.dispose();
                    extLHSbyNAC.dispose();
                    isoLHS.dispose(false, true);
                    return null;
                }
            }
            for (Node n : r.getTarget().getNodesSet()) {
                Node nImg = (Node)nacR.getImage(n);
                if (r.getInverseImage(n).hasMoreElements() && nac.getImage(r.getInverseImage(n).nextElement()) != null) continue;
                try {
                    nacR.getTarget().destroyNode(nImg, false, false);
                }
                catch (TypeException ex) {
                    nacR.dispose();
                    m.dispose();
                    extLHSbyNAC.dispose();
                    isoLHS.dispose(false, true);
                    return null;
                }
            }
            for (Node n : r.getLeft().getNodesSet()) {
                Node nacNode = (Node)nac.getImage(n);
                Node convertedNode = (Node)isoLHS.getImage(n);
                if (convertedNode == null || nacNode == null) continue;
                this.replaceAttrValueFromTo(nacNode, convertedNode);
            }
            for (Arc a : r.getLeft().getArcsSet()) {
                Arc convertedArc = (Arc)isoLHS.getImage(a);
                Arc nacArc = (Arc)nac.getImage(a);
                if (convertedArc == null || nacArc == null) continue;
                this.replaceAttrValueFromTo(nacArc, convertedArc);
            }
            nacR.setName(nac.getName());
            if (this.leftNAC2extLeft != null) {
                this.leftNAC2extLeft.put(nac, new Pair<OrdinaryMorphism, OrdinaryMorphism>(isoLHS, extLHSbyNAC));
            }
            return nacR;
        }
        catch (TypeException tex) {
            m.dispose();
            extLHSbyNAC.dispose();
            isoLHS.dispose(false, true);
            return null;
        }
    }

    private void applyAttrContextOfAC(OrdinaryMorphism extLHSbyCond, OrdinaryMorphism cond) {
        this.doApplyAttrContextOfNAC_PAC(extLHSbyCond, cond.getTarget().getNodesSet().iterator());
        this.doApplyAttrContextOfNAC_PAC(extLHSbyCond, cond.getTarget().getArcsSet().iterator());
    }

    private void doApplyAttrContextOfNAC_PAC(OrdinaryMorphism extLHSbyCond, Iterator<?> objs) {
        while (objs.hasNext()) {
            GraphObject src = (GraphObject)objs.next();
            GraphObject img = extLHSbyCond.getImage(src);
            if (src.getAttribute() == null || img == null) continue;
            ValueTuple srcvt = (ValueTuple)src.getAttribute();
            ValueTuple imgvt = (ValueTuple)img.getAttribute();
            int i = 0;
            while (i < srcvt.getNumberOfEntries()) {
                ValueMember imgvm;
                ValueMember srcvm = srcvt.getValueMemberAt(i);
                if (srcvm.isSet() && (srcvm.getExpr().isVariable() || srcvm.getExpr().isConstant()) && (imgvm = imgvt.getValueMemberAt(i)) != null) {
                    imgvm.setExprAsText(srcvm.getExprAsText());
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean convertPACsLeft2Right(Rule r, Rule inverseRule, OrdinaryMorphism isoRHS) {
        List<OrdinaryMorphism> pacs = r.getPACsList();
        int i = 0;
        while (i < pacs.size()) {
            OrdinaryMorphism pacL = pacs.get(i);
            if (!pacL.isEnabled() || !r.isACShiftPossible(pacL)) return false;
            int tglevelcheck = r.getTypeSet().getLevelOfTypeGraphCheck();
            r.getTypeSet().setLevelOfTypeGraph(10);
            OrdinaryMorphism pacR = this.convertPACLeft2Right(r, pacL);
            r.getTypeSet().setLevelOfTypeGraph(tglevelcheck);
            if (pacR == null) return false;
            Collection<TypeError> error = r.getTypeSet().checkType(pacR.getTarget());
            if (error == null || error.isEmpty()) {
                OrdinaryMorphism inversePAC = BaseFactory.theFactory().createMorphism(inverseRule.getLeft(), pacR.getTarget());
                if (!(!pacR.completeDiagram(isoRHS, inversePAC) || pacR.isRightTotal() && pacR.doesIgnoreAttrs())) {
                    inversePAC.setName(pacR.getName());
                    inversePAC.setEnabled(pacL.isEnabled());
                    inverseRule.addPAC(inversePAC);
                }
            } else {
                pacR.dispose(false, true);
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OrdinaryMorphism convertPACLeft2Right(Rule r, OrdinaryMorphism pac) {
        OrdinaryMorphism isoLHS = r.getLeft().isomorphicCopy();
        if (isoLHS == null) {
            return null;
        }
        OrdinaryMorphism extLHSbyPAC = (OrdinaryMorphism)this.extendLeftGraphByPAC((OrdinaryMorphism)isoLHS, (OrdinaryMorphism)pac, (boolean)false).second;
        this.applyAttrContextOfAC(extLHSbyPAC, pac);
        Graph extLeftGraph = extLHSbyPAC.getTarget();
        Match m = BaseFactory.theFactory().createMatch(r, extLeftGraph, true, "1");
        m.getTarget().setCompleteGraph(false);
        for (Node n : r.getLeft().getNodesSet()) {
            Node img = (Node)isoLHS.getImage(n);
            if (img == null) continue;
            try {
                m.addMapping(n, img);
            }
            catch (BadMappingException ex) {
                m.dispose();
                extLHSbyPAC.dispose();
                isoLHS.dispose(false, true);
                return null;
            }
        }
        for (Arc a : r.getLeft().getArcsSet()) {
            Arc img = (Arc)isoLHS.getImage(a);
            if (img == null) continue;
            try {
                m.addMapping(a, img);
            }
            catch (BadMappingException ex) {
                m.dispose();
                extLHSbyPAC.dispose();
                isoLHS.dispose(false, true);
                return null;
            }
        }
        if (!m.isTotal() || !m.isDanglingSatisfied()) {
            m.dispose();
            extLHSbyPAC.dispose();
            isoLHS.dispose(false, true);
            return null;
        }
        try {
            OrdinaryMorphism pacR = (OrdinaryMorphism)TestStep.execute(m, true, this.equalVariableNameOfAttrMapping);
            for (Arc a : r.getTarget().getArcsSet()) {
                Arc aImg = (Arc)pacR.getImage(a);
                if (r.getInverseImage(a).hasMoreElements() && pac.getImage(r.getInverseImage(a).nextElement()) != null) continue;
                try {
                    pacR.getTarget().destroyArc(aImg, false, false);
                }
                catch (TypeException tex) {
                    pacR.dispose();
                    m.dispose();
                    extLHSbyPAC.dispose();
                    isoLHS.dispose(false, true);
                    return null;
                }
            }
            for (Node n : r.getTarget().getNodesSet()) {
                Node nImg = (Node)pacR.getImage(n);
                if (r.getInverseImage(n).hasMoreElements() && pac.getImage(r.getInverseImage(n).nextElement()) != null) continue;
                try {
                    pacR.getTarget().destroyNode(nImg, false, false);
                }
                catch (TypeException tex) {
                    pacR.dispose();
                    m.dispose();
                    extLHSbyPAC.dispose();
                    isoLHS.dispose(false, true);
                    return null;
                }
            }
            for (Node n : r.getLeft().getNodesSet()) {
                Node pacNode = (Node)pac.getImage(n);
                Node convertedNode = (Node)isoLHS.getImage(n);
                if (convertedNode == null || pacNode == null) continue;
                this.replaceAttrValueFromTo(pacNode, convertedNode);
            }
            for (Arc a : r.getLeft().getArcsSet()) {
                Arc convertedArc = (Arc)isoLHS.getImage(a);
                Arc pacArc = (Arc)pac.getImage(a);
                if (convertedArc == null || pacArc == null) continue;
                this.replaceAttrValueFromTo(pacArc, convertedArc);
            }
            pacR.setName(pac.getName());
            if (this.leftPAC2extLeft != null) {
                this.leftPAC2extLeft.put(pac, new Pair<OrdinaryMorphism, OrdinaryMorphism>(isoLHS, extLHSbyPAC));
            }
            return pacR;
        }
        catch (TypeException tex) {
            m.dispose();
            extLHSbyPAC.dispose();
            isoLHS.dispose(false, true);
            return null;
        }
    }

    private void addAttrConditionFromTo(Rule r, Rule inverseR) {
        CondTuple conds = (CondTuple)r.getAttrContext().getConditions();
        if (conds.isEmpty()) {
            return;
        }
        CondTuple condsOfInverseR = (CondTuple)inverseR.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getNumberOfEntries()) {
            CondMember cond = conds.getCondMemberAt(i);
            CondMember cm = (CondMember)condsOfInverseR.addCondition(cond.getExprAsText());
            cm.setMark(cond.getMark());
            ++i;
        }
    }

    private void adjustOverlappings(Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps, Rule r1, Rule inv_r2, Rule orig_r2, int count) {
        int i = 0;
        while (i < overlaps.size()) {
            GraphObject img2;
            GraphObject img;
            GraphObject obj;
            Enumeration<GraphObject> objs;
            OrdinaryMorphism isoRHSnew;
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pi = overlaps.get(i);
            OrdinaryMorphism m2 = (OrdinaryMorphism)((Pair)pi.first).second;
            String nb = "( " + (count + 1 + i) + " ) ";
            if (m2.getTarget().getName().indexOf("delete-") >= 0) {
                m2.getTarget().setName(String.valueOf(nb) + "deliver-delete-dependency");
                if (pi.second != null && ((OrdinaryMorphism)((Pair)pi.second).first).getSource() == inv_r2.getLeft()) {
                    isoRHSnew = BaseFactory.theFactory().createMorphism(this.isoRight1.getSource(), ((OrdinaryMorphism)((Pair)pi.second).first).getTarget());
                    objs = this.isoRight1.getDomain();
                    while (objs.hasMoreElements()) {
                        obj = objs.nextElement();
                        img = this.isoRight1.getImage(obj);
                        img2 = ((OrdinaryMorphism)((Pair)pi.second).first).getImage(img);
                        if (img2 == null) continue;
                        try {
                            isoRHSnew.addMapping(obj, img2);
                        }
                        catch (BadMappingException badMappingException) {
                            // empty catch block
                        }
                    }
                    ((Pair)pi.second).first = isoRHSnew;
                }
            } else if (m2.getTarget().getName().indexOf("-forbid") >= 0) {
                m2.getTarget().setName(String.valueOf(nb) + "forbid-produce-dependency");
                List<OrdinaryMorphism> nacs = orig_r2.getNACsList();
                int j = 0;
                while (j < nacs.size()) {
                    OrdinaryMorphism extLHS;
                    OrdinaryMorphism nac = nacs.get(j);
                    OrdinaryMorphism ordinaryMorphism = extLHS = this.leftNAC2extLeft != null && this.leftNAC2extLeft.get(nac) != null ? (OrdinaryMorphism)this.leftNAC2extLeft.get((Object)nac).second : null;
                    if (extLHS != null && extLHS.getTarget() == ((OrdinaryMorphism)((Pair)pi.second).second).getSource()) {
                        OrdinaryMorphism isoRHSnew2 = BaseFactory.theFactory().createMorphism(this.isoRight1.getSource(), ((OrdinaryMorphism)((Pair)pi.second).first).getTarget());
                        Enumeration<GraphObject> objs2 = this.isoRight1.getDomain();
                        while (objs2.hasMoreElements()) {
                            GraphObject obj2 = objs2.nextElement();
                            GraphObject img3 = this.isoRight1.getImage(obj2);
                            GraphObject img22 = ((OrdinaryMorphism)((Pair)pi.second).first).getImage(img3);
                            if (img22 == null) continue;
                            try {
                                isoRHSnew2.addMapping(obj2, img22);
                            }
                            catch (BadMappingException badMappingException) {
                                // empty catch block
                            }
                        }
                        ((Pair)pi.second).first = isoRHSnew2;
                        OrdinaryMorphism isoNACnew = BaseFactory.theFactory().createMorphism(extLHS.getSource(), ((OrdinaryMorphism)((Pair)pi.second).second).getTarget());
                        objs2 = extLHS.getDomain();
                        while (objs2.hasMoreElements()) {
                            GraphObject obj3 = objs2.nextElement();
                            GraphObject img4 = extLHS.getImage(obj3);
                            GraphObject img23 = ((OrdinaryMorphism)((Pair)pi.second).second).getImage(img4);
                            if (img23 == null) continue;
                            try {
                                isoNACnew.addMapping(obj3, img23);
                            }
                            catch (BadMappingException badMappingException) {
                                // empty catch block
                            }
                        }
                        ((Pair)pi.second).second = isoNACnew;
                    }
                    ++j;
                }
            } else if (m2.getTarget().getName().indexOf("change-") >= 0) {
                m2.getTarget().setName(String.valueOf(nb) + "deliver-change-dependency");
                if (pi.second != null && ((OrdinaryMorphism)((Pair)pi.second).first).getSource() == inv_r2.getLeft()) {
                    isoRHSnew = BaseFactory.theFactory().createMorphism(this.isoRight1.getSource(), ((OrdinaryMorphism)((Pair)pi.second).first).getTarget());
                    objs = this.isoRight1.getDomain();
                    while (objs.hasMoreElements()) {
                        obj = objs.nextElement();
                        img = this.isoRight1.getImage(obj);
                        img2 = ((OrdinaryMorphism)((Pair)pi.second).first).getImage(img);
                        if (img2 == null) continue;
                        try {
                            isoRHSnew.addMapping(obj, img2);
                        }
                        catch (BadMappingException badMappingException) {
                            // empty catch block
                        }
                    }
                    ((Pair)pi.second).first = isoRHSnew;
                }
            }
            ++i;
        }
    }

    @Override
    public Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> isCritical(int kind, Rule r1, Rule r2) throws InvalidAlgorithmException {
        Rule inverseR1;
        this.r1hasEnabledNACs = r1.hasEnabledNACs();
        this.r1hasEnabledPACs = r1.hasEnabledPACs();
        this.r2hasEnabledNACs = r2.hasEnabledNACs();
        this.r2hasEnabledPACs = r2.hasEnabledPACs();
        if (this.ignoreIdenticalRules && r1 == r2) {
            if (kind == 0) {
                return null;
            }
            if (kind == 3) {
                return null;
            }
            throw new InvalidAlgorithmException("No such algorithm", kind);
        }
        this.ownStrategy = false;
        if (this.strategy == null) {
            this.strategy = (MorphCompletionStrategy)CompletionStrategySelector.getDefault().clone();
            this.ownStrategy = true;
        }
        if ((inverseR1 = this.makeInverseRule(r1)) == null) {
            System.out.println("DependencyPair:  CANNOT make inverse rule!  Rule  " + r1.getName() + " ( attr problem? PAC? non-injective rule?)");
            this.computable = false;
            return null;
        }
        this.dependencyCond1 = false;
        this.dependencyCond2 = false;
        this.checkSwitchDependency = false;
        int count = 0;
        if (kind == 0) {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> result = this.isExclude(inverseR1, r2);
            if (result != null) {
                this.dependencyCond1 = true;
                if (this.makeConcurrentRules) {
                    this.concurrentRules = this.makeConcurrentRules(r1, inverseR1, r2, result);
                }
                this.resetAbstractRHS(result);
                count = result.size();
            }
            if (this.switchDependency) {
                this.checkSwitchDependency = true;
                this.makeConcurrentRules = false;
                this.clear();
                Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> result2 = this.isExclude(r2, inverseR1);
                if (result2 != null) {
                    this.dependencyCond2 = true;
                    this.resetAbstractRHS2(result2);
                    this.adjustOverlappings(result2, r2, inverseR1, r1, count);
                    if (result != null) {
                        result.addAll(result2);
                    } else {
                        result = result2;
                    }
                }
                this.checkSwitchDependency = false;
            }
            return result;
        }
        if (kind == 3) {
            return this.isExclude(inverseR1, r2);
        }
        throw new InvalidAlgorithmException("No such Algorithm", kind);
    }

    @Override
    protected Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> isExclude(Rule r1, Rule r2) {
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> deleteUseOverlappings;
        if (!this.makeConcurrentRules) {
            return super.isExclude(r1, r2);
        }
        this.levelOfTypeGraphCheck = this.grammar.getTypeSet().getLevelOfTypeGraphCheck();
        if (this.levelOfTypeGraphCheck > 20) {
            this.grammar.getTypeSet().setLevelOfTypeGraph(20);
        }
        if (this.withNACs && !this.checkGlobalNACsOfRule2(r1, r2)) {
            System.out.println("*** ExcludePair.isExclude::  [ " + r1.getName() + ", " + r2.getName() + " ]  non-critical.");
            return null;
        }
        System.gc();
        this.freeM = Runtime.getRuntime().freeMemory();
        this.prepareCriticalPairContextData(r1, r2);
        boolean canLHS1OverlapLHS2 = this.canMatchConstantAttributeLHS1intoLHS2(r1, r2);
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> resultOverlappings = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
        if (!this.contextC1_L1.isEmpty() && canLHS1OverlapLHS2 && (deleteUseOverlappings = this.getDeleteUseConflicts_CR(r1, r2)) != null && !deleteUseOverlappings.isEmpty()) {
            resultOverlappings.addAll(deleteUseOverlappings);
            deleteUseOverlappings.clear();
        }
        if (resultOverlappings.isEmpty()) {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> changeAttrOverlappings;
            this.preservedChanged.clear();
            this.contextC1_L1.clear();
            this.boundB1_L1.clear();
            Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL1 = new Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>>();
            this.ruleChangesAttributes(this.preservedChanged, r1, r2, this.contextC1_L1, this.boundB1_L1, this.preservedK1_L1, changedAttrsL1, this.typesTG_L2);
            Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL2 = new Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>>();
            if (!this.preservedChanged.isEmpty() && this.ruleRestrictsAttributes(this.strongAttrCheck, r2, changedAttrsL2, changedAttrsL1) && (changeAttrOverlappings = this.getChangeAttributeConflicts(r1, r2, changedAttrsL1, changedAttrsL2)) != null && !changeAttrOverlappings.isEmpty()) {
                changeAttrOverlappings = this.getMaxCriticalPair(changeAttrOverlappings);
                resultOverlappings.addAll(changeAttrOverlappings);
                changeAttrOverlappings.clear();
            }
        }
        int i = 0;
        while (i < resultOverlappings.size()) {
            int ii;
            Pair morphisms = (Pair)((Pair)resultOverlappings.elementAt((int)i)).first;
            int j = i + 1;
            Graph overlap = ((OrdinaryMorphism)morphisms.first).getImage();
            this.unsetAllTransientAttrValuesOfOverlapGrah(overlap);
            String name = overlap.getName();
            if (name.indexOf(40) == 0 && (ii = name.indexOf(41)) > 0) {
                name = overlap.getName().substring(ii + 1);
            }
            overlap.setName("( " + j + " ) " + name);
            String r1Prefix = "r1_";
            String r2Prefix = "r2_";
            ExcludePairHelper.renameContextVariableOfOverlappingPair(r1, r2, morphisms, "r1_", "r2_");
            ++i;
        }
        this.unsetAllTransientAttrValuesOfRule(r1);
        this.unsetAllTransientAttrValuesOfRule(r2);
        this.grammar.getTypeSet().setLevelOfTypeGraph(this.levelOfTypeGraphCheck);
        resultOverlappings.trimToSize();
        this.usedM = this.freeM - Runtime.getRuntime().freeMemory();
        if (resultOverlappings.isEmpty()) {
            System.out.println("*** ExcludePair.isExclude::  [ " + r1.getName() + ", " + r2.getName() + " ]  non-critical.");
            return null;
        }
        System.out.println("*** ExcludePair.isExclude::  [ " + r1.getName() + ", " + r2.getName() + " ]  " + resultOverlappings.size() + " critical overlapping graph(s).");
        return resultOverlappings;
    }

    private boolean extendAbstractInverseRule(Rule r, Rule inverseR, OrdinaryMorphism isoRHS) {
        if (!this.convertPACsLeft2Right(r, inverseR, isoRHS)) {
            return false;
        }
        this.convertNACsLeft2Right(r, inverseR, isoRHS);
        this.addAttrConditionFromTo(r, inverseR);
        return true;
    }

    private void resetAbstractRHS(Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps) {
        int i = 0;
        while (i < overlaps.size()) {
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pi = overlaps.get(i);
            Pair p = (Pair)pi.first;
            OrdinaryMorphism m1 = (OrdinaryMorphism)p.first;
            OrdinaryMorphism comp1 = null;
            if (m1.getSource() == this.isoRight1.getTarget()) {
                comp1 = this.isoRight1.compose(m1);
            } else if (m1.getSource() == this.isoLeft1.getTarget()) {
                comp1 = this.isoLeft1.compose(m1);
            }
            if (comp1 != null && comp1.getSize() == m1.getSize()) {
                comp1.setName(m1.getName());
                this.unsetAllTransientAttrValuesOfOverlapGrah(comp1.getTarget());
                p.first = comp1;
            }
            ++i;
        }
    }

    private void resetAbstractRHS2(Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps) {
        int i = 0;
        while (i < overlaps.size()) {
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pi = overlaps.get(i);
            Pair p = (Pair)pi.first;
            OrdinaryMorphism m2 = (OrdinaryMorphism)p.second;
            OrdinaryMorphism comp2 = null;
            if (m2.getSource() == this.isoRight1.getTarget()) {
                comp2 = this.isoRight1.compose(m2);
            } else if (m2.getSource() == this.isoLeft1.getTarget()) {
                comp2 = this.isoLeft1.compose(m2);
            }
            if (comp2 != null && comp2.getSize() == m2.getSize()) {
                comp2.setName(m2.getName());
                this.unsetAllTransientAttrValuesOfOverlapGrah(comp2.getTarget());
                p.second = comp2;
            }
            ++i;
        }
    }

    private ConcurrentRule makeConcurrentRule(Rule originalRule1, Rule inverseRule1, Rule rule2, Pair<OrdinaryMorphism, OrdinaryMorphism> criticalPair) {
        ConcurrentRule cr = new ConcurrentRule(originalRule1, inverseRule1, rule2, this.isoLeft1, this.isoRight1, (OrdinaryMorphism)criticalPair.first, (OrdinaryMorphism)criticalPair.second);
        return cr;
    }

    private List<ConcurrentRule> makeConcurrentRules(Rule originalRule1, Rule inverseRule1, Rule rule2, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps) {
        Vector<ConcurrentRule> list = new Vector<ConcurrentRule>();
        if (this.completeConcurrency || overlaps.size() >= 1) {
            int i = overlaps.size() - 1;
            while (i >= 0) {
                Pair criticalPair;
                ConcurrentRule conrule;
                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair = overlaps.get(i);
                if (pair.second == null && (conrule = this.makeConcurrentRule(originalRule1, inverseRule1, rule2, criticalPair = (Pair)pair.first)).getRule() != null) {
                    list.add(conrule);
                }
                --i;
            }
        } else {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> pairs = this.getMaxCriticalPair(overlaps);
            int i = 0;
            while (i < pairs.size()) {
                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair = pairs.get(i);
                Pair criticalPair = (Pair)pair.first;
                ConcurrentRule conrule = this.makeConcurrentRule(originalRule1, inverseRule1, rule2, criticalPair);
                if (conrule.getRule() != null) {
                    list.add(conrule);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < list.size()) {
            ((ConcurrentRule)list.get(i)).getRule().removeUnusedVariableOfAttrContext();
            ++i;
        }
        return list;
    }

    private Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getMaxCriticalPair(Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps) {
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> result = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
        int max = 0;
        int i = 0;
        while (i < overlaps.size()) {
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair = overlaps.get(i);
            if (pair.second == null) {
                Pair criticalPair = (Pair)pair.first;
                OrdinaryMorphism m1 = (OrdinaryMorphism)criticalPair.first;
                OrdinaryMorphism m2 = (OrdinaryMorphism)criticalPair.second;
                Graph g = m1.getTarget();
                int nn = 0;
                for (GraphObject graphObject : g.getNodesSet()) {
                    if (!m1.getInverseImage(graphObject).hasMoreElements() || !m2.getInverseImage(graphObject).hasMoreElements()) continue;
                    ++nn;
                }
                for (GraphObject graphObject : g.getArcsSet()) {
                    if (!m1.getInverseImage(graphObject).hasMoreElements() || !m2.getInverseImage(graphObject).hasMoreElements()) continue;
                    ++nn;
                }
                if (nn >= max) {
                    max = nn;
                    result.add(pair);
                }
            }
            ++i;
        }
        return result;
    }

    protected Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getDeleteUseConflicts1(Rule r1, Rule r2) {
        System.out.println("    DependencyPair.getDeleteUseConflicts::  [ " + r1.getName() + ", " + r2.getName() + " ] ...");
        if (!this.needMoreCheckDueToDelConstAttr(r1, r2)) {
            return null;
        }
        this.cpdKind = 0;
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
        Graph g = r1.getLeft();
        int maxSize = r2.getLeft().getSize();
        Enumeration<OrdinaryMorphism> pacs2 = r2.getEnabledPACs();
        boolean lhs_done = false;
        boolean perform = true;
        while (perform && !this.stop) {
            boolean pacCritical;
            String pacName = "";
            OrdinaryMorphism L2isoL2ExtendedByPAC = null;
            Pair<OrdinaryMorphism, OrdinaryMorphism> lhs_pac_pair = null;
            OrdinaryMorphism pac = null;
            if (this.withPACs && pacs2.hasMoreElements() && !(pac = pacs2.nextElement()).isEnabled()) continue;
            if (pac != null && (pacCritical = ExcludePairHelper.isCriticalPAC(pac, this.delete)) && (L2isoL2ExtendedByPAC = r2.getLeft().isomorphicCopy()) != null) {
                lhs_pac_pair = this.extendLeftGraphByPAC(L2isoL2ExtendedByPAC, pac, false);
                pacName = pac.getName();
                maxSize = L2isoL2ExtendedByPAC.getTarget().getSize();
                lhs_done = true;
            }
            Vector<Vector<GraphObject>> inclusions = null;
            Vector<Vector<GraphObject>> contextCombis = null;
            this.inclAsGraph = false;
            int size = this.contextC1_L1.size();
            if (size > maxSize) {
                size = maxSize;
            }
            contextCombis = ExcludePairHelper.getInclusions(g, size, this.contextC1_L1, true);
            this.checkInclusions(contextCombis, this.delete);
            if (contextCombis.size() == 0) {
                if (!pacs2.hasMoreElements()) break;
                continue;
            }
            if (this.namedObjectOnly) {
                this.checkInclusionsDuetoNamedObject(contextCombis);
                if (contextCombis.size() == 0) {
                    if (!pacs2.hasMoreElements()) break;
                    continue;
                }
            }
            if ((size = this.preservedK1_L1.size()) > maxSize) {
                size = maxSize;
            }
            Vector<Vector<GraphObject>> preservedCombis = ExcludePairHelper.getPlainCombinedInclusions(new Vector<GraphObject>(this.preservedK1_L1), size, g);
            int ncp = 0;
            int nm = contextCombis.size() - 1;
            int run = 0;
            while (nm >= 0 && !this.stop) {
                if (preservedCombis.size() > 0) {
                    if (!contextCombis.isEmpty()) {
                        inclusions = ExcludePairHelper.combineFirstWithSecondAboveThird(maxSize, contextCombis.get(nm), preservedCombis, this.boundB1_L1);
                        contextCombis.remove(nm);
                        nm = contextCombis.size() - 1;
                    }
                } else {
                    inclusions = contextCombis;
                    nm = -1;
                }
                this.inclCount = inclusions.size();
                System.out.println("(run: " + ++run + ") to check inclusions: " + this.inclCount + "   already checked: " + ncp);
                int n100 = 0;
                int nn2 = 0;
                int i = inclusions.size() - 1;
                while (i >= 0 && !this.stop) {
                    int x;
                    Vector<GraphObject> inclSet = inclusions.get(i);
                    --i;
                    ++n100;
                    OrdinaryMorphism inclMorphism = null;
                    Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> localOverlaps = null;
                    if (L2isoL2ExtendedByPAC == null) {
                        if (r2.getSource().getSize() >= inclSet.size()) {
                            inclMorphism = this.makeInclusionMorphism(inclSet, g);
                        }
                        if (inclMorphism != null && r2.getSource().getNodesCount() >= inclMorphism.getSource().getNodesCount() && r2.getSource().getArcsCount() >= inclMorphism.getSource().getArcsCount()) {
                            localOverlaps = this.getOverlappingsVectorDeleteUse(r1, r2, inclMorphism);
                            this.setGraphNameOfDeleteUseConflict(r1, r2, localOverlaps);
                            overlaps.addAll(localOverlaps);
                            localOverlaps.clear();
                            localOverlaps = null;
                            inclMorphism.dispose(true, false);
                            inclMorphism = null;
                        }
                        lhs_done = true;
                    } else {
                        if (((OrdinaryMorphism)lhs_pac_pair.first).getTarget().getSize() >= inclSet.size()) {
                            inclMorphism = this.makeInclusionMorphism(inclSet, g);
                        }
                        if (inclMorphism != null && ((OrdinaryMorphism)lhs_pac_pair.first).getTarget().getNodesCount() >= inclMorphism.getSource().getNodesCount() && ((OrdinaryMorphism)lhs_pac_pair.first).getTarget().getArcsCount() >= inclMorphism.getSource().getArcsCount()) {
                            localOverlaps = this.getOverlappingsVectorDeleteUse(r1, r2, lhs_pac_pair, inclMorphism);
                            this.setGraphNameOfDeleteUseConflict(r1, r2, localOverlaps, pacName);
                            x = 0;
                            while (x < localOverlaps.size()) {
                                this.unsetAllTransientAttrValuesOfOverlapGrah(((OrdinaryMorphism)((Pair)localOverlaps.get((int)x).first).first).getTarget());
                                ++x;
                            }
                            inclMorphism.dispose(true, false);
                            inclMorphism = null;
                        }
                        lhs_done = true;
                    }
                    ++this.inclProgress;
                    if (localOverlaps != null) {
                        x = 0;
                        while (x < localOverlaps.size()) {
                            if (this.maxBoundOfCriticKind == 0 || overlaps.size() < this.maxBoundOfCriticKind) {
                                overlaps.add(localOverlaps.get(x));
                            }
                            ++x;
                        }
                        localOverlaps.clear();
                        localOverlaps = null;
                    }
                    if (!this.complete && !overlaps.isEmpty() || this.maxBoundOfCriticKind > 0 && overlaps.size() >= this.maxBoundOfCriticKind) break;
                    if (n100 != 100) continue;
                    System.out.println("checked  inclusions: " + n100 * ++nn2 + "     to check: " + (i + 1));
                    n100 = 0;
                    inclusions.trimToSize();
                }
                ncp += this.inclCount;
                if (!this.complete && !overlaps.isEmpty() || this.maxBoundOfCriticKind > 0 && overlaps.size() >= this.maxBoundOfCriticKind) break;
            }
            inclusions = null;
            contextCombis = null;
            preservedCombis = null;
            boolean bl = perform = this.withPACs && pacs2.hasMoreElements() || !lhs_done;
        }
        if (this.withPACs) {
            pacs2 = r2.getEnabledPACs();
            while (pacs2.hasMoreElements()) {
                this.replaceVarAttrValueByConst(pacs2.nextElement());
            }
        }
        if ((overlaps = this.getMaxCriticalPair(overlaps)).size() > 0) {
            this.reduceCriticalPairs(overlaps);
        }
        overlaps.trimToSize();
        this.cpdKind = -1;
        System.out.println("    DependencyPair.getDeleteUseConflicts::  [ " + r1.getName() + ", " + r2.getName() + " ]  " + overlaps.size() + " critical overlapping(s)");
        return overlaps;
    }

    protected Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getDeleteUseConflicts_CR(Rule r1, Rule r2) {
        System.out.println("    ExcludePair.getDeleteUseConflicts::  [ " + r1.getName() + ", " + r2.getName() + " ] ...");
        if (!this.needMoreCheckDueToDelConstAttr(r1, r2)) {
            return null;
        }
        this.cpdKind = 0;
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
        Graph g = r1.getLeft();
        int maxSize = r2.getLeft().getSize();
        Enumeration<OrdinaryMorphism> pacs2 = r2.getEnabledPACs();
        boolean lhs_done = false;
        boolean perform = true;
        while (perform && !this.stop) {
            boolean pacCritical;
            String pacName = "";
            OrdinaryMorphism L2isoL2ExtendedByPAC = null;
            Pair<OrdinaryMorphism, OrdinaryMorphism> lhs_pac_pair = null;
            OrdinaryMorphism pac = null;
            if (this.withPACs && pacs2.hasMoreElements() && !(pac = pacs2.nextElement()).isEnabled()) continue;
            Vector<Vector<GraphObject>> inclusions = null;
            this.inclAsGraph = false;
            int size = this.contextC1_L1.size();
            if (size > maxSize) {
                size = maxSize;
            }
            Vector<Vector<GraphObject>> contextCombis = ExcludePairHelper.getInclusions(g, size, this.contextC1_L1, true);
            this.checkInclusions(contextCombis, this.delete);
            if (contextCombis.size() == 0) break;
            if (pac != null && (pacCritical = ExcludePairHelper.isCriticalPAC(pac, this.delete)) && (L2isoL2ExtendedByPAC = r2.getLeft().isomorphicCopy()) != null) {
                lhs_pac_pair = this.extendLeftGraphByPAC(L2isoL2ExtendedByPAC, pac, false);
                pacName = pac.getName();
                maxSize = L2isoL2ExtendedByPAC.getTarget().getSize();
                lhs_done = true;
            }
            if (this.namedObjectOnly) {
                this.checkInclusionsDuetoNamedObject(contextCombis);
            }
            if ((size = this.preservedK1_L1.size()) > maxSize) {
                size = maxSize;
            }
            Vector<Vector<GraphObject>> preservedCombis = ExcludePairHelper.getPlainCombinedInclusions(new Vector<GraphObject>(this.preservedK1_L1), size, g);
            inclusions = ExcludePairHelper.combineInclusions(maxSize, contextCombis, preservedCombis, this.boundB1_L1);
            System.out.println("to check inclusions: " + inclusions.size());
            int i = inclusions.size() - 1;
            while (i >= 0 && !this.stop) {
                Vector<GraphObject> inclSet = inclusions.get(i);
                --i;
                OrdinaryMorphism inclMorphism = null;
                Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> localOverlaps = null;
                if (L2isoL2ExtendedByPAC == null) {
                    if (r2.getSource().getSize() >= inclSet.size()) {
                        inclMorphism = this.makeInclusionMorphism(inclSet, g);
                    }
                    if (inclMorphism != null && r2.getSource().getNodesCount() >= inclMorphism.getSource().getNodesCount() && r2.getSource().getArcsCount() >= inclMorphism.getSource().getArcsCount()) {
                        localOverlaps = this.getOverlappingsVectorDeleteUse(r1, r2, inclMorphism);
                        this.setGraphNameOfDeleteUseConflict(r1, r2, localOverlaps);
                        overlaps.addAll(localOverlaps);
                        localOverlaps.clear();
                        localOverlaps = null;
                        inclMorphism.dispose(true, false);
                        inclMorphism = null;
                    }
                    lhs_done = true;
                } else {
                    if (((OrdinaryMorphism)lhs_pac_pair.first).getTarget().getSize() >= inclSet.size()) {
                        inclMorphism = this.makeInclusionMorphism(inclSet, g);
                    }
                    if (inclMorphism != null && ((OrdinaryMorphism)lhs_pac_pair.first).getTarget().getNodesCount() >= inclMorphism.getSource().getNodesCount() && ((OrdinaryMorphism)lhs_pac_pair.first).getTarget().getArcsCount() >= inclMorphism.getSource().getArcsCount()) {
                        localOverlaps = this.getOverlappingsVectorDeleteUse(r1, r2, lhs_pac_pair, inclMorphism);
                        this.setGraphNameOfDeleteUseConflict(r1, r2, localOverlaps, pacName);
                        int x = 0;
                        while (x < localOverlaps.size()) {
                            this.unsetAllTransientAttrValuesOfOverlapGrah(((OrdinaryMorphism)((Pair)localOverlaps.get((int)x).first).first).getTarget());
                            ++x;
                        }
                        overlaps.addAll(localOverlaps);
                        localOverlaps.clear();
                        localOverlaps = null;
                        inclMorphism.dispose(true, false);
                        inclMorphism = null;
                    }
                    lhs_done = true;
                }
                if (!this.complete && !overlaps.isEmpty()) break;
            }
            inclusions = null;
            contextCombis = null;
            preservedCombis = null;
            boolean bl = perform = this.withPACs && pacs2.hasMoreElements() || !lhs_done;
        }
        if (this.withPACs) {
            pacs2 = r2.getEnabledPACs();
            while (pacs2.hasMoreElements()) {
                this.replaceVarAttrValueByConst(pacs2.nextElement());
            }
        }
        if ((overlaps = this.getMaxCriticalPair(overlaps)).size() > 0) {
            this.reduceCriticalPairs(overlaps);
        }
        overlaps.trimToSize();
        this.cpdKind = -1;
        System.out.println("    DependencyPair.getDeleteUseConflicts::  [ " + r1.getName() + ", " + r2.getName() + " ]  " + overlaps.size() + " critical overlapping(s)");
        return overlaps;
    }

    @Override
    void computeLeftC_B_K(Rule r, Vector<GraphObject> context, Vector<GraphObject> boundary, Vector<GraphObject> preserved, Vector<GraphObject> toDelete, Vector<Pair<Type, Pair<Type, Type>>> neededTypes) {
        for (GraphObject graphObject : r.getLeft().getNodesSet()) {
            if (r.getImage(graphObject) != null) {
                if (!this.isInTypes(neededTypes, graphObject)) continue;
                preserved.add(graphObject);
                continue;
            }
            if (!this.isChildInTypes(neededTypes, graphObject)) continue;
            if (r.getImage(graphObject) == null) {
                context.add(graphObject);
                toDelete.add(graphObject);
                continue;
            }
            preserved.add(graphObject);
        }
        for (GraphObject graphObject : r.getLeft().getArcsSet()) {
            if (!this.isChildInTypes(neededTypes, graphObject)) continue;
            if (r.getImage(graphObject) == null) {
                if (!context.contains(((Arc)graphObject).getSource())) {
                    context.add(((Arc)graphObject).getSource());
                }
                if (!context.contains(((Arc)graphObject).getTarget())) {
                    context.add(((Arc)graphObject).getTarget());
                }
                context.add(graphObject);
                toDelete.add(graphObject);
                preserved.remove(((Arc)graphObject).getSource());
                preserved.remove(((Arc)graphObject).getTarget());
                continue;
            }
            preserved.add(graphObject);
        }
    }

    @Override
    Vector<OrdinaryMorphism> getPotentialCriticalNACsOfR2(Rule r, Vector<GraphObject> toproduce) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int l = 0;
        while (l < nacs.size()) {
            OrdinaryMorphism nac = nacs.get(l);
            if (nac.isEnabled()) {
                Hashtable<Type, Vector<GraphObject>> type2gosNAC2 = new Hashtable<Type, Vector<GraphObject>>();
                boolean nacMaybeCritical = false;
                boolean nacAttrConst = false;
                boolean attrConst = false;
                boolean nacAttrSet = false;
                int j = 0;
                while (j < toproduce.size() && !nacMaybeCritical) {
                    GraphObject go;
                    int i;
                    GraphObject o = toproduce.get(j);
                    Vector<GraphObject> v = (Vector<GraphObject>)type2gosNAC2.get(o.getType());
                    if (v == null) {
                        v = nac.getTarget().getElemsAndParentsOfType(o.getType());
                    } else {
                        v.addAll(nac.getTarget().getElemsAndParentsOfType(o.getType()));
                    }
                    v.addAll(nac.getTarget().getChildrenOfType(o.getType()));
                    if (!v.isEmpty()) {
                        type2gosNAC2.put(o.getType(), v);
                        i = 0;
                        while (i < v.size()) {
                            go = v.get(i);
                            if (nac.getInverseImage(go).hasMoreElements()) {
                                v.remove(go);
                                --i;
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < v.size() && !nacMaybeCritical) {
                        go = v.get(i);
                        if (!nac.getInverseImage(go).hasMoreElements()) {
                            if (go.getAttribute() != null) {
                                nacAttrSet = false;
                                int k = 0;
                                while (k < go.getAttribute().getNumberOfEntries()) {
                                    ValueMember vm_nac = (ValueMember)go.getAttribute().getMemberAt(k);
                                    if (vm_nac.isSet()) {
                                        nacAttrSet = true;
                                        nacAttrConst = vm_nac.getExpr().isConstant();
                                        attrConst = true;
                                        ValueMember vm = (ValueMember)o.getAttribute().getMemberAt(vm_nac.getName());
                                        if (vm.isSet() && vm_nac.getExpr().isConstant() && vm.getExpr().isConstant() && !vm.getExprAsText().equals(vm_nac.getExprAsText())) {
                                            attrConst = false;
                                            break;
                                        }
                                    }
                                    ++k;
                                }
                                nacMaybeCritical = nacAttrConst && attrConst || nacAttrSet;
                            } else {
                                nacMaybeCritical = true;
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                if (nacMaybeCritical) {
                    result.add(nac);
                }
            }
            ++l;
        }
        result.trimToSize();
        return result;
    }

    @Override
    boolean isChangeAttrMatchValid(Rule r1, Rule r2, Match m, OrdinaryMorphism nac, OrdinaryMorphism isoNAC2ext, boolean firstRule, OrdinaryMorphism overlap1, OrdinaryMorphism overlap2) {
        Rule r = firstRule ? r1 : r2;
        boolean result = true;
        m.getTarget().setCompleteGraph(false);
        if (!m.isTotal()) {
            result = false;
        } else if (!m.isValid(true)) {
            result = false;
        } else if (!this.tryValidateAttrCond(firstRule, m, overlap1, overlap2)) {
            result = false;
        } else if (this.withNACs) {
            List<OrdinaryMorphism> nacs = r.getNACsList();
            int l = 0;
            while (l < nacs.size()) {
                OrdinaryMorphism nacStar;
                OrdinaryMorphism n = nacs.get(l);
                if (n.isEnabled() && (nacStar = (OrdinaryMorphism)m.checkNAC(n, true)) != null) {
                    int nacCondEval = this.tryValidateNACAttrCond(n, nacStar, m);
                    if (nacCondEval == 1) {
                        if (firstRule) {
                            result = false;
                            nacStar.dispose();
                            nacStar = null;
                            break;
                        }
                        if (!this.hasNewConstantToCriticalInContext(n, nacStar)) {
                            result = false;
                            nacStar.dispose();
                            nacStar = null;
                            break;
                        }
                        result = true;
                        nacStar.dispose();
                        nacStar = null;
                    } else if (nacCondEval == -1) {
                        result = true;
                        nacStar.dispose();
                        nacStar = null;
                    } else if (nacCondEval == 0 && (nac == null || n != nac)) {
                        if (!(this.hasVariableInContext(n, r.getAttrContext()) || this.hasConstantToVariableInContext(nacStar) || this.hasNewConstantToVariableInContext(n, nacStar))) {
                            result = false;
                            nacStar.dispose();
                            nacStar = null;
                            break;
                        }
                        nacStar.dispose();
                        nacStar = null;
                    }
                }
                ++l;
            }
        }
        return result;
    }

    @Override
    boolean checkNac2afterStep1(OrdinaryMorphism step1, Rule r2, OrdinaryMorphism nac, OrdinaryMorphism isoL2ext, OrdinaryMorphism overlap2) {
        OrdinaryMorphism tom2 = overlap2.compose(step1);
        OrdinaryMorphism ttom2 = isoL2ext.compose(tom2);
        Match tm2 = BaseFactory.theFactory().makeMatch(r2, ttom2);
        if (tm2 != null) {
            OrdinaryMorphism nacStar = (OrdinaryMorphism)tm2.checkNAC(nac, true);
            if (nacStar != null) {
                tm2.dispose();
                tm2 = null;
                ttom2.dispose();
                ttom2 = null;
                tom2.dispose();
                tom2 = null;
                return true;
            }
        } else {
            ttom2.dispose();
            ttom2 = null;
            tom2.dispose();
            tom2 = null;
        }
        return false;
    }
}

