/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;

public class CleanUpCommand
extends AbstractCommand {
    private List<?> elements;

    public void setElements(List<?> elements) {
        this.elements = elements;
    }

    public boolean canExecute() {
        return !this.elements.isEmpty();
    }

    public void execute() {
        for (Object element : this.elements) {
            if (element instanceof Module) {
                HenshinModelCleaner.cleanModule((Module)((Module)element));
            }
            if (element instanceof Unit) {
                HenshinModelCleaner.cleanUnit((Unit)((Unit)element));
            }
            if (element instanceof Rule) {
                HenshinModelCleaner.cleanRule((Rule)((Rule)element));
            }
            if (element instanceof Graph) {
                HenshinModelCleaner.cleanGraph((Graph)((Graph)element));
            }
            if (element instanceof Formula) {
                HenshinModelCleaner.cleanFormula((Formula)((Formula)element));
            }
            if (!(element instanceof NestedCondition)) continue;
            HenshinModelCleaner.cleanNestedCondition((NestedCondition)((NestedCondition)element));
        }
    }

    public boolean canUndo() {
        return false;
    }

    public void redo() {
    }
}

