/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.henshin.giraph.GiraphRuleData;
import org.eclipse.emf.henshin.giraph.GiraphUtil;
import org.eclipse.emf.henshin.interpreter.info.RuleChangeInfo;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.staticanalysis.NodeEquivalence;

public class GiraphRuleTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.io.IOException;" + this.NL + "import java.util.ArrayDeque;" + this.NL + "import java.util.ArrayList;";
    protected final String TEXT_3 = String.valueOf(this.NL) + "import java.util.Collections;";
    protected final String TEXT_4 = String.valueOf(this.NL) + "import java.util.Deque;" + this.NL + "import java.util.HashSet;" + this.NL + "import java.util.List;" + this.NL + "import java.util.Set;" + this.NL + this.NL + "import org.apache.giraph.aggregators.LongSumAggregator;" + this.NL + "import org.apache.giraph.edge.Edge;";
    protected final String TEXT_5 = String.valueOf(this.NL) + "import org.apache.giraph.edge.EdgeFactory;";
    protected final String TEXT_6 = String.valueOf(this.NL) + "import org.apache.giraph.examples.Algorithm;" + this.NL + "import org.apache.giraph.graph.BasicComputation;" + this.NL + "import org.apache.giraph.graph.Vertex;" + this.NL + "import org.apache.giraph.master.DefaultMasterCompute;" + this.NL + "import org.apache.hadoop.io.ByteWritable;" + this.NL + "import org.apache.hadoop.io.LongWritable;";
    protected final String TEXT_7 = String.valueOf(this.NL) + "import org.apache.log4j.Logger;";
    protected final String TEXT_8 = String.valueOf(this.NL) + "import static ";
    protected final String TEXT_9 = ".HenshinUtil.ApplicationStack;" + this.NL + "import static ";
    protected final String TEXT_10 = ".HenshinUtil.ApplicationStackAggregator;" + this.NL + "import static ";
    protected final String TEXT_11 = ".HenshinUtil.Match;" + this.NL + "import static ";
    protected final String TEXT_12 = ".HenshinUtil.VertexId;" + this.NL + this.NL + "/**" + this.NL + " * Generated implementation of the Henshin unit \"";
    protected final String TEXT_13 = "\"." + this.NL + " */" + this.NL + "@Algorithm(name = \"";
    protected final String TEXT_14 = "\")" + this.NL + "public class ";
    protected final String TEXT_15 = " extends BasicComputation<VertexId, ByteWritable, ByteWritable, Match> {" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the match count aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_MATCHES = \"matches\";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the rule application count aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_RULE_APPLICATIONS = \"ruleApps\";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the node generation aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_NODE_GENERATION = \"nodeGen\";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the application stack aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_APPLICATION_STACK = \"appStack\";";
    protected final String TEXT_16 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Type constant for \"";
    protected final String TEXT_17 = "\"." + this.NL + "\t */" + this.NL + "\tpublic static final byte ";
    protected final String TEXT_18 = " = ";
    protected final String TEXT_19 = ";";
    protected final String TEXT_20 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * ";
    protected final String TEXT_21 = " constant for \"";
    protected final String TEXT_22 = "\"." + this.NL + "\t */" + this.NL + "\tpublic static final int ";
    protected final String TEXT_23 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Logging support." + this.NL + "\t */" + this.NL + "\tprotected static final Logger LOG = Logger.getLogger(";
    protected final String TEXT_24 = ".class);";
    protected final String TEXT_25 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Default segment count." + this.NL + "\t */" + this.NL + "\tprivate static int SEGMENT_COUNT = ";
    protected final String TEXT_26 = ";" + this.NL + "\t" + this.NL + "\t/**" + this.NL + "\t * Default stair count" + this.NL + "\t */" + this.NL + "\tprivate static final int STAIR_COUNT = ";
    protected final String TEXT_27 = ";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Currently active rule." + this.NL + "\t */" + this.NL + "\tprivate int rule;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Current segment." + this.NL + "\t */" + this.NL + "\tprivate int segment;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Current microstep." + this.NL + "\t */" + this.NL + "\tprivate int microstep;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Finished flag." + this.NL + "\t */" + this.NL + "\tprivate boolean finished;" + this.NL + this.NL + "\t/*" + this.NL + "\t * (non-Javadoc)" + this.NL + "\t * @see org.apache.giraph.graph.Computation#preSuperstep()" + this.NL + "\t */" + this.NL + "\t@Override" + this.NL + "\tpublic void preSuperstep() {" + this.NL + "\t\tApplicationStack stack = getAggregatedValue(AGGREGATOR_APPLICATION_STACK);" + this.NL + "\t\tif (stack.getStackSize() == 0) {" + this.NL + "\t\t\tlong ruleApps = ((LongWritable) getAggregatedValue(AGGREGATOR_RULE_APPLICATIONS)).get();" + this.NL + "\t\t\tfinished = ruleApps == 0;" + this.NL + "\t\t\trule = -1;" + this.NL + "\t\t} else {" + this.NL + "\t\t\tfinished = false;" + this.NL + "\t\t\trule = stack.getLastUnit();" + this.NL + "\t\t\tsegment = stack.getLastSegment();" + this.NL + "\t\t\tmicrostep = stack.getLastMicrostep();" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/*" + this.NL + "\t * (non-Javadoc)" + this.NL + "\t * @see org.apache.giraph.graph.Computation#compute(org.apache.giraph.graph.Vertex, java.lang.Iterable)" + this.NL + "\t */" + this.NL + "\t@Override" + this.NL + "\tpublic void compute(Vertex<VertexId, ByteWritable, ByteWritable> vertex, Iterable<Match> matches) throws IOException {" + this.NL + "\t\tif (finished) {" + this.NL + "\t\t\tvertex.voteToHalt();" + this.NL + "\t\t\treturn;" + this.NL + "\t\t}" + this.NL + "\t\tswitch (rule) {";
    protected final String TEXT_28 = String.valueOf(this.NL) + "\t\tcase ";
    protected final String TEXT_29 = ":" + this.NL + "\t\t\tmatch";
    protected final String TEXT_30 = "(vertex, matches, segment, microstep);" + this.NL + "\t\t\tbreak;";
    protected final String TEXT_31 = String.valueOf(this.NL) + "\t\tdefault:" + this.NL + "\t\t\tbreak;" + this.NL + "\t\t}" + this.NL + "\t}";
    protected final String TEXT_32 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Match (and apply) the rule \"";
    protected final String TEXT_33 = "\"." + this.NL + "\t * This takes ";
    protected final String TEXT_34 = " microsteps." + this.NL + "\t * @param vertex The current vertex." + this.NL + "\t * @param matches The current matches." + this.NL + "\t * @param segment The current segment." + this.NL + "\t * @param microstep The current microstep." + this.NL + "\t */" + this.NL + "\tprotected void match";
    protected final String TEXT_35 = "(Vertex<VertexId, ByteWritable, ByteWritable> vertex, Iterable<Match> matches, int segment, int microstep) throws IOException {";
    protected final String TEXT_36 = String.valueOf(this.NL) + "\t\tLOG.info(\"Vertex \" + vertex.getId() + \" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\" matching rule ";
    protected final String TEXT_37 = " on segment \" + segment +" + this.NL + "\t\t\t\" in microstep \" + microstep);" + this.NL + "\t\tfor (Match match : matches) {" + this.NL + "\t\t\tLOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "\t\t\t\t\" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\t\" received (partial) match \" + match);" + this.NL + "\t\t}";
    protected final String TEXT_38 = String.valueOf(this.NL) + "\t\tSet<Match> finalMatches = new HashSet<>();" + this.NL + "\t\t";
    protected final String TEXT_39 = "filter";
    protected final String TEXT_40 = "(vertex, matches, segment, microstep, finalMatches);" + this.NL + "\t\tlong matchCount = 0;" + this.NL + "\t\tlong appCount = 0;" + this.NL + "\t\tboolean ok;";
    protected final String TEXT_41 = String.valueOf(this.NL) + "\t\tVertexId id;" + this.NL + "\t\tList<Match> matches1 = new ArrayList<>();" + this.NL + "\t\tList<Match> matches2 = new ArrayList<>();" + this.NL + "\t\tSet<Match> joinSet = new HashSet<>();" + this.NL + "\t\tint index = 0;";
    protected final String TEXT_42 = String.valueOf(this.NL) + "\t\tSet<VertexId> targets;" + this.NL + "\t\tVertexId targetId;";
    protected final String TEXT_43 = String.valueOf(this.NL) + "\t\tif (microstep == ";
    protected final String TEXT_44 = "){" + this.NL + "\t\t\tsendMessage(vertex.getId(), new Match(segment, ";
    protected final String TEXT_45 = "));" + this.NL + "\t\t}";
    protected final String TEXT_46 = String.valueOf(this.NL) + "\t\tif (microstep < STAIR_COUNT ";
    protected final String TEXT_47 = "){";
    protected final String TEXT_48 = String.valueOf(this.NL) + "\t  \tfor (Match match : matches){" + this.NL + "\t  \t\tswitch ((int)match.getMicrostep()){";
    protected final String TEXT_49 = String.valueOf(this.NL) + "\t\t\tcase ";
    protected final String TEXT_50 = ": ";
    protected final String TEXT_51 = String.valueOf(this.NL) + "\t\t\t\tif (microstep < ";
    protected final String TEXT_52 = " + STAIR_COUNT - 1){" + this.NL + "\t\t\t\t\t//wait for all stairs to finish" + this.NL + "\t\t\t\t\tsendMessage(vertex.getId(), match);" + this.NL + "\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t} else if (!joinSet.add(match)){" + this.NL + "\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\t// Joining matches at node ";
    protected final String TEXT_53 = ":" + this.NL + "\t\t\t\tid = vertex.getId();" + this.NL + "\t\t\t\tif (id.equals(match.getVertexId(";
    protected final String TEXT_54 = "))) {" + this.NL + "\t\t\t\t\tmatches1.add(match.copy());" + this.NL + "\t\t\t\t} else {" + this.NL + "\t\t\t\t\tmatches2.add(match.copy());" + this.NL + "\t\t\t\t}";
    protected final String TEXT_55 = String.valueOf(this.NL) + "\t\t\t\tLOG.info(\"Vertex \" + id + \" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\t\t\" joining \" + matches1.size() + \" x \" + matches2.size() +" + this.NL + "\t\t\t\t\t\" partial matches of rule ";
    protected final String TEXT_56 = "\");";
    protected final String TEXT_57 = String.valueOf(this.NL) + "\t\t\t\tboolean breaking = false;" + this.NL + "\t\t\t\tint j = 0;" + this.NL + "\t\t\t\tfor (Match tmpMatch : matches){" + this.NL + "\t\t\t\t\tif (j <= index){" + this.NL + "\t\t\t\t\t\tj++;" + this.NL + "\t\t\t\t\t}else {" + this.NL + "\t\t\t\t\t\tif (tmpMatch.getMicrostep() == ";
    protected final String TEXT_58 = "){" + this.NL + "\t\t\t\t\t\t\tbreaking = true;" + this.NL + "\t\t\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t\t\t}" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tif (breaking)" + this.NL + "\t\t\t\t\tbreak;" + this.NL + "\t\t\t\tfor (Match m1 : matches1) {" + this.NL + "\t\t\t\t\tfor (Match m2 : matches2) {" + this.NL + "\t\t\t\t\t\t";
    protected final String TEXT_59 = "match = m1.append(m2);";
    protected final String TEXT_60 = String.valueOf(this.NL) + "\t\t\t\t\t\tif (!match.isInjective()) {" + this.NL + "\t\t\t\t\t\t\tcontinue;" + this.NL + "\t\t\t\t\t\t}";
    protected final String TEXT_61 = String.valueOf(this.NL) + "\t\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));" + this.NL + "\t\t\t\t\t\tmatchCount++;";
    protected final String TEXT_62 = String.valueOf(this.NL) + "\t\t\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "\t\t\t\t\t\t\t\" sending (partial) match \" + match +" + this.NL + "\t\t\t\t\t\t\t\" back to vertex \" + match.getVertexId(";
    protected final String TEXT_63 = "));";
    protected final String TEXT_64 = String.valueOf(this.NL) + "\t\t\t\t\t\tsendMessage(match.getVertexId(";
    protected final String TEXT_65 = "), match);";
    protected final String TEXT_66 = String.valueOf(this.NL) + "\t\t\t\t\t\tmatch = match.remove(";
    protected final String TEXT_67 = ");";
    protected final String TEXT_68 = String.valueOf(this.NL) + "\t\t\t\t\t\tif (!finalMatches.add(match)) {" + this.NL + "\t\t\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t\t\t}" + this.NL + "\t\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));" + this.NL + "\t\t\t\t\t\tmatchCount++;" + this.NL + "\t\t\t\t\t\tif (segment == SEGMENT_COUNT - 1 && microstep == ";
    protected final String TEXT_69 = " + STAIR_COUNT - 1) {" + this.NL + "\t\t\t\t\t\t\tapply";
    protected final String TEXT_70 = "(vertex, match, appCount++);" + this.NL + "\t\t\t\t\t\t} else {" + this.NL + "\t\t\t\t\t\t\tsendMessage(vertex.getId(), match);" + this.NL + "\t\t\t\t\t\t}";
    protected final String TEXT_71 = String.valueOf(this.NL) + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}";
    protected final String TEXT_72 = String.valueOf(this.NL) + "\t\t\t\tid = match.getVertexId(";
    protected final String TEXT_73 = ");" + this.NL + "\t\t\t\tif (vertex.getId().equals(id)) {" + this.NL + "\t\t\t\t\tmatchCount++;";
    protected final String TEXT_74 = String.valueOf(this.NL) + "\t\t\t\t\tLOG.info(\"Vertex \" + id + \" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\t\t\t\" sending (partial) match \" + match + \" to myself\");";
    protected final String TEXT_75 = String.valueOf(this.NL) + "\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));" + this.NL + "\t\t\t\t\tsendMessage(id, match);" + this.NL + "\t\t\t\t}";
    protected final String TEXT_76 = String.valueOf(this.NL) + "\t\t\t\t// Matching node ";
    protected final String TEXT_77 = ":";
    protected final String TEXT_78 = String.valueOf(this.NL) + "\t\t\t\t";
    protected final String TEXT_79 = "vertex.getValue().get() == ";
    protected final String TEXT_80 = String.valueOf(this.NL) + "\t\t\t\tok = ok && vertex.getNumEdges() >= ";
    protected final String TEXT_81 = String.valueOf(this.NL) + "\t\t\t\tok = ok && (SEGMENT_COUNT == 1 || getSegment(vertex.getId()) == segment);";
    protected final String TEXT_82 = String.valueOf(this.NL) + "\t\t\t\tif (ok) {";
    protected final String TEXT_83 = String.valueOf(this.NL) + "\t\t\t\t\tif (!(match.getMatchSize() == 0)){" + this.NL + "\t\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t\t}";
    protected final String TEXT_84 = String.valueOf(this.NL) + "\t\t\t\t\t";
    protected final String TEXT_85 = "match = new Match(segment, ";
    protected final String TEXT_86 = ").append(vertex.getId());";
    protected final String TEXT_87 = this.NL;
    protected final String TEXT_88 = "\t\t\t\tmatch = match.append(vertex.getId());";
    protected final String TEXT_89 = "\t\t\t\tif (!match.isInjective()) {";
    protected final String TEXT_90 = "\t\t\t\t\tbreak;";
    protected final String TEXT_91 = "\t\t\t\t}";
    protected final String TEXT_92 = "\t\t\t\tif (vertex.getId().compareTo(match.getVertexId(";
    protected final String TEXT_93 = ")) < 0) {";
    protected final String TEXT_94 = "\t\t// Node ";
    protected final String TEXT_95 = ": check for edge to match of ";
    protected final String TEXT_96 = " of type \"";
    protected final String TEXT_97 = "\":";
    protected final String TEXT_98 = "\t\ttargetId = match.getVertexId(";
    protected final String TEXT_99 = "\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {";
    protected final String TEXT_100 = "\t\t\tif (edge.getValue().get() == ";
    protected final String TEXT_101 = " && edge.getTargetVertexId().equals(targetId)) {";
    protected final String TEXT_102 = "\t\t\t\tmatchCount++;";
    protected final String TEXT_103 = "\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));";
    protected final String TEXT_104 = "\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +";
    protected final String TEXT_105 = "\t\t\t\t\t\" sending (partial) match \" + match +";
    protected final String TEXT_106 = "\t\t\t\t\t\" back to vertex \" + match.getVertexId(";
    protected final String TEXT_107 = "\t\t\t\tsendMessage(match.getVertexId(";
    protected final String TEXT_108 = "\t\t\t\tmatch = match.remove(";
    protected final String TEXT_109 = "\t\t\t\tif (finalMatches.add(match)) {";
    protected final String TEXT_110 = "\t\t\t\t\tmatchCount++;";
    protected final String TEXT_111 = "\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));";
    protected final String TEXT_112 = "\t\t\t\t\tif (segment == SEGMENT_COUNT - 1 && microstep == ";
    protected final String TEXT_113 = " + STAIR_COUNT - 1 ) {";
    protected final String TEXT_114 = "\t\t\t\t\t\tapply";
    protected final String TEXT_115 = "(vertex, match, appCount++);";
    protected final String TEXT_116 = "\t\t\t\t\t} else {";
    protected final String TEXT_117 = "\t\t\t\t\t\tsendMessage(vertex.getId(), match);";
    protected final String TEXT_118 = "\t\t\t\t\t}";
    protected final String TEXT_119 = "\t\t\t\tbreak;";
    protected final String TEXT_120 = "\t\t\t}";
    protected final String TEXT_121 = "\t\t}";
    protected final String TEXT_122 = "\t\t\t\t\ttargets = new HashSet<>();";
    protected final String TEXT_123 = "\t\t\t\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {";
    protected final String TEXT_124 = "\t\t\t\t\t\tif (edge.getValue().get() == ";
    protected final String TEXT_125 = " && targets.add(edge.getTargetVertexId())) {";
    protected final String TEXT_126 = "\t\t\t\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +";
    protected final String TEXT_127 = "\t\t\t\t\t\t\t\t\" sending (partial) match \" + match +";
    protected final String TEXT_128 = "\t\t\t\t\t\t\t\t\" forward to vertex \" + edge.getTargetVertexId());";
    protected final String TEXT_129 = "\t\t\t\t\t\t\tsendMessage(edge.getTargetVertexId(), match);";
    protected final String TEXT_130 = "\t\t\t\t\t\t}";
    protected final String TEXT_131 = String.valueOf(this.NL) + "\t\t\t\t}";
    protected final String TEXT_132 = String.valueOf(this.NL) + "\t\t\tdefault:" + this.NL + "\t\t\t\tif (finalMatches.add(match)) {" + this.NL + "\t\t\t\t\tmatchCount++;" + this.NL + "\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));" + this.NL + "\t\t\t\t\tif (segment == SEGMENT_COUNT - 1 && microstep == ";
    protected final String TEXT_133 = " + STAIR_COUNT - 1 ) {" + this.NL + "\t\t\t\t\t\tapply";
    protected final String TEXT_134 = "(vertex, match, appCount++);" + this.NL + "\t\t\t\t\t} else {" + this.NL + "\t\t\t\t\t\tsendMessage(vertex.getId(), match);" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}";
    protected final String TEXT_135 = String.valueOf(this.NL) + "\t\t\t}";
    protected final String TEXT_136 = String.valueOf(this.NL) + "\t\t\tindex ++;";
    protected final String TEXT_137 = String.valueOf(this.NL) + "\t\t}";
    protected final String TEXT_138 = String.valueOf(this.NL) + "\t\tif (matchCount > 0) {" + this.NL + "\t\t\taggregate(AGGREGATOR_MATCHES, new LongWritable(matchCount));" + this.NL + "\t\t}" + this.NL + "\t\tif (appCount > 0) {" + this.NL + "\t\t\taggregate(AGGREGATOR_RULE_APPLICATIONS, new LongWritable(appCount));" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Filter matches per segment for the rule \"";
    protected final String TEXT_139 = "\"." + this.NL + "\t * @param vertex The current vertex." + this.NL + "\t * @param matches The current matches." + this.NL + "\t * @param segment The current segment." + this.NL + "\t * @param microstep The current microstep." + this.NL + "\t * @param finalMatches Set of final matches." + this.NL + "\t * @return The filtered matches." + this.NL + "\t */" + this.NL + "\tprotected Iterable<Match> filter";
    protected final String TEXT_140 = "(Vertex<VertexId, ByteWritable, ByteWritable> vertex, Iterable<Match> matches, int segment, int microstep, Set<Match> finalMatches) throws IOException {" + this.NL + "\t\tif (segment > 0) {" + this.NL + "\t\t\tList<Match> filtered = new ArrayList<>();" + this.NL + "\t\t\tlong matchCount = 0;" + this.NL + "\t\t\tlong appCount = 0;" + this.NL + "\t\t\tfor (Match match : matches) {" + this.NL + "\t\t\t\tint matchSegment = match.getSegment();" + this.NL + "\t\t\t\tif (matchSegment < segment) {" + this.NL + "\t\t\t\t\tif (!finalMatches.add(match)) {" + this.NL + "\t\t\t\t\t\tcontinue;" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t\tmatchCount++;" + this.NL + "\t\t\t\t\tif (segment == SEGMENT_COUNT - 1 && microstep == ";
    protected final String TEXT_141 = "(vertex, match, appCount++);" + this.NL + "\t\t\t\t\t} else {" + this.NL + "\t\t\t\t\t\tsendMessage(vertex.getId(), match);" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t} else if (matchSegment > segment) {" + this.NL + "\t\t\t\t\tthrow new RuntimeException(\"Received match \" + match +" + this.NL + "\t\t\t\t\t\t\" of rule ";
    protected final String TEXT_142 = " of segment \" +" + this.NL + "\t\t\t\t\t\tmatchSegment + \", but current segment is only \" + segment);" + this.NL + "\t\t\t\t} else {" + this.NL + "\t\t\t\t\tfiltered.add(match.copy());" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (matchCount > 0) {" + this.NL + "\t\t\t\taggregate(AGGREGATOR_MATCHES, new LongWritable(matchCount));" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (appCount > 0) {" + this.NL + "\t\t\t\taggregate(AGGREGATOR_RULE_APPLICATIONS, new LongWritable(appCount));" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn filtered;" + this.NL + "\t\t}" + this.NL + "\t\treturn matches;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Apply the rule \"";
    protected final String TEXT_143 = "\" to a given match." + this.NL + "\t * @param vertex The base vertex." + this.NL + "\t * @param match The match object." + this.NL + "\t * @param matchIndex Match index." + this.NL + "\t * @return true if the rule was applied." + this.NL + "\t * @throws IOException On I/O errors." + this.NL + "\t */" + this.NL + "\tprotected boolean apply";
    protected final String TEXT_144 = "(" + this.NL + "\t\tVertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "\t\tMatch match, long matchIndex) throws IOException {";
    protected final String TEXT_145 = String.valueOf(this.NL) + "\t\tVertexId cur";
    protected final String TEXT_146 = " = match.getVertexId(";
    protected final String TEXT_147 = String.valueOf(this.NL) + "\t\tLOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "\t\t\t\" applying rule ";
    protected final String TEXT_148 = " with match \" + match);";
    protected final String TEXT_149 = String.valueOf(this.NL) + "\t\tremoveEdgesRequest(cur";
    protected final String TEXT_150 = ", cur";
    protected final String TEXT_151 = String.valueOf(this.NL) + "\t\tremoveVertexRequest(cur";
    protected final String TEXT_152 = String.valueOf(this.NL) + "\t\tVertexId new";
    protected final String TEXT_153 = " =";
    protected final String TEXT_154 = String.valueOf(this.NL) + "\t\t\tVertexId.randomVertexId();";
    protected final String TEXT_155 = String.valueOf(this.NL) + "\t\t\tderiveVertexId(vertex.getId(), (int) matchIndex, ";
    protected final String TEXT_156 = String.valueOf(this.NL) + "\t\taddVertexRequest(new";
    protected final String TEXT_157 = ", new ByteWritable(";
    protected final String TEXT_158 = String.valueOf(this.NL) + "\t\tVertexId src";
    protected final String TEXT_159 = " = new";
    protected final String TEXT_160 = " = cur";
    protected final String TEXT_161 = String.valueOf(this.NL) + "\t\tVertexId trg";
    protected final String TEXT_162 = String.valueOf(this.NL) + "\t\tEdge<VertexId, ByteWritable> edge";
    protected final String TEXT_163 = " = EdgeFactory.create(trg";
    protected final String TEXT_164 = "));" + this.NL + "\t\taddEdgeRequest(src";
    protected final String TEXT_165 = ", edge";
    protected final String TEXT_166 = String.valueOf(this.NL) + "\t\treturn true;" + this.NL + "\t}";
    protected final String TEXT_167 = String.valueOf(this.NL) + "\t/**" + this.NL + "\t * Derive a new vertex Id from an exiting one." + this.NL + "\t * @param baseId The base vertex Id." + this.NL + "\t * @param matchIndex The index of the match." + this.NL + "\t * @param vertexIndex The index of the new vertex." + this.NL + "\t * @return The derived vertex Id." + this.NL + "\t */" + this.NL + "\tprivate VertexId deriveVertexId(VertexId baseId, int matchIndex, int vertexIndex) {" + this.NL + "\t\tlong generation = ((LongWritable) getAggregatedValue(AGGREGATOR_NODE_GENERATION)).get();" + this.NL + "\t\treturn baseId.append((byte) generation).append((byte) matchIndex).append((byte) vertexIndex);" + this.NL + "\t}" + this.NL;
    protected final String TEXT_168 = String.valueOf(this.NL) + "\t/**" + this.NL + "\t * Get the segment that a vertex belongs to." + this.NL + "\t * @param vertexId The ID of the vertex." + this.NL + "\t * @return The segment of the vertex." + this.NL + "\t */" + this.NL + "\tprivate int getSegment(VertexId vertexId) {" + this.NL + "\t\treturn Math.abs(vertexId.hashCode()) % SEGMENT_COUNT;" + this.NL + "\t}" + this.NL + "\t/**" + this.NL + "\t * Get the part that a vertex belongs to" + this.NL + "\t*/" + this.NL + "\tprivate int getPart(VertexId vertexId) {" + this.NL + "\t\treturn Math.abs(vertexId.hashCode()) % STAIR_COUNT;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Master compute which registers and updates the required aggregators." + this.NL + "\t */" + this.NL + "\tpublic static class MasterCompute extends DefaultMasterCompute {" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Stack for storing unit success flags." + this.NL + "\t\t */" + this.NL + "\t\tprotected final Deque<Boolean> unitSuccesses = new ArrayDeque<>();" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Stack for storing the execution orders of independent units." + this.NL + "\t\t */" + this.NL + "\t\tprotected final Deque<List<Integer>> unitOrders = new ArrayDeque<>();" + this.NL + this.NL + "\t\t/*" + this.NL + "\t\t * (non-Javadoc)" + this.NL + "\t\t * @see org.apache.giraph.master.DefaultMasterCompute#compute()" + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic void compute() {" + this.NL + "\t\t\tlong ruleApps = ((LongWritable) getAggregatedValue(AGGREGATOR_RULE_APPLICATIONS)).get();";
    protected final String TEXT_169 = String.valueOf(this.NL) + "\t\t\tlong matches = ((LongWritable) getAggregatedValue(AGGREGATOR_MATCHES)).get();" + this.NL + "\t\t\tif (getSuperstep() > 0) {" + this.NL + "\t\t\t\tLOG.info(matches + \" (partial) matches computed and \" +" + this.NL + "\t\t\t\t\truleApps + \" rule applications conducted in superstep \" +" + this.NL + "\t\t\t\t\t(getSuperstep() - 1));" + this.NL + "\t\t\t}";
    protected final String TEXT_170 = String.valueOf(this.NL) + "\t\t\tif (ruleApps > 0) {" + this.NL + "\t\t\t\tlong nodeGen = ((LongWritable) getAggregatedValue(AGGREGATOR_NODE_GENERATION)).get();" + this.NL + "\t\t\t\tsetAggregatedValue(AGGREGATOR_NODE_GENERATION, new LongWritable(nodeGen + 1));" + this.NL + "\t\t\t}" + this.NL + "\t\t\tApplicationStack stack;" + this.NL + "\t\t\tif (getSuperstep() == 0) {" + this.NL + "\t\t\t\tstack = new ApplicationStack();" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_171 = ", 0, 0);";
    protected final String TEXT_172 = String.valueOf(this.NL) + "\t\t\t\tstack = nextRuleStep(stack, ruleApps);";
    protected final String TEXT_173 = String.valueOf(this.NL) + "\t\t\t} else {" + this.NL + "\t\t\t\tstack = getAggregatedValue(AGGREGATOR_APPLICATION_STACK);" + this.NL + "\t\t\t\tstack = nextRuleStep(stack, ruleApps);" + this.NL + "\t\t\t}" + this.NL + "\t\t\tsetAggregatedValue(AGGREGATOR_APPLICATION_STACK, stack);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Compute the next rule application stack." + this.NL + "\t\t * @param stack The current application stack." + this.NL + "\t\t * @param ruleApps Number of rule applications in last superstep." + this.NL + "\t\t * @return The new application stack." + this.NL + "\t\t */" + this.NL + "\t\tprivate ApplicationStack nextRuleStep(ApplicationStack stack, long ruleApps) {" + this.NL + "\t\t\twhile (stack.getStackSize() > 0) {" + this.NL + "\t\t\t\tint unit = stack.getLastUnit();" + this.NL + "\t\t\t\tint segment = stack.getLastSegment();" + this.NL + "\t\t\t\tint microstep = stack.getLastMicrostep();" + this.NL + "\t\t\t\tstack = stack.removeLast();" + this.NL + "\t\t\t\tswitch (unit) {";
    protected final String TEXT_174 = String.valueOf(this.NL) + "\t\t\t\tcase ";
    protected final String TEXT_175 = ":" + this.NL + "\t\t\t\t\tstack = process";
    protected final String TEXT_176 = "(stack";
    protected final String TEXT_177 = ", microstep";
    protected final String TEXT_178 = ");" + this.NL + "\t\t\t\t\tbreak;";
    protected final String TEXT_179 = String.valueOf(this.NL) + "\t\t\t\tdefault:" + this.NL + "\t\t\t\t\tthrow new RuntimeException(\"Unknown unit \" + unit);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tif (stack.getStackSize() > 0) {" + this.NL + "\t\t\t\t\tunit = stack.getLastUnit();";
    protected final String TEXT_180 = "unit == ";
    protected final String TEXT_181 = String.valueOf(this.NL) + "\t\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn stack;" + this.NL + "\t\t}";
    protected final String TEXT_182 = String.valueOf(this.NL) + this.NL + "\t\t/**" + this.NL + "\t\t * Process ";
    protected final String TEXT_183 = " \"";
    protected final String TEXT_184 = "\"." + this.NL + "\t\t * @param stack The current application stack.";
    protected final String TEXT_185 = String.valueOf(this.NL) + "\t\t * @param segment The current segment.";
    protected final String TEXT_186 = String.valueOf(this.NL) + "\t\t * @param microstep The current microstep.";
    protected final String TEXT_187 = String.valueOf(this.NL) + "\t\t * @param ruleApps Number of rule applications in last superstep.";
    protected final String TEXT_188 = String.valueOf(this.NL) + "\t\t * @return The new application stack." + this.NL + "\t\t */" + this.NL + "\t\tprivate ApplicationStack process";
    protected final String TEXT_189 = "(ApplicationStack stack";
    protected final String TEXT_190 = ", int microstep";
    protected final String TEXT_191 = ") {";
    protected final String TEXT_192 = String.valueOf(this.NL) + "\t\t\tif (microstep > 0 && !unitSuccesses.pop()) {" + this.NL + "\t\t\t\tunitSuccesses.push(false);" + this.NL + "\t\t\t} else if (microstep == ";
    protected final String TEXT_193 = ") {" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t} else if (microstep < ";
    protected final String TEXT_194 = ") {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_195 = ", 0, microstep + 1);" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_196 = ", 0, 0);" + this.NL + "\t\t\t}";
    protected final String TEXT_197 = ") {" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tswitch (microstep) {";
    protected final String TEXT_198 = ":" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_199 = ", 0, ";
    protected final String TEXT_200 = ");" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_201 = ", 0, 0);" + this.NL + "\t\t\t\t\tbreak;";
    protected final String TEXT_202 = String.valueOf(this.NL) + "\t\t\t\tdefault:" + this.NL + "\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}";
    protected final String TEXT_203 = String.valueOf(this.NL) + "\t\t\tif (microstep == 0) {" + this.NL + "\t\t\t\tList<Integer> order = new ArrayList<>();" + this.NL + "\t\t\t\tfor (int i = 0; i < ";
    protected final String TEXT_204 = "; i++) {" + this.NL + "\t\t\t\t\torder.add(i);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tCollections.shuffle(order);" + this.NL + "\t\t\t\tunitOrders.push(order);" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (microstep > 0 && unitSuccesses.pop()) {" + this.NL + "\t\t\t\tunitOrders.pop();" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t} else if (microstep == ";
    protected final String TEXT_205 = ") {" + this.NL + "\t\t\t\tunitOrders.pop();" + this.NL + "\t\t\t\tunitSuccesses.push(false);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tint next = unitOrders.peek().get(microstep);" + this.NL + "\t\t\t\tswitch (next) {";
    protected final String TEXT_206 = ", 0, microstep + 1);" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_207 = String.valueOf(this.NL) + "\t\t\tif (microstep == 0 || unitSuccesses.pop()) {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_208 = ", 0, 1);" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_209 = ", 0, 0);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t}";
    protected final String TEXT_210 = String.valueOf(this.NL) + "\t\t\tif (microstep < ";
    protected final String TEXT_211 = " + (STAIR_COUNT - 1)) {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_212 = ", segment, microstep + 1);" + this.NL + "\t\t\t} else if (segment < SEGMENT_COUNT - 1) {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_213 = ", segment + 1, 0);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tunitSuccesses.push(ruleApps > 0);" + this.NL + "\t\t\t}";
    protected final String TEXT_214 = String.valueOf(this.NL) + "\t\t\treturn stack;" + this.NL + "\t\t}";
    protected final String TEXT_215 = String.valueOf(this.NL) + this.NL + "\t\t/*" + this.NL + "\t\t * (non-Javadoc)" + this.NL + "\t\t * @see org.apache.giraph.master.DefaultMasterCompute#initialize()" + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic void initialize() throws InstantiationException, IllegalAccessException {" + this.NL + "\t\t\tregisterAggregator(AGGREGATOR_MATCHES, LongSumAggregator.class);" + this.NL + "\t\t\tregisterAggregator(AGGREGATOR_RULE_APPLICATIONS, LongSumAggregator.class);" + this.NL + "\t\t\tregisterPersistentAggregator(AGGREGATOR_NODE_GENERATION, LongSumAggregator.class);" + this.NL + "\t\t\tregisterPersistentAggregator(AGGREGATOR_APPLICATION_STACK, ApplicationStackAggregator.class);" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + "}";

    public static synchronized GiraphRuleTemplate create(String lineSeparator) {
        nl = lineSeparator;
        GiraphRuleTemplate result = new GiraphRuleTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Map args = (Map)argument;
        Map ruleData = (Map)args.get("ruleData");
        Unit mainUnit = (Unit)args.get("mainUnit");
        String className = (String)args.get("className");
        String packageName = (String)args.get("packageName");
        boolean masterLogging = (Boolean)args.get("masterLogging");
        boolean vertexLogging = (Boolean)args.get("vertexLogging");
        boolean useUUIDs = (Boolean)args.get("useUUIDs");
        int segmentCount = (Integer)args.get("segmentCount");
        int stairCount = (Integer)args.get("stairCount");
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        allUnits.add(mainUnit);
        allUnits.addAll((Collection<Unit>)mainUnit.getSubUnits(true));
        ArrayList rules = new ArrayList(ruleData.keySet());
        boolean needsEdgeFactory = false;
        boolean needsVertexIdFactory = false;
        int maxCreatedNodes = 0;
        for (GiraphRuleData data : ruleData.values()) {
            if (!data.changeInfo.getCreatedEdges().isEmpty()) {
                needsEdgeFactory = true;
            }
            if (!data.changeInfo.getCreatedNodes().isEmpty()) {
                needsVertexIdFactory = true;
            }
            maxCreatedNodes = Math.max(maxCreatedNodes, data.changeInfo.getCreatedNodes().size());
        }
        boolean needsCollections = false;
        for (Unit unit : allUnits) {
            if (!(unit instanceof IndependentUnit)) continue;
            needsCollections = true;
            break;
        }
        stringBuffer.append("package ");
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        if (needsCollections) {
            stringBuffer.append(this.TEXT_3);
        }
        stringBuffer.append(this.TEXT_4);
        if (needsEdgeFactory) {
            stringBuffer.append(this.TEXT_5);
        }
        stringBuffer.append(this.TEXT_6);
        if (masterLogging || vertexLogging) {
            stringBuffer.append(this.TEXT_7);
        }
        stringBuffer.append(this.TEXT_8);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(mainUnit.getName());
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append(mainUnit.getName());
        stringBuffer.append(this.TEXT_14);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_15);
        Map<ENamedElement, String> typeConstants = GiraphUtil.getTypeConstants(mainUnit.getModule());
        int value = 0;
        for (ENamedElement type : typeConstants.keySet()) {
            stringBuffer.append(this.TEXT_16);
            stringBuffer.append(type.getName());
            stringBuffer.append(this.TEXT_17);
            stringBuffer.append(typeConstants.get(type));
            stringBuffer.append(" = ");
            stringBuffer.append(value++);
            stringBuffer.append(";");
        }
        Map<Unit, String> unitConstants = GiraphUtil.getUnitConstants(mainUnit);
        value = 0;
        for (Unit unit : unitConstants.keySet()) {
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append(unit instanceof Rule ? "Rule" : "Unit");
            stringBuffer.append(" constant for \"");
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_22);
            stringBuffer.append(unitConstants.get(unit));
            stringBuffer.append(" = ");
            stringBuffer.append(value++);
            stringBuffer.append(";");
        }
        if (masterLogging || vertexLogging) {
            stringBuffer.append(this.TEXT_23);
            stringBuffer.append(className);
            stringBuffer.append(".class);");
        }
        stringBuffer.append(this.TEXT_25);
        stringBuffer.append(segmentCount);
        stringBuffer.append(this.TEXT_26);
        stringBuffer.append(stairCount);
        stringBuffer.append(this.TEXT_27);
        for (Rule rule : rules) {
            stringBuffer.append(this.TEXT_28);
            stringBuffer.append(unitConstants.get(rule));
            stringBuffer.append(this.TEXT_29);
            stringBuffer.append(((GiraphRuleData)ruleData.get((Object)rule)).rule.getName());
            stringBuffer.append(this.TEXT_30);
        }
        stringBuffer.append(this.TEXT_31);
        for (GiraphRuleData data : ruleData.values()) {
            Rule rule = data.rule;
            RuleChangeInfo changeInfo = data.changeInfo;
            ArrayList<Integer> required = new ArrayList<Integer>();
            for (Node node : data.requiredNodes) {
                required.add(data.orderedLhsNodes.indexOf(node));
            }
            Collections.sort(required);
            Collections.reverse(required);
            stringBuffer.append(this.TEXT_32);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_33);
            stringBuffer.append(data.matchingSteps.size());
            stringBuffer.append(this.TEXT_34);
            stringBuffer.append(rule.getName());
            stringBuffer.append("(Vertex<VertexId, ByteWritable, ByteWritable> vertex, Iterable<Match> matches, int segment, int microstep) throws IOException {");
            if (vertexLogging) {
                stringBuffer.append(this.TEXT_36);
                stringBuffer.append(rule.getName());
                stringBuffer.append(this.TEXT_37);
            }
            stringBuffer.append(this.TEXT_38);
            stringBuffer.append(data.matchingSteps.size() > 1 ? "matches = " : "");
            stringBuffer.append("filter");
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_40);
            boolean hasJoins = false;
            int i = 0;
            while (i < data.matchingSteps.size()) {
                GiraphRuleData.MatchingStep step = data.matchingSteps.get(i);
                if (step.keepMatchesOf != null || step.isJoin) {
                    hasJoins = true;
                    stringBuffer.append(this.TEXT_41);
                    break;
                }
                ++i;
            }
            stringBuffer.append(this.TEXT_42);
            ArrayList<Integer> moreStarts = new ArrayList<Integer>();
            int i2 = 1;
            while (i2 < data.matchingSteps.size()) {
                if (data.matchingSteps.get((int)i2).isStart) {
                    moreStarts.add(i2);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < data.matchingSteps.size()) {
                GiraphRuleData.MatchingStep step = data.matchingSteps.get(i2);
                if (i2 == 0) {
                    for (Integer start : moreStarts) {
                        stringBuffer.append(this.TEXT_43);
                        stringBuffer.append(start - 1);
                        stringBuffer.append(this.TEXT_44);
                        stringBuffer.append(start);
                        stringBuffer.append(this.TEXT_45);
                    }
                    stringBuffer.append(this.TEXT_46);
                    stringBuffer.append(data.matchingSteps.size() == 1 ? "" : "&& getPart(vertex.getId()) == microstep");
                    stringBuffer.append("){");
                } else if (i2 == 1) {
                    stringBuffer.append(this.TEXT_48);
                }
                if (i2 > 0) {
                    stringBuffer.append(this.TEXT_49);
                    stringBuffer.append(i2);
                    stringBuffer.append(": ");
                }
                if (step.isJoin) {
                    stringBuffer.append(this.TEXT_51);
                    stringBuffer.append(i2);
                    stringBuffer.append(this.TEXT_52);
                    stringBuffer.append(GiraphUtil.getNodeName(step.node));
                    stringBuffer.append(this.TEXT_53);
                    stringBuffer.append(data.orderedLhsNodes.indexOf(step.node));
                    stringBuffer.append(this.TEXT_54);
                    if (vertexLogging) {
                        stringBuffer.append(this.TEXT_55);
                        stringBuffer.append(rule.getName());
                        stringBuffer.append("\");");
                    }
                    stringBuffer.append(this.TEXT_57);
                    stringBuffer.append(i2);
                    stringBuffer.append(this.TEXT_58);
                    stringBuffer.append(i2 == 0 ? "Match " : "");
                    stringBuffer.append("match = m1.append(m2);");
                    if (rule.isInjectiveMatching()) {
                        stringBuffer.append(this.TEXT_60);
                    }
                    if (step.sendBackTo != null) {
                        stringBuffer.append(this.TEXT_61);
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_62);
                            stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                            stringBuffer.append("));");
                        }
                        stringBuffer.append(this.TEXT_64);
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                        stringBuffer.append("), match);");
                    } else if (i2 == data.matchingSteps.size() - 1) {
                        for (Integer req : required) {
                            stringBuffer.append(this.TEXT_66);
                            stringBuffer.append(req);
                            stringBuffer.append(");");
                        }
                        stringBuffer.append(this.TEXT_68);
                        stringBuffer.append(i2);
                        stringBuffer.append(this.TEXT_69);
                        stringBuffer.append(data.rule.getName());
                        stringBuffer.append(this.TEXT_70);
                    }
                    stringBuffer.append(this.TEXT_71);
                } else {
                    if (step.keepMatchesOf != null) {
                        stringBuffer.append(this.TEXT_72);
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.keepMatchesOf));
                        stringBuffer.append(this.TEXT_73);
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_74);
                        }
                        stringBuffer.append(this.TEXT_75);
                    }
                    String xx = "";
                    if (step.isMatching) {
                        xx = "\t";
                        List<EClass> validTypes = GiraphUtil.getValidTypes(step.node, mainUnit.getModule());
                        stringBuffer.append(this.TEXT_76);
                        stringBuffer.append(GiraphUtil.getNodeName(step.node));
                        stringBuffer.append(":");
                        int j = 0;
                        while (j < validTypes.size()) {
                            stringBuffer.append(this.TEXT_78);
                            stringBuffer.append(j == 0 ? "ok = " : "");
                            stringBuffer.append("vertex.getValue().get() == ");
                            stringBuffer.append(typeConstants.get(validTypes.get(j)));
                            stringBuffer.append(j == validTypes.size() - 1 ? ";" : " ||");
                            ++j;
                        }
                        if (rule.isInjectiveMatching() && !step.node.getOutgoing().isEmpty()) {
                            stringBuffer.append(this.TEXT_80);
                            stringBuffer.append(step.node.getOutgoing().size());
                            stringBuffer.append(";");
                        }
                        if (i2 == 0) {
                            stringBuffer.append(this.TEXT_81);
                        }
                        stringBuffer.append(this.TEXT_82);
                    }
                    if (step.isStart) {
                        if (i2 > 0) {
                            stringBuffer.append(this.TEXT_83);
                        }
                        stringBuffer.append(this.TEXT_84);
                        stringBuffer.append(i2 == 0 ? "Match " : "");
                        stringBuffer.append("match = new Match(segment, ");
                        stringBuffer.append(i2);
                        stringBuffer.append(").append(vertex.getId());");
                    } else if (step.isMatching) {
                        NodeEquivalence equi;
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tmatch = match.append(vertex.getId());");
                        if (rule.isInjectiveMatching()) {
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tif (!match.isInjective()) {");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t\tbreak;");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t}");
                        }
                        if ((equi = data.requiredNodesEquivalences.get(step.node)) != null && equi.indexOf((Object)step.node) > 0) {
                            Node compareTo = (Node)equi.get(equi.indexOf((Object)step.node) - 1);
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tif (vertex.getId().compareTo(match.getVertexId(");
                            stringBuffer.append(data.orderedLhsNodes.indexOf(compareTo));
                            stringBuffer.append(")) < 0) {");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t\tbreak;");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t}");
                        }
                    }
                    if (step.edge != null && step.verifyEdgeTo != null) {
                        xx = String.valueOf(xx) + "\t\t";
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t// Node ");
                        stringBuffer.append(GiraphUtil.getNodeName(step.edge.getSource()));
                        stringBuffer.append(": check for edge to match of ");
                        stringBuffer.append(GiraphUtil.getNodeName(step.edge.getTarget()));
                        stringBuffer.append(" of type \"");
                        stringBuffer.append(step.edge.getType().getName());
                        stringBuffer.append("\":");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\ttargetId = match.getVertexId(");
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.verifyEdgeTo));
                        stringBuffer.append(");");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\tif (edge.getValue().get() == ");
                        stringBuffer.append(typeConstants.get(step.edge.getType()));
                        stringBuffer.append(" && edge.getTargetVertexId().equals(targetId)) {");
                    }
                    if (step.sendBackTo != null) {
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tmatchCount++;");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));");
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t\t\" sending (partial) match \" + match +");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t\t\" back to vertex \" + match.getVertexId(");
                            stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                            stringBuffer.append("));");
                        }
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tsendMessage(match.getVertexId(");
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                        stringBuffer.append("), match);");
                    } else if (i2 == data.matchingSteps.size() - 1) {
                        if (step.isStart) {
                            xx = "";
                        }
                        for (Integer req : required) {
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tmatch = match.remove(");
                            stringBuffer.append(req);
                            stringBuffer.append(");");
                        }
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tif (finalMatches.add(match)) {");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\tmatchCount++;");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\tif (segment == SEGMENT_COUNT - 1 && microstep == ");
                        stringBuffer.append(i2);
                        stringBuffer.append(" + STAIR_COUNT - 1 ) {");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t\tapply");
                        stringBuffer.append(data.rule.getName());
                        stringBuffer.append("(vertex, match, appCount++);");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t} else {");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t\tsendMessage(vertex.getId(), match);");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t}");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t}");
                    }
                    if (step.verifyEdgeTo != null) {
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tbreak;");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t}");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t}");
                        xx = xx.substring(0, xx.length() - 2);
                    }
                    if (step.edge != null && step.verifyEdgeTo == null) {
                        String yy = !step.isStart && step.isMatching ? "\t" : "";
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\tmatchCount++;");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\tmatch = match.setMicrostep((byte) (match.getMicrostep() + 1));");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\ttargets = new HashSet<>();");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t\tif (edge.getValue().get() == ");
                        stringBuffer.append(typeConstants.get(step.edge.getType()));
                        stringBuffer.append(" && targets.add(edge.getTargetVertexId())) {");
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(yy);
                            stringBuffer.append("\t\t\t\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(yy);
                            stringBuffer.append("\t\t\t\t\t\t\t\t\" sending (partial) match \" + match +");
                            stringBuffer.append(this.TEXT_87);
                            stringBuffer.append(yy);
                            stringBuffer.append("\t\t\t\t\t\t\t\t\" forward to vertex \" + edge.getTargetVertexId());");
                        }
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t\t\tsendMessage(edge.getTargetVertexId(), match);");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t\t}");
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t}");
                    }
                    if (step.isMatching) {
                        stringBuffer.append(this.TEXT_131);
                    }
                }
                stringBuffer.append(this.TEXT_87);
                stringBuffer.append(i2 == 0 ? "\t\t}" : "\t\t\t\tbreak;");
                ++i2;
            }
            if (data.matchingSteps.size() > 1) {
                if (stairCount > 1) {
                    stringBuffer.append(this.TEXT_132);
                    stringBuffer.append(data.matchingSteps.size() - 1);
                    stringBuffer.append(this.TEXT_133);
                    stringBuffer.append(data.rule.getName());
                    stringBuffer.append(this.TEXT_134);
                }
                stringBuffer.append(this.TEXT_135);
                if (hasJoins) {
                    stringBuffer.append(this.TEXT_136);
                }
                stringBuffer.append(this.TEXT_137);
            }
            stringBuffer.append(this.TEXT_138);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_139);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_140);
            stringBuffer.append(data.matchingSteps.size() - 1);
            stringBuffer.append(this.TEXT_133);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_141);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_142);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_143);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_144);
            ArrayList<Node> matchNodes = new ArrayList<Node>();
            matchNodes.addAll(data.orderedLhsNodes);
            matchNodes.removeAll(data.requiredNodes);
            int j = 0;
            while (j < matchNodes.size()) {
                Node lhsNode = (Node)matchNodes.get(j);
                Node rhsNode = data.rule.getMappings().getImage(lhsNode, data.rule.getRhs());
                boolean needed = changeInfo.getDeletedNodes().contains(lhsNode);
                for (Edge edge : lhsNode.getAllEdges()) {
                    boolean bl = needed = needed || changeInfo.getDeletedEdges().contains(edge);
                }
                if (rhsNode != null) {
                    for (Edge edge : rhsNode.getAllEdges()) {
                        boolean bl = needed = needed || changeInfo.getCreatedEdges().contains(edge);
                    }
                }
                if (needed) {
                    stringBuffer.append(this.TEXT_145);
                    stringBuffer.append(j);
                    stringBuffer.append(" = match.getVertexId(");
                    stringBuffer.append(j);
                    stringBuffer.append(");");
                }
                ++j;
            }
            if (vertexLogging) {
                stringBuffer.append(this.TEXT_147);
                stringBuffer.append(data.rule.getName());
                stringBuffer.append(" with match \" + match);");
            }
            for (Edge edge : changeInfo.getDeletedEdges()) {
                stringBuffer.append(this.TEXT_149);
                stringBuffer.append(matchNodes.indexOf(edge.getSource()));
                stringBuffer.append(", cur");
                stringBuffer.append(matchNodes.indexOf(edge.getTarget()));
                stringBuffer.append(");");
            }
            for (Node node : changeInfo.getDeletedNodes()) {
                stringBuffer.append(this.TEXT_151);
                stringBuffer.append(matchNodes.indexOf(node));
                stringBuffer.append(");");
            }
            int n = 0;
            for (Node node : changeInfo.getCreatedNodes()) {
                stringBuffer.append(this.TEXT_152);
                stringBuffer.append(n);
                stringBuffer.append(" =");
                if (useUUIDs) {
                    stringBuffer.append(this.TEXT_154);
                } else {
                    stringBuffer.append(this.TEXT_155);
                    stringBuffer.append(n);
                    stringBuffer.append(");");
                }
                stringBuffer.append(this.TEXT_156);
                stringBuffer.append(n++);
                stringBuffer.append(", new ByteWritable(");
                stringBuffer.append(typeConstants.get(node.getType()));
                stringBuffer.append("));");
            }
            int e = 0;
            for (Edge edge : changeInfo.getCreatedEdges()) {
                if (changeInfo.getCreatedNodes().contains(edge.getSource())) {
                    stringBuffer.append(this.TEXT_158);
                    stringBuffer.append(e);
                    stringBuffer.append(" = new");
                    stringBuffer.append(changeInfo.getCreatedNodes().indexOf(edge.getSource()));
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_158);
                    stringBuffer.append(e);
                    stringBuffer.append(" = cur");
                    stringBuffer.append(matchNodes.indexOf(data.rule.getMappings().getOrigin(edge.getSource())));
                    stringBuffer.append(";");
                }
                if (changeInfo.getCreatedNodes().contains(edge.getTarget())) {
                    stringBuffer.append(this.TEXT_161);
                    stringBuffer.append(e);
                    stringBuffer.append(" = new");
                    stringBuffer.append(changeInfo.getCreatedNodes().indexOf(edge.getTarget()));
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_161);
                    stringBuffer.append(e);
                    stringBuffer.append(" = cur");
                    stringBuffer.append(matchNodes.indexOf(data.rule.getMappings().getOrigin(edge.getTarget())));
                    stringBuffer.append(";");
                }
                stringBuffer.append(this.TEXT_162);
                stringBuffer.append(e);
                stringBuffer.append(" = EdgeFactory.create(trg");
                stringBuffer.append(e);
                stringBuffer.append(", new ByteWritable(");
                stringBuffer.append(typeConstants.get(edge.getType()));
                stringBuffer.append(this.TEXT_164);
                stringBuffer.append(e);
                stringBuffer.append(", edge");
                stringBuffer.append(e);
                stringBuffer.append(");");
                ++e;
            }
            stringBuffer.append(this.TEXT_166);
        }
        stringBuffer.append(this.TEXT_87);
        if (needsVertexIdFactory && !useUUIDs) {
            stringBuffer.append(this.TEXT_167);
        }
        stringBuffer.append(this.TEXT_168);
        if (masterLogging) {
            stringBuffer.append(this.TEXT_169);
        }
        stringBuffer.append(this.TEXT_170);
        stringBuffer.append(unitConstants.get(mainUnit));
        stringBuffer.append(", 0, 0);");
        if (!(mainUnit instanceof Rule)) {
            stringBuffer.append(this.TEXT_172);
        }
        stringBuffer.append(this.TEXT_173);
        for (Unit unit : allUnits) {
            stringBuffer.append(this.TEXT_174);
            stringBuffer.append(unitConstants.get(unit));
            stringBuffer.append(this.TEXT_175);
            stringBuffer.append(unit.getName());
            stringBuffer.append("(stack");
            stringBuffer.append(unit instanceof Rule ? ", segment" : "");
            stringBuffer.append(", microstep");
            stringBuffer.append(unit instanceof Rule ? ", ruleApps" : "");
            stringBuffer.append(this.TEXT_178);
        }
        stringBuffer.append(this.TEXT_179);
        int i = 0;
        while (i < rules.size()) {
            stringBuffer.append(this.TEXT_84);
            stringBuffer.append(i == 0 ? "if (" : "\t");
            stringBuffer.append("unit == ");
            stringBuffer.append(String.valueOf(unitConstants.get(rules.get(i))) + (i < rules.size() - 1 ? " ||" : ") {"));
            ++i;
        }
        stringBuffer.append(this.TEXT_181);
        for (Unit unit : allUnits) {
            stringBuffer.append(this.TEXT_182);
            stringBuffer.append(unit.eClass().getName());
            stringBuffer.append(" \"");
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_184);
            if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_185);
            }
            stringBuffer.append(this.TEXT_186);
            if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_187);
            }
            stringBuffer.append(this.TEXT_188);
            stringBuffer.append(unit.getName());
            stringBuffer.append("(ApplicationStack stack");
            stringBuffer.append(unit instanceof Rule ? ", int segment" : "");
            stringBuffer.append(", int microstep");
            stringBuffer.append(unit instanceof Rule ? ", long ruleApps" : "");
            stringBuffer.append(") {");
            if (unit instanceof IteratedUnit) {
                int iters = Integer.parseInt(((IteratedUnit)unit).getIterations());
                stringBuffer.append(this.TEXT_192);
                stringBuffer.append(iters);
                stringBuffer.append(this.TEXT_193);
                stringBuffer.append(iters);
                stringBuffer.append(this.TEXT_194);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_195);
                stringBuffer.append(unitConstants.get(((IteratedUnit)unit).getSubUnit()));
                stringBuffer.append(this.TEXT_196);
            } else if (unit instanceof SequentialUnit) {
                SequentialUnit seq = (SequentialUnit)unit;
                stringBuffer.append(this.TEXT_192);
                stringBuffer.append(seq.getSubUnits().size());
                stringBuffer.append(this.TEXT_197);
                int i3 = 0;
                while (i3 < seq.getSubUnits().size()) {
                    stringBuffer.append(this.TEXT_174);
                    stringBuffer.append(i3);
                    stringBuffer.append(this.TEXT_198);
                    stringBuffer.append(unitConstants.get(unit));
                    stringBuffer.append(", 0, ");
                    stringBuffer.append(i3 + 1);
                    stringBuffer.append(this.TEXT_200);
                    stringBuffer.append(unitConstants.get(seq.getSubUnits().get(i3)));
                    stringBuffer.append(this.TEXT_201);
                    ++i3;
                }
                stringBuffer.append(this.TEXT_202);
            } else if (unit instanceof IndependentUnit) {
                IndependentUnit indi = (IndependentUnit)unit;
                stringBuffer.append(this.TEXT_203);
                stringBuffer.append(indi.getSubUnits().size());
                stringBuffer.append(this.TEXT_204);
                stringBuffer.append(indi.getSubUnits().size());
                stringBuffer.append(this.TEXT_205);
                int i4 = 0;
                while (i4 < indi.getSubUnits().size()) {
                    stringBuffer.append(this.TEXT_174);
                    stringBuffer.append(i4);
                    stringBuffer.append(this.TEXT_198);
                    stringBuffer.append(unitConstants.get(unit));
                    stringBuffer.append(this.TEXT_206);
                    stringBuffer.append(unitConstants.get(indi.getSubUnits().get(i4)));
                    stringBuffer.append(this.TEXT_201);
                    ++i4;
                }
                stringBuffer.append(this.TEXT_202);
            } else if (unit instanceof LoopUnit) {
                stringBuffer.append(this.TEXT_207);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_208);
                stringBuffer.append(unitConstants.get(((LoopUnit)unit).getSubUnit()));
                stringBuffer.append(this.TEXT_209);
            } else if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_210);
                stringBuffer.append(((GiraphRuleData)ruleData.get((Object)unit)).matchingSteps.size() - 1);
                stringBuffer.append(this.TEXT_211);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_212);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_213);
            }
            stringBuffer.append(this.TEXT_214);
        }
        stringBuffer.append(this.TEXT_215);
        return stringBuffer.toString();
    }
}

