/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.dependency.DependencyReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cda.units.SymmetricReason;

public class ReasonFactory {
    public static final ReasonFactory eINSTANCE = new ReasonFactory();

    private ReasonFactory() {
    }

    public Reason createMinimalReason(Span reason) {
        if (reason instanceof Reason) {
            return ((Reason)reason).setMinimalReason(true);
        }
        if (reason instanceof Atom) {
            return this.createMinimalReason((Atom)reason);
        }
        try {
            throw new ReasonNotSupportedByThisFactory(reason);
        }
        catch (ReasonNotSupportedByThisFactory e) {
            e.printStackTrace();
            return null;
        }
    }

    public Reason createMinimalReason(Atom atom) {
        if (atom instanceof Atom.DeleteConflictAtom) {
            return new ConflictReason.DeleteConflictReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.CreateConflictAtom) {
            return new ConflictReason.CreateConflictReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.ChangeConflictAtom) {
            return new ConflictReason.ChangeConflictReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.DeleteDependencyAtom) {
            return new DependencyReason.DeleteDependencyReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.CreateDependencyAtom) {
            return new DependencyReason.CreateDependencyReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.ChangeDependencyAtom) {
            return new DependencyReason.ChangeDependencyReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.CreateEdgeDeleteNodeConflictAtom) {
            return new ConflictReason.CreateEdgeDeleteNodeConflictReason(atom).setMinimalReason(true);
        }
        if (atom instanceof Atom.DeleteEdgeDeleteNodeDependencyAtom) {
            return new DependencyReason.DeleteEdgeDeleteNodeDependencyReason(atom).setMinimalReason(true);
        }
        try {
            throw new ReasonNotSupportedByThisFactory(atom);
        }
        catch (ReasonNotSupportedByThisFactory e) {
            e.printStackTrace();
            return null;
        }
    }

    public Atom.DependencyAtom createDependencyAtom(Atom.ConflictAtom atom) {
        if (atom instanceof Atom.DeleteConflictAtom) {
            return new Atom.CreateDependencyAtom(atom);
        }
        if (atom instanceof Atom.CreateConflictAtom) {
            return new Atom.DeleteDependencyAtom(atom);
        }
        if (atom instanceof Atom.ChangeConflictAtom) {
            return new Atom.ChangeDependencyAtom(atom);
        }
        if (atom instanceof Atom.CreateEdgeDeleteNodeConflictAtom) {
            return new Atom.DeleteEdgeDeleteNodeDependencyAtom(atom);
        }
        try {
            throw new ReasonNotSupportedByThisFactory(atom);
        }
        catch (ReasonNotSupportedByThisFactory e) {
            e.printStackTrace();
            return null;
        }
    }

    public Reason createDependencyReason(Reason reason) {
        if (!this.validDependency(reason)) {
            return null;
        }
        if (reason instanceof SymmetricReason) {
            SymmetricReason r = (SymmetricReason)reason;
            return new SymmetricReason(this.createDependencyReason(r.getS1()), r.getS2());
        }
        if (reason instanceof ConflictReason.DeleteConflictReason) {
            return new DependencyReason.CreateDependencyReason((Span)((ConflictReason.DeleteConflictReason)reason));
        }
        if (reason instanceof ConflictReason.CreateConflictReason) {
            return new DependencyReason.DeleteDependencyReason((Span)reason);
        }
        if (reason instanceof ConflictReason.ChangeConflictReason) {
            return new DependencyReason.ChangeDependencyReason((Span)reason);
        }
        if (reason instanceof ConflictReason.CreateEdgeDeleteNodeConflictReason) {
            return new DependencyReason.DeleteEdgeDeleteNodeDependencyReason((Span)reason);
        }
        try {
            throw new ReasonNotSupportedByThisFactory(reason);
        }
        catch (ReasonNotSupportedByThisFactory e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean validDependency(Reason reason) {
        for (Mapping m : reason.getMappingsInRule1()) {
            Node n1L = m.getImage();
            Node n1R = n1L.getGraph().getRule().getMappings().getImage(n1L, null);
            String desc = reason.getRule1().getDescription();
            String string = desc = desc == null ? "" : desc;
            if (n1R != null || !Utils.isInverted(reason.getRule1())) continue;
            Node n2L = reason.getMappingIntoRule2(m.getOrigin()).getImage();
            n2L.getGraph().getRule().getMappings().getImage(n2L, null);
            if (!n1L.getAttributes().isEmpty() || n2L.getAttributes().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Reason createMinimalDependencyReason(Reason reason) {
        Reason result = this.createDependencyReason(reason);
        if (result != null) {
            result.setMinimalReason(true);
        }
        return result;
    }

    public <T extends Reason> T createSymmetricReason(T reason, Set<Reason> s2) {
        if (reason instanceof DependencyReason.DeleteEdgeDeleteNodeDependencyReason || reason instanceof ConflictReason.CreateEdgeDeleteNodeConflictReason) {
            try {
                throw new ReasonNotSupportedByThisFactory(reason);
            }
            catch (ReasonNotSupportedByThisFactory e) {
                e.printStackTrace();
                return null;
            }
        }
        return (T)new SymmetricReason(reason, s2);
    }

    public ConflictReason createDRReason(ConflictReason reason) {
        reason.setMinimalReason(false);
        return reason;
    }

    public <T extends Span> T createCEDNReason(T reason) {
        Graph S1 = HenshinFactory.eINSTANCE.createGraph();
        HashSet<Mapping> rule1Mappings = new HashSet<Mapping>();
        HashSet<Mapping> rule2Mappings = new HashSet<Mapping>();
        HashMap<Node, Node> map = new HashMap<Node, Node>();
        for (Mapping m1 : reason.mappingsInRule2) {
            Mapping m2 = reason.getMappingIntoRule1(m1.getOrigin());
            map.put(m1.getOrigin(), Utils.addNodeToGraph(m1.getImage(), m2.getImage(), S1, rule1Mappings, rule2Mappings));
        }
        for (Edge e : reason.getGraph().getEdges()) {
            Node s = (Node)map.get(e.getSource());
            Node t = (Node)map.get(e.getTarget());
            S1.getEdges().add((Object)HenshinFactory.eINSTANCE.createEdge(s, t, e.getType()));
        }
        Atom.DeleteConflictAtom a = new Atom.DeleteConflictAtom(rule1Mappings, S1, rule2Mappings);
        ConflictReason.CreateEdgeDeleteNodeConflictReason result = null;
        if (reason instanceof Reason) {
            result = new ConflictReason.CreateEdgeDeleteNodeConflictReason(a);
            ((Reason)result).setMinimalReason(((Reason)reason).isMinimalReason());
        }
        return (T)result;
    }

    public ConflictReason createForbidReason(Reason reason, Rule originalR1, Rule originalR2) {
        if (Utils.checkNcReason(reason, originalR1, originalR2)) {
            if (reason instanceof ConflictReason.DeleteConflictReason) {
                return new ConflictReason.CreateConflictReason(reason, true);
            }
            if (reason instanceof ConflictReason.CreateConflictReason) {
                return new ConflictReason.DeleteConflictReason((Span)reason, true);
            }
            if (reason instanceof ConflictReason.ChangeConflictReason) {
                return new ConflictReason.ChangeConflictReason(reason, true);
            }
        }
        return null;
    }

    public Span createRequireReason(Span reason) {
        if (!(reason instanceof SymmetricReason || reason instanceof Atom.CreateEdgeDeleteNodeConflictAtom || reason instanceof ConflictReason.CreateEdgeDeleteNodeConflictReason || reason instanceof Atom.DeleteEdgeDeleteNodeDependencyAtom || reason instanceof DependencyReason.DeleteEdgeDeleteNodeDependencyReason)) {
            reason.setRequire(true);
        }
        return reason;
    }

    public ConflictReason createJoinedReason(Reason reason1, Reason reason2) {
        Object newOrigin;
        Node newOrigin2;
        Map<Node, Node> s2ToS1 = Utils.getS2toS1Map(reason1, reason2);
        if (s2ToS1 == null) {
            return null;
        }
        EcoreUtil.Copier g1ToCopy = new EcoreUtil.Copier();
        Graph graph1Copy = (Graph)g1ToCopy.copy((EObject)reason1.getGraph());
        g1ToCopy.copyReferences();
        EcoreUtil.Copier mappingS1Copier = new EcoreUtil.Copier();
        Collection mappingsS1R1copies = mappingS1Copier.copyAll(reason1.getMappingsInRule1());
        mappingS1Copier.copyReferences();
        Collection mappingS1R2copies = mappingS1Copier.copyAll(reason1.getMappingsInRule2());
        mappingS1Copier.copyReferences();
        for (Mapping mapping : mappingsS1R1copies) {
            newOrigin2 = (Node)g1ToCopy.get((Object)mapping.getOrigin());
            mapping.setOrigin(newOrigin2);
        }
        for (Mapping mapping : mappingS1R2copies) {
            newOrigin2 = (Node)g1ToCopy.get((Object)mapping.getOrigin());
            mapping.setOrigin(newOrigin2);
        }
        EcoreUtil.Copier g2toCopy = new EcoreUtil.Copier();
        Graph graph2Copy = (Graph)g2toCopy.copy((EObject)reason2.getGraph());
        g2toCopy.copyReferences();
        EcoreUtil.Copier mappingsS2Copier = new EcoreUtil.Copier();
        Collection mappingsS2R1copies = mappingsS2Copier.copyAll(reason2.getMappingsInRule1());
        mappingsS2Copier.copyReferences();
        Collection mappingS2R2copies = mappingsS2Copier.copyAll(reason2.getMappingsInRule2());
        mappingsS2Copier.copyReferences();
        for (Mapping mapping : mappingsS2R1copies) {
            newOrigin = (Node)g2toCopy.get((Object)mapping.getOrigin());
            mapping.setOrigin((Node)newOrigin);
        }
        for (Mapping mapping : mappingS2R2copies) {
            newOrigin = (Node)g2toCopy.get((Object)mapping.getOrigin());
            mapping.setOrigin((Node)newOrigin);
        }
        LinkedList<Node> toDeleteInG2Copy = new LinkedList<Node>();
        for (Edge edgeG2 : reason2.getGraph().getEdges()) {
            Node nodeInGraph1;
            Edge edgeG2Copy = (Edge)g2toCopy.get((Object)edgeG2);
            if (s2ToS1.containsKey(edgeG2.getSource())) {
                nodeInGraph1 = s2ToS1.get(edgeG2.getSource());
                Node newSourceG1Copy = (Node)g1ToCopy.get((Object)nodeInGraph1);
                toDeleteInG2Copy.add(edgeG2Copy.getSource());
                edgeG2Copy.setSource(newSourceG1Copy);
            }
            if (!s2ToS1.containsKey(edgeG2.getTarget())) continue;
            nodeInGraph1 = s2ToS1.get(edgeG2.getTarget());
            Node newTargetG1Copy = (Node)g1ToCopy.get((Object)nodeInGraph1);
            toDeleteInG2Copy.add(edgeG2Copy.getTarget());
            edgeG2Copy.setTarget(newTargetG1Copy);
        }
        Utils.removeRedundantNodes(graph2Copy, mappingsS2R1copies, mappingS2R2copies, toDeleteInG2Copy);
        graph1Copy.getNodes().addAll((Collection)graph2Copy.getNodes());
        graph1Copy.getEdges().addAll((Collection)graph2Copy.getEdges());
        HashSet<Mapping> mappingsToR1 = new HashSet<Mapping>();
        mappingsToR1.addAll(mappingsS1R1copies);
        mappingsToR1.addAll(mappingsS2R1copies);
        HashSet<Mapping> mappingsToR2 = new HashSet<Mapping>();
        mappingsToR2.addAll(mappingS1R2copies);
        mappingsToR2.addAll(mappingS2R2copies);
        HashSet<Reason> originMCRs = new HashSet<Reason>();
        if (reason1.isMinimalReason()) {
            originMCRs.add(reason1);
        } else {
            originMCRs.addAll(reason1.getOriginMCRs());
        }
        if (reason2.isMinimalReason()) {
            originMCRs.add(reason2);
        } else {
            originMCRs.addAll(reason2.getOriginMCRs());
        }
        if (reason1.getClass() == reason2.getClass()) {
            if (reason1 instanceof ConflictReason.ChangeConflictReason) {
                return new ConflictReason.ChangeConflictReason(mappingsToR1, graph1Copy, mappingsToR2, originMCRs);
            }
            if (reason1 instanceof ConflictReason.DeleteConflictReason) {
                return new ConflictReason.DeleteConflictReason(mappingsToR1, graph1Copy, mappingsToR2, originMCRs);
            }
            if (reason1 instanceof ConflictReason.CreateConflictReason) {
                return new ConflictReason.CreateConflictReason(mappingsToR1, graph1Copy, mappingsToR2, originMCRs);
            }
        }
        return null;
    }

    public Atom createForbidAtom(Atom a, Rule originalR1, Rule originalR2) {
        if (Utils.checkNcReason(a, originalR1, originalR2)) {
            if (a instanceof Atom.DeleteConflictAtom) {
                return (Atom)new Atom.CreateConflictAtom(a).setForbid(true);
            }
            if (a instanceof Atom.CreateConflictAtom) {
                return (Atom)new Atom.DeleteConflictAtom(a).setForbid(true);
            }
            if (a instanceof Atom.ChangeConflictAtom) {
                return (Atom)new Atom.ChangeConflictAtom(a).setForbid(true);
            }
        }
        return null;
    }

    public Atom createRequireAtom(Atom a, Rule originalR1, Rule originalR2) {
        if (Utils.checkNcReason(a, originalR1, originalR2)) {
            return (Atom)a.setRequire(true);
        }
        return null;
    }

    public static class ReasonNotSupportedByThisFactory
    extends Exception {
        private static final long serialVersionUID = 123121434L;

        public ReasonNotSupportedByThisFactory(Span reason) {
            super("The " + reason.NAME + " is not supported by this Factory yet");
        }
    }
}

