/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.mining.core;

import de.parsemis.graph.Graph;
import de.parsemis.graph.HPMutableGraph;
import de.parsemis.graph.ListGraph;
import de.parsemis.graph.MutableGraph;
import de.parsemis.parsers.LabelParser;
import java.util.Map;
import org.eclipse.emf.henshin.variability.mergein.mining.MiningManagerFactory;
import org.eclipse.emf.henshin.variability.mergein.mining.core.HenshinGraphToParsemisGraphElementsMap;
import org.eclipse.emf.henshin.variability.mergein.mining.core.ParsemisParserSerializer;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.DefaultAttributeNodeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.DefaultEdgeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.DefaultNodeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.IEdgeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.INodeLabel;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinAttributeNode;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;

public class HenshinGraphToParsemisConverter {
    private HPMutableGraph<INodeLabel, IEdgeLabel> highPerformanceGraph;
    private Map<Graph<INodeLabel, IEdgeLabel>, HenshinGraphToParsemisGraphElementsMap> maps = MiningManagerFactory.getInstance().getManager().getHenshinToMinableGraphElementsMap();

    public Graph<INodeLabel, IEdgeLabel> createParsemisGraph(HenshinGraph henshinGraph) {
        ListGraph.Factory factory = new ListGraph.Factory((LabelParser)new ParsemisParserSerializer(), (LabelParser)new ParsemisParserSerializer());
        MutableGraph graph = factory.newGraph(henshinGraph.getRuleName());
        this.highPerformanceGraph = (HPMutableGraph)graph.toHPGraph();
        HenshinGraphToParsemisGraphElementsMap map = new HenshinGraphToParsemisGraphElementsMap();
        this.maps.put((Graph<INodeLabel, IEdgeLabel>)graph, map);
        for (HenshinNode node : henshinGraph.vertexSet()) {
            this.addNodeToGraph(node, map);
        }
        for (HenshinEdge edge : henshinGraph.edgeSet()) {
            HenshinNode source = (HenshinNode)henshinGraph.getEdgeSource(edge);
            HenshinNode target = (HenshinNode)henshinGraph.getEdgeTarget(edge);
            this.addEdgeToGraph(edge, source, target, map);
        }
        return this.highPerformanceGraph.toGraph();
    }

    private boolean addNodeToGraph(HenshinNode node, HenshinGraphToParsemisGraphElementsMap theMap) {
        DefaultNodeLabel newNodeLabel = node instanceof HenshinAttributeNode ? new DefaultAttributeNodeLabel((HenshinAttributeNode)node) : new DefaultNodeLabel(node);
        int index = this.highPerformanceGraph.addNodeIndex((Object)newNodeLabel);
        theMap.put(node, index);
        return true;
    }

    private void addEdgeToGraph(HenshinEdge edge, HenshinNode source, HenshinNode target, HenshinGraphToParsemisGraphElementsMap theMap) {
        DefaultEdgeLabel edgeLabel = new DefaultEdgeLabel(edge);
        int sourceIndex = theMap.get(source);
        int targetIndex = theMap.get(target);
        int edgeIndex = this.highPerformanceGraph.addEdgeIndex(sourceIndex, targetIndex, (Object)edgeLabel, 1);
        theMap.put(edge, edgeIndex);
    }
}

