/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.scanners;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.codegen.jet.editor.preferences.JETTemplateEditorPreferenceConstants;
import org.eclipse.emf.codegen.jet.editor.util.rules.JETTemplateBracketRule;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;

/**
 */
public class JETTemplateJavaMultiLineCommentScanner extends AbstractJETTemplateScanner {

  /**
   * Constructor for JETTemplateJavaMultiLineCommentScanner.
   * @param colorManager IColorManager
   * @param preferenceStore IPreferenceStore
   */
  public JETTemplateJavaMultiLineCommentScanner(IColorManager colorManager, IPreferenceStore preferenceStore) {
    super(colorManager, preferenceStore);
    initialize();
  }
  /**
   * Method getTokenProperties.
   * @return String[]
   */
  public String[] getTokenProperties() {
    return colorProperties;
  }

  private static String colorProperties[] = { JETTemplateEditorPreferenceConstants.JET_DIRECTIVE_BACKGROUND_COLOR,
      JETTemplateEditorPreferenceConstants.JAVA_KEYWORD_COLOR, 
      JETTemplateEditorPreferenceConstants.JET_STRING_COLOR,
      JETTemplateEditorPreferenceConstants.JET_BRACKET_COLOR,
      JETTemplateEditorPreferenceConstants.DEFAULT_FG_COLOR };

  /*
   * @see AbstractJavaScanner#createRules()
   */
  protected List createRules() {
    List brRules = new ArrayList();

    if (preferenceStore != null) {
      Color fg = getColor(PreferenceConstants.EDITOR_MULTI_LINE_COMMENT_COLOR);
      Color bg = getColor(JETTemplateEditorPreferenceConstants.JET_STRING_OR_COMMENT_BACKGROUND_COLOR);
      boolean isBold = false;
      
      isBold = preferenceStore.getBoolean(JETTemplateEditorPreferenceConstants.JET_BRACKET_BOLD);
      IToken bracket = new Token(new TextAttribute(
          getColor(JETTemplateEditorPreferenceConstants.JET_BRACKET_COLOR), bg, isBold ? 1 : 0));
      
      isBold = preferenceStore.getBoolean(PreferenceConstants.EDITOR_MULTI_LINE_COMMENT_BOLD);
      IToken code = new Token(new TextAttribute(fg, bg, isBold ? 1 : 0));

      isBold = preferenceStore.getBoolean(JETTemplateEditorPreferenceConstants.DEFAULT_FG_BOLD);
      fg = getColor(JETTemplateEditorPreferenceConstants.DEFAULT_FG_COLOR);

      bg = getColor(JETTemplateEditorPreferenceConstants.JET_EXPRESSION_BACKGROUND_COLOR);
      IToken expression = new Token(new TextAttribute(fg, bg, isBold ? 1 : 0));

      bg = getColor(JETTemplateEditorPreferenceConstants.JET_DIRECTIVE_BACKGROUND_COLOR);
      IToken directive = new Token(new TextAttribute(fg, bg, isBold ? 1 : 0));

      bg = getColor(JETTemplateEditorPreferenceConstants.JET_SCRIPTLET_BACKGROUND_COLOR);
      IToken scriptlet = new Token(new TextAttribute(fg, bg, isBold ? 1 : 0));
      
      // Add rule for brackets.
      brRules.add(new JETTemplateBracketRule(bracket));
      
      // Add rule for expressions.
      brRules.add(new MultiLineRule("<%=", "%>", expression, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

      // Add rule for directives.
      brRules.add(new MultiLineRule("<%@", "%>", directive, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

      // Add rule for scriptlets.
      brRules.add(new MultiLineRule("<%", "%>", scriptlet, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

      setRules((IRule[]) brRules.toArray(new IRule[brRules.size()]));
      setDefaultReturnToken(code);
    }

    return brRules;
  }

}