/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.model.VarValueTO;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugElement;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugThread;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugValue;
import org.eclipse.emf.mwe.internal.ui.debug.processing.DebugModelManager;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.emf.mwe.ui.debug.model.MWEBreakpoint;

public class DebugTarget
extends DebugElement
implements IDebugTarget {
    private IProcess fProcess;
    private ILaunch fLaunch;
    private DebugThread fThread;
    private DebugModelManager dmm;
    private Map<Integer, DebugValue> valueCache = new HashMap<Integer, DebugValue>();
    protected boolean suspended;

    public static DebugTarget newDebugTarget(final ILaunch launch, final IProcess process, final Connection conn) throws CoreException {
        final DebugTarget[] target = new DebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) throws DebugException {
                target[0] = new DebugTarget(launch, process, conn, null);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null, 0, null);
        }
        catch (CoreException e) {
            Activator.logError((Exception)((Object)e));
            Activator.showError(e.getStatus());
            throw e;
        }
        launch.addDebugTarget((IDebugTarget)target[0]);
        return target[0];
    }

    private DebugTarget(ILaunch launch, IProcess process, Connection conn) throws DebugException {
        super(null);
        this.fLaunch = launch;
        this.target = this;
        this.fProcess = process;
        this.fThread = new DebugThread(this);
        this.dmm = DebugModelManager.newDebugModelManager(this, conn);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() {
        return new IThread[]{this.fThread};
    }

    public DebugThread getThread() {
        return this.fThread;
    }

    public void removeThread() {
        this.fThread = null;
    }

    public boolean hasThreads() {
        return this.fThread != null;
    }

    public String getName() {
        try {
            return "Workflow: " + this.fLaunch.getLaunchConfiguration().getAttribute("startWorkflow", "");
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    @Override
    public DebugModelManager getDebugModelManager() {
        return this.dmm;
    }

    public DebugValue getDebugValue(VarValueTO varTO) {
        DebugValue value = null;
        int valueId = varTO.valueId;
        if (valueId == 0) {
            value = new DebugValue(this, varTO);
        } else {
            value = this.valueCache.get(valueId);
            if (value == null) {
                value = new DebugValue(this, varTO);
                this.valueCache.put(valueId, value);
            }
        }
        return value;
    }

    public void updateDebugValues(List<VarValueTO> vars) {
        for (VarValueTO varTO : vars) {
            DebugValue value = this.valueCache.get(varTO.valueId);
            if (value == null || !value.isDirty()) continue;
            value.setVarTO(varTO);
        }
    }

    public boolean canResume() {
        return this.suspended && !this.isTerminated();
    }

    public boolean canSuspend() {
        return !this.suspended && !this.isTerminated();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.dmm.requireResume();
    }

    public void suspend() throws DebugException {
        this.dmm.requireSuspend();
    }

    public void setSuspended(boolean value) {
        this.suspended = value;
    }

    public void setVariablesDirty() {
        for (DebugValue entry : this.valueCache.values()) {
            if (entry == null) continue;
            entry.setDirty(true);
        }
    }

    public void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.emf.mwe.debug.model");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint element = iBreakpointArray[n2];
            this.breakpointAdded(element);
            ++n2;
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals("org.eclipse.emf.mwe.debug.model");
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.dmm.requireSetBreakpoint((MWEBreakpoint)breakpoint);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                this.dmm.requireRemoveBreakpoint((MWEBreakpoint)breakpoint);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public boolean canTerminate() {
        return this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.getProcess().isTerminated();
    }

    public void terminate() throws DebugException {
        this.dmm.requireTerminate();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        return null;
    }

    /* synthetic */ DebugTarget(ILaunch iLaunch, IProcess iProcess, Connection connection, DebugTarget debugTarget) throws DebugException {
        this(iLaunch, iProcess, connection);
    }
}

