/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.highlighting;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.services.Mwe2GrammarAccess;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private Mwe2GrammarAccess grammarAccess;
    @Inject
    protected OperationCanceledManager operationCanceledManager;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null) {
            return;
        }
        BidiTreeIterator iter = resource.getParseResult().getRootNode().getAsTreeIterable().iterator();
        while (iter.hasNext()) {
            Component component;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            INode node = (INode)iter.next();
            EObject grammarElement = node.getGrammarElement();
            if (grammarElement == this.grammarAccess.getPropertyReferenceImplAccess().getReferableDeclaredPropertyCrossReference_0()) {
                this.highlightNode(node, "property_ref", acceptor);
                this.highlightNode(node, "string_prop_ref", acceptor);
                for (INode sibling : node.getParent().getChildren()) {
                    if (sibling == node || sibling.getGrammarElement() != this.grammarAccess.getML_COMMENTRule() && sibling.getGrammarElement() != this.grammarAccess.getSL_COMMENTRule()) continue;
                    this.highlightNode(sibling, "comment", acceptor);
                }
                if (!(node instanceof ICompositeNode)) continue;
                for (INode child : ((ICompositeNode)node).getChildren()) {
                    if (child.getGrammarElement() != this.grammarAccess.getML_COMMENTRule() && child.getGrammarElement() != this.grammarAccess.getSL_COMMENTRule()) continue;
                    this.highlightNode(child, "comment", acceptor);
                }
                continue;
            }
            if (grammarElement == this.grammarAccess.getPropertyReferenceAccess().getDollarSignLeftCurlyBracketKeyword_0() || grammarElement == this.grammarAccess.getPropertyReferenceAccess().getRightCurlyBracketKeyword_2()) {
                this.highlightNode(node, "string_prop_ref", acceptor);
                continue;
            }
            if (grammarElement == this.grammarAccess.getReferenceAccess().getReferableReferrableCrossReference_0()) {
                this.highlightNode(node, "property_ref", acceptor);
                continue;
            }
            if (grammarElement == this.grammarAccess.getAssignmentAccess().getFeatureJvmIdentifiableElementCrossReference_0_0()) {
                JvmOperation operation;
                this.highlightNode(node, "feature_ref", acceptor);
                Assignment semanticObject = (Assignment)node.getSemanticElement();
                if (!(semanticObject.getFeature() instanceof JvmOperation) || !DeprecationUtil.isDeprecated((JvmAnnotationTarget)(operation = (JvmOperation)semanticObject.getFeature()))) continue;
                this.highlightNode(node, "deprecated_element", acceptor);
                continue;
            }
            if (grammarElement != this.grammarAccess.getComponentAccess().getTypeJvmTypeCrossReference_1_0_0() && grammarElement != this.grammarAccess.getRootComponentAccess().getTypeJvmTypeCrossReference_1_0_0() || !((component = (Component)node.getSemanticElement()).getType() instanceof JvmAnnotationTarget) || !DeprecationUtil.isDeprecated((JvmAnnotationTarget)((JvmAnnotationTarget)component.getType()))) continue;
            this.highlightNode(node, "deprecated_element", acceptor);
        }
    }

    private void highlightNode(INode node, String id, IHighlightedPositionAcceptor acceptor) {
        if (node == null) {
            return;
        }
        if (node instanceof ILeafNode) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{id});
        } else {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                acceptor.addPosition(leaf.getOffset(), leaf.getLength(), new String[]{id});
            }
        }
    }
}

