/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.ResourceManagerImpl;
import org.eclipse.emf.cdo.client.protocol.AbstractDataRequest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.net4j.util.ImplementationError;

public class LoadObjectRequest
extends AbstractDataRequest {
    private long oid;

    public LoadObjectRequest(long oid) {
        this.oid = oid;
    }

    public short getSignalId() {
        return 6;
    }

    public void request() {
        if (this.isDebugEnabled()) {
            this.debug("Loading object " + this.getPackageManager().getOidEncoder().toString(this.oid));
        }
        this.transmitLong(this.oid);
    }

    public Object confirm() {
        long oid;
        EObject firstObject = null;
        while ((oid = this.receiveLong()) != 0L) {
            int oca = this.receiveInt();
            int classifierId = this.receiveInt();
            ResourceManager resourceManager = this.getResourceManager();
            resourceManager.stopRequestingObjects();
            EObject object = this.receiveObject(oid, oca, classifierId);
            resourceManager.startRequestingObjects();
            if (firstObject != null) continue;
            firstObject = object;
        }
        return firstObject;
    }

    protected EObject provideObject(EClass eClass, long oid, int oca) {
        EObject object = this.getProxyObject(oid);
        if (object == null) {
            throw new ImplementationError("A proxy should be available, when requesting object data!");
        }
        int rid = this.getPackageManager().getOidEncoder().getRID(oid);
        CDOResource cdoResource = this.getResourceManager().getResource(rid);
        ResourceManagerImpl.initPersistable(object, cdoResource, oid, oca);
        ((InternalEObject)object).eSetProxyURI(null);
        return object;
    }
}

