/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;

public class WorkflowComponentHelper {
    public static boolean isLegalFile(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return false;
        }
        return !f.isDirectory();
    }

    public static boolean isLegalDir(String dirname) {
        File f = new File(dirname);
        if (!f.exists()) {
            return false;
        }
        return !f.isFile();
    }

    public static boolean isLegalURL(String url) {
        if (url == null || url.trim().length() == 0) {
            return false;
        }
        try {
            URL u = new URL(url);
            u.openConnection();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isResource(String uri) {
        URL u;
        block4: {
            u = ResourceLoaderFactory.createResourceLoader().getResource(uri);
            if (u != null) break block4;
            return false;
        }
        try {
            u.openConnection();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isResource(String uri, String contextClassName) {
        URL u;
        block4: {
            if (!WorkflowComponentHelper.isLoadableClass(contextClassName)) {
                return false;
            }
            try {
                Class<?> context = Class.forName(contextClassName);
                u = context.getResource(uri);
                if (u != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        u.openConnection();
        return true;
    }

    public static boolean isParamSet(String param) {
        return param != null;
    }

    public static boolean isLoadableClass(String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

