/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.engine;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.search.core.engine.AbstractModelSearchQuery;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.emf.search.core.parameters.IModelSearchQueryParameters;
import org.eclipse.emf.search.core.results.AbstractModelSearchResultEntry;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.ecore.Activator;
import org.eclipse.emf.search.ecore.engine.EcoreMetaModelIntrospector;
import org.eclipse.emf.search.ecore.engine.EcoreSupportedElements;
import org.eclipse.emf.search.ecore.evaluators.EcoreTextualModelSearchQueryEvaluator;
import org.eclipse.emf.search.ecore.l10n.Messages;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionEnum;
import org.eclipse.emf.search.ecore.results.EcoreModelSearchResultEntry;
import org.eclipse.emf.search.ecore.utils.EcoreModelLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreModelSearchQuery
extends AbstractModelSearchQuery {
    public static final String ECORE_MODEL_SEARCH_IMAGE_PATH = "icons/ecore.gif";
    public static final String ECORE_MODEL_SEARCH_RESULT_IMAGE_PATH = "icons/esearch.gif";
    public static final String CASE_SENSITIVE_SEARCH = "searchCaseSensitive";
    public static final String REGEX_SEARCH = "searchRegularExpression";
    public static final String NORMAL_SEARCH = "searchTextual";

    public ModelSearchQueryTextualExpressionEnum getKind() {
        if (this.getModelSearchParameters() != null) {
            boolean regexSearch;
            Object o1 = this.getModelSearchParameters().getData(CASE_SENSITIVE_SEARCH);
            boolean caseSensitiveSearch = o1 instanceof Boolean ? (Boolean)o1 : false;
            Object o2 = this.getModelSearchParameters().getData(REGEX_SEARCH);
            boolean bl = regexSearch = o2 instanceof Boolean ? (Boolean)o2 : false;
            if (caseSensitiveSearch) {
                return ModelSearchQueryTextualExpressionEnum.CASE_SENSITIVE;
            }
            if (regexSearch) {
                return ModelSearchQueryTextualExpressionEnum.REGULAR_EXPRESSION;
            }
        }
        return ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT;
    }

    public EcoreModelSearchQuery(String expr, IModelSearchQueryParameters parameters) {
        super(expr, parameters);
    }

    public IStatus search(Object resource, boolean notify, IProgressMonitor monitor) {
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            EObject root = EcoreModelLoaderUtil.openFile(resource, false);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.validParticipantMetaElements = EcoreMetaModelIntrospector.discriminateValidMetaElements(root, EcoreSupportedElements.getSupportedElements(this.participantElements));
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.getEvaluator().eval((Object)this, resource, notify);
            monitor.setTaskName(this.getLabel());
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus search(Object resource, boolean notify) {
        try {
            EObject root = EcoreModelLoaderUtil.openFile(resource, false);
            this.validParticipantMetaElements = EcoreMetaModelIntrospector.discriminateValidMetaElements(root, EcoreSupportedElements.getSupportedElements(this.participantElements));
            this.getEvaluator().eval((Object)this, resource, notify);
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus search(Object resource) {
        this.search(resource, false);
        return Status.OK_STATUS;
    }

    public String getResultImagePath() {
        return ECORE_MODEL_SEARCH_RESULT_IMAGE_PATH;
    }

    public String getBundleSymbolicName() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public String getQueryImagePath() {
        return ECORE_MODEL_SEARCH_IMAGE_PATH;
    }

    public Collection<String> getTargetMetaModelIDs() {
        return Arrays.asList("http://www.eclipse.org/emf/2002/Ecore");
    }

    public Collection<?> getValidParticipantMetaElements() {
        return super.getValidParticipantMetaElements();
    }

    public String getName() {
        if (this.getEvaluator() != null) {
            switch (this.getKind()) {
                case NORMAL_TEXT: {
                    return Messages.getString("EcoreModelSearchQuery.EcoreNormalTextMessage");
                }
                case CASE_SENSITIVE: {
                    return Messages.getString("EcoreModelSearchQuery.EcoreCaseSensitiveMessage");
                }
                case REGULAR_EXPRESSION: {
                    return Messages.getString("EcoreModelSearchQuery.EcoreRegularExpressionMessage");
                }
            }
            return "";
        }
        return Messages.getString("EcoreModelSearchQuery.EcoreMessage");
    }

    protected AbstractModelSearchResultEntry buildSearchResultEntryHierarchy(Object resource, AbstractModelSearchResultEntry intermediate, Object container) {
        if (container instanceof EObject) {
            EcoreModelSearchResultEntry entryContainer = new EcoreModelSearchResultEntry(null, resource, container, false);
            entryContainer.addChildren((IModelResultEntry)intermediate);
            intermediate.setParent((IModelResultEntry)entryContainer);
            return this.buildSearchResultEntryHierarchy(resource, entryContainer, ((EObject)container).eContainer());
        }
        return intermediate;
    }

    public IModelResultEntry buildSearchResultEntryHierarchy(Object resource, Object o) {
        EcoreModelSearchResultEntry e = new EcoreModelSearchResultEntry(null, resource, o, true);
        if (o instanceof EObject) {
            EObject c = (EObject)o;
            AbstractModelSearchResultEntry resultHierarchy = this.buildSearchResultEntryHierarchy(resource, e, c.eContainer());
            return resultHierarchy;
        }
        return e;
    }

    public IModelSearchQueryEvaluator<IModelSearchQuery, ?> getEvaluator() {
        this.evaluator = this.getModelSearchParameters().getEvaluator();
        return this.evaluator != null ? this.evaluator : (this.evaluator = new EcoreTextualModelSearchQueryEvaluator());
    }

    protected IModelSearchScope<?, ?> getModelSearchScope() {
        return this.getModelSearchParameters().getScope();
    }

    protected boolean getMatchesNotificationMode() {
        return true;
    }

    public String getLabel() {
        String scopeLabel = this.getModelSearchScope().getLabel();
        String queryName = this.getName();
        String queryLabel = Messages.getString("EcoreTextualModelSearchQueryEvaluator.Label");
        int matches = this.getModelSearchResult().getTotalMatches();
        String matchesLabel = String.valueOf(Messages.getString("EcoreModelSearchQuery.matchesMessage2")) + (matches > 1 ? Messages.getString("EcoreModelSearchQuery.matchesMessage3") : "");
        return String.valueOf(scopeLabel) + " " + queryName + " " + queryLabel + " : '" + this.getQueryExpression() + "' (" + matches + " " + matchesLabel + ")";
    }
}

