/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import org.eclipse.net4j.core.Task;
import org.eclipse.net4j.core.TaskListener;
import org.eclipse.net4j.core.impl.AbstractExecutor;
import org.eclipse.net4j.util.thread.Worker;

public class BlockingExecutorImpl
extends AbstractExecutor {
    private transient WorkerThread workerThread;
    private transient TaskListener listener;

    protected void activate() throws Exception {
        super.activate();
        this.workerThread = new WorkerThread();
        this.workerThread.startup();
    }

    protected void deactivate() throws Exception {
        this.workerThread.shutdown(200L);
        this.workerThread = null;
        this.listener = null;
        super.deactivate();
    }

    protected void doExecute(Task task, TaskListener listener) {
        this.listener = listener;
        if (this.workerThread != null) {
            this.workerThread.setTask(task);
        }
    }

    protected class WorkerThread
    extends Worker {
        protected Task task;

        public WorkerThread() {
            super(String.valueOf(BlockingExecutorImpl.this.getFullBeanName()) + ".Worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long doWorkStep(int progress) {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                try {
                    while (this.task == null) {
                        this.doWait((Object)this);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return -1L;
                }
                this.tryExecute();
            }
            return 0L;
        }

        private void tryExecute() {
            if (this.task != null) {
                try {
                    this.task.execute();
                    if (BlockingExecutorImpl.this.listener != null) {
                        BlockingExecutorImpl.this.listener.notifyFinished(this.task);
                    }
                }
                catch (Exception ex) {
                    BlockingExecutorImpl.this.error("Error while executing task " + this.task, ex);
                }
                this.task = null;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTask(Task newTask) {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                while (this.task != null) {
                    try {
                        this.task.wait();
                    }
                    catch (InterruptedException ex) {
                        BlockingExecutorImpl.this.error("Error while waiting for task " + this.task, ex);
                        return;
                    }
                }
                this.task = newTask;
                ((Object)((Object)this)).notifyAll();
            }
            if (BlockingExecutorImpl.this.isDebugEnabled()) {
                BlockingExecutorImpl.this.debug("Set task = " + newTask);
            }
        }
    }
}

