/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.swt;

import java.util.ArrayList;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IBinding;
import org.eclipse.net4j.examples.mvc.adapter.AbstractAdapter;
import org.eclipse.net4j.examples.mvc.aspect.IEnablementViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IFocusViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseButtonViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseMovementViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseTrackingViewAspect;
import org.eclipse.net4j.examples.mvc.util.Point;
import org.eclipse.net4j.examples.mvc.util.Rectangle;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlAdapter
extends AbstractAdapter<Control>
implements IFocusViewAspect,
IEnablementViewAspect,
IMouseButtonViewAspect,
IMouseMovementViewAspect,
IMouseTrackingViewAspect,
FocusListener,
MouseListener,
MouseTrackListener,
MouseMoveListener {
    public AbstractControlAdapter(IAdapter.Factory<Control> factory) {
        super(factory);
    }

    public Object[] getMetaDataKeys() {
        try {
            Object[] data = (Object[])((Control)this.getTarget()).getData();
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < data.length / 2) {
                Object key = data[2 * i];
                if (key instanceof String && ((Control)this.getTarget()).getData((String)key) != null) {
                    result.add(key);
                }
                ++i;
            }
            return result.toArray(new Object[result.size()]);
        }
        catch (Exception exception) {
            return new Object[0];
        }
    }

    public Object getMetaData(Object key) {
        return ((Control)this.getTarget()).getData((String)key);
    }

    public void setFocus() {
        ((Control)this.getTarget()).setFocus();
    }

    public boolean hasFocus() {
        return ((Control)this.getTarget()).isFocusControl();
    }

    public void onFocusLost() {
        for (IBinding binding : this.getBindings(IFocusViewAspect.class)) {
            ((IFocusViewAspect)binding).onFocusLost();
        }
    }

    public void onFocusGained() {
        for (IBinding binding : this.getBindings(IFocusViewAspect.class)) {
            ((IFocusViewAspect)binding).onFocusGained();
        }
    }

    public void setEnabled(boolean on) {
        boolean wasOn = this.isEnabled();
        ((Control)this.getTarget()).setEnabled(on);
        if (on && !wasOn) {
            this.onEnabled();
        } else if (!on && wasOn) {
            this.onDisabled();
        }
    }

    public boolean isEnabled() {
        return ((Control)this.getTarget()).isEnabled();
    }

    public void onEnabled() {
        for (IBinding binding : this.getBindings(IEnablementViewAspect.class)) {
            if (binding == this) continue;
            ((IEnablementViewAspect)binding).onEnabled();
        }
    }

    public void onDisabled() {
        for (IBinding binding : this.getBindings(IEnablementViewAspect.class)) {
            if (binding == this) continue;
            ((IEnablementViewAspect)binding).onDisabled();
        }
    }

    public void onMouseDoubleClick(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseButtonViewAspect.class)) {
            ((IMouseButtonViewAspect)binding).onMouseDoubleClick(button, stateMask, x, y);
        }
    }

    public void onMouseDown(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseButtonViewAspect.class)) {
            ((IMouseButtonViewAspect)binding).onMouseDown(button, stateMask, x, y);
        }
    }

    public void onMouseUp(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseButtonViewAspect.class)) {
            ((IMouseButtonViewAspect)binding).onMouseUp(button, stateMask, x, y);
        }
    }

    public void onMouseMove(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseMovementViewAspect.class)) {
            ((IMouseMovementViewAspect)binding).onMouseMove(button, stateMask, x, y);
        }
    }

    public void onMouseEnter(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseTrackingViewAspect.class)) {
            ((IMouseTrackingViewAspect)binding).onMouseHover(button, stateMask, x, y);
        }
    }

    public void onMouseExit(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseTrackingViewAspect.class)) {
            ((IMouseTrackingViewAspect)binding).onMouseHover(button, stateMask, x, y);
        }
    }

    public void onMouseHover(int button, int stateMask, int x, int y) {
        for (IBinding binding : this.getBindings(IMouseTrackingViewAspect.class)) {
            ((IMouseTrackingViewAspect)binding).onMouseHover(button, stateMask, x, y);
        }
    }

    public void focusGained(FocusEvent e) {
        this.onFocusGained();
    }

    public void focusLost(FocusEvent e) {
        this.onFocusLost();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.onMouseDoubleClick(e.button, e.stateMask, e.x, e.y);
    }

    public void mouseDown(MouseEvent e) {
        this.onMouseDown(e.button, e.stateMask, e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        this.onMouseUp(e.button, e.stateMask, e.x, e.y);
    }

    public void mouseEnter(MouseEvent e) {
        this.onMouseEnter(e.button, e.stateMask, e.x, e.y);
    }

    public void mouseExit(MouseEvent e) {
        this.onMouseExit(e.button, e.stateMask, e.x, e.y);
    }

    public void mouseHover(MouseEvent e) {
        this.onMouseHover(e.button, e.stateMask, e.x, e.y);
    }

    public void mouseMove(MouseEvent e) {
        this.onMouseMove(e.button, e.stateMask, e.x, e.y);
    }

    public static org.eclipse.swt.graphics.Point toSwt(Point point) {
        return new org.eclipse.swt.graphics.Point(point.x, point.y);
    }

    public static org.eclipse.swt.graphics.Rectangle toSwt(Rectangle rect) {
        return new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public static Point fromSwt(org.eclipse.swt.graphics.Point point) {
        return new Point(point.x, point.y);
    }

    public static Rectangle fromSwt(org.eclipse.swt.graphics.Rectangle rect) {
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    protected void connectTarget(Class viewAspect) {
        if (viewAspect == IFocusViewAspect.class) {
            ((Control)this.getTarget()).addFocusListener((FocusListener)this);
        } else if (viewAspect == IMouseButtonViewAspect.class) {
            ((Control)this.getTarget()).addMouseListener((MouseListener)this);
        } else if (viewAspect == IMouseMovementViewAspect.class) {
            ((Control)this.getTarget()).addMouseMoveListener((MouseMoveListener)this);
        } else if (viewAspect == IMouseTrackingViewAspect.class) {
            ((Control)this.getTarget()).addMouseTrackListener((MouseTrackListener)this);
        }
    }

    protected void disconnectTarget(Class viewAspect) {
        if (!((Control)this.getTarget()).isDisposed()) {
            if (viewAspect == IFocusViewAspect.class) {
                ((Control)this.getTarget()).removeFocusListener((FocusListener)this);
            } else if (viewAspect == IMouseButtonViewAspect.class) {
                ((Control)this.getTarget()).removeMouseListener((MouseListener)this);
            } else if (viewAspect == IMouseMovementViewAspect.class) {
                ((Control)this.getTarget()).removeMouseMoveListener((MouseMoveListener)this);
            } else if (viewAspect == IMouseTrackingViewAspect.class) {
                ((Control)this.getTarget()).removeMouseTrackListener((MouseTrackListener)this);
            }
        }
    }
}

