/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.IOHelper;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.thread.Worker;

public class FileSystemSilencer {
    private File fileToFinish;
    private long lastModification;
    private Map<File, FolderInfo> folders = new HashMap<File, FolderInfo>();
    private Set<File> newFiles = new HashSet<File>();
    private Set<File> silentFiles = new HashSet<File>();
    private Worker folderWorker = new FolderWorker();
    private Worker fileWorker = new FileWorker();

    public FileSystemSilencer(File fileToFinish) {
        this.fileToFinish = fileToFinish;
        this.touch();
    }

    public static void waitForSilence(File fileToFinish) {
        FileSystemSilencer silencer = new FileSystemSilencer(fileToFinish);
        silencer.waitForSilence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSilence() {
        if (this.fileToFinish.isFile()) {
            Set<File> set = this.newFiles;
            synchronized (set) {
                this.newFiles.add(this.fileToFinish);
            }
        }
        Map<File, FolderInfo> map = this.folders;
        synchronized (map) {
            this.folders.put(this.fileToFinish, new FolderInfo());
        }
        this.folderWorker.startup();
        this.fileWorker.startup();
        try {
            this.folderWorker.join();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.fileWorker.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private void touch() {
        this.lastModification = System.currentTimeMillis();
    }

    private static class FolderInfo {
        private int memberCount;

        private FolderInfo() {
        }

        public int getMemberCount() {
            return this.memberCount;
        }

        public void setMemberCount(int memberCount) {
            this.memberCount = memberCount;
        }
    }

    private class FolderWorker
    extends Worker {
        private Map.Entry<File, FolderInfo>[] folderEntries;
        private int currentIndex;

        public FolderWorker() {
            super("FileSystemSilencer.FolderWorker");
            this.folderEntries = new Map.Entry[0];
            this.currentIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long doWorkStep(int progress) {
            if (this.currentIndex < this.folderEntries.length) {
                File folder = this.folderEntries[this.currentIndex].getKey();
                FolderInfo folderInfo = this.folderEntries[this.currentIndex].getValue();
                File[] members = folder.listFiles();
                if (members.length > folderInfo.getMemberCount()) {
                    folderInfo.setMemberCount(members.length);
                    this.handleMembers(members);
                    FileSystemSilencer.this.touch();
                }
                ++this.currentIndex;
                return 0L;
            }
            long pause = System.currentTimeMillis() - FileSystemSilencer.this.lastModification;
            if (pause > 1000L && FileSystemSilencer.this.newFiles.isEmpty()) {
                return -1L;
            }
            Map map = FileSystemSilencer.this.folders;
            synchronized (map) {
                this.folderEntries = FileSystemSilencer.this.folders.entrySet().toArray(new Map.Entry[FileSystemSilencer.this.folders.size()]);
                this.currentIndex = 0;
            }
            return 10L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMembers(File[] members) {
            int i = 0;
            while (i < members.length) {
                block16: {
                    Object object;
                    File member = members[i];
                    if (member.isFile()) {
                        object = FileSystemSilencer.this.silentFiles;
                        synchronized (object) {
                            if (FileSystemSilencer.this.silentFiles.contains(member)) {
                                break block16;
                            }
                        }
                        object = FileSystemSilencer.this.newFiles;
                        synchronized (object) {
                            if (!FileSystemSilencer.this.newFiles.contains(member)) {
                                FileSystemSilencer.this.newFiles.add(member);
                            }
                        }
                    }
                    if (member.isDirectory()) {
                        object = FileSystemSilencer.this.folders;
                        synchronized (object) {
                            FolderInfo folderInfo = (FolderInfo)FileSystemSilencer.this.folders.get(member);
                            if (folderInfo == null) {
                                folderInfo = new FolderInfo();
                                FileSystemSilencer.this.folders.put(member, folderInfo);
                            }
                        }
                    } else {
                        throw new ImplementationError("Member is neither file nor directory: " + member);
                    }
                }
                ++i;
            }
        }
    }

    private class FileWorker
    extends Worker {
        private File[] files;
        private int currentIndex;

        public FileWorker() {
            super("FileSystemSilencer.FileWorker");
            this.files = new File[0];
            this.currentIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long doWorkStep(int progress) {
            if (this.currentIndex < this.files.length) {
                File file = this.files[this.currentIndex];
                if (this.isSilent(file)) {
                    Set set = FileSystemSilencer.this.newFiles;
                    synchronized (set) {
                        FileSystemSilencer.this.newFiles.remove(file);
                    }
                    set = FileSystemSilencer.this.silentFiles;
                    synchronized (set) {
                        FileSystemSilencer.this.silentFiles.add(file);
                    }
                }
                FileSystemSilencer.this.touch();
                ++this.currentIndex;
            } else {
                Set set = FileSystemSilencer.this.newFiles;
                synchronized (set) {
                    block13: {
                        long pause = System.currentTimeMillis() - FileSystemSilencer.this.lastModification;
                        if (pause <= 1000L || !FileSystemSilencer.this.newFiles.isEmpty()) break block13;
                        return -1L;
                    }
                    this.files = FileSystemSilencer.this.newFiles.toArray(new File[FileSystemSilencer.this.newFiles.size()]);
                    this.currentIndex = 0;
                }
            }
            return 10L;
        }

        private boolean isSilent(File file) {
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(file, true);
                }
                catch (Exception exception) {
                    IOHelper.close(os);
                    return false;
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(os);
                throw throwable;
            }
            IOHelper.close((OutputStream)os);
            return true;
        }
    }
}

