/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.ui.Plugin;

public class StaleGenModelDetector {
    private final GenModel myGenModel;

    public StaleGenModelDetector(GenModel genModel) {
        if (genModel == null) {
            throw new IllegalArgumentException("Could not detect with null GenModel");
        }
        this.myGenModel = genModel;
    }

    public IStatus detect() {
        if (this.myGenModel.eResource() == null) {
            return Status.OK_STATUS;
        }
        URI genModelURI = this.myGenModel.eResource().getURI();
        if (!StaleGenModelDetector.isFileURI(genModelURI)) {
            return Status.OK_STATUS;
        }
        HashSet<URI> ecoreURIs = new HashSet<URI>();
        for (GenPackage next : this.myGenModel.getAllGenAndUsedGenPackagesWithClassifiers()) {
            URI uri;
            if (next.getEcorePackage().eResource() == null || !StaleGenModelDetector.isFileURI(uri = next.getEcorePackage().eResource().getURI())) continue;
            ecoreURIs.add(uri);
        }
        Date genModelTimeStamp = StaleGenModelDetector.timestamp(genModelURI);
        for (URI uri : ecoreURIs) {
            Date ts = StaleGenModelDetector.timestamp(uri);
            if (!new Date(genModelTimeStamp.getTime() + 3000L).before(ts)) continue;
            String format = Messages.StaleGenModelDetector_stale;
            String msg = MessageFormat.format(format, uri, ts, genModelTimeStamp);
            return Plugin.createWarning(msg);
        }
        return Status.OK_STATUS;
    }

    private static boolean isFileURI(URI uri) {
        return "platform".equals(uri.scheme()) && "resource".equals(uri.segment(0));
    }

    private static Date timestamp(URI uri) {
        IFile f = StaleGenModelDetector.getFile(uri);
        if (!f.exists()) {
            return new Date(0L);
        }
        return new Date(f.getLocalTimeStamp());
    }

    private static IFile getFile(URI platformFileUri) {
        IPath p = new Path(platformFileUri.path()).removeFirstSegments(1);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(p);
    }
}

