/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.List;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphDefLookup {
    private final Canvas myCanvas;

    public GraphDefLookup(Canvas canvas) {
        this.myCanvas = canvas;
    }

    public Node findSuitableNode(NodeMapping nm) {
        String name = nm.getDomainMetaElement() == null ? null : nm.getDomainMetaElement().getName();
        return (Node)this.doSearch((List<? extends DiagramElement>)this.myCanvas.getNodes(), name);
    }

    public Connection findSuitableLink(LinkMapping lm) {
        String name = null;
        if (lm.getDomainMetaElement() != null) {
            name = lm.getDomainMetaElement().getName();
        } else if (lm.getLinkMetaFeature() != null) {
            name = lm.getLinkMetaFeature().getEContainingClass().getName();
        }
        return (Connection)this.doSearch((List<? extends DiagramElement>)this.myCanvas.getConnections(), name);
    }

    private DiagramElement doSearch(List<? extends DiagramElement> elements, String namePart) {
        DiagramElement c;
        if (elements.isEmpty()) {
            return null;
        }
        if (namePart != null && (c = this.matchName(elements, namePart)) != null) {
            return c;
        }
        return elements.get(0);
    }

    private DiagramElement matchName(List<? extends DiagramElement> elements, String namePart) {
        for (DiagramElement diagramElement : elements) {
            if (diagramElement.getName() == null || diagramElement.getName().indexOf(namePart) < 0) continue;
            return diagramElement;
        }
        return null;
    }
}

