/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.internal.common.migrate.Messages;
import org.eclipse.gmf.internal.common.migrate.MigrationDelegate;
import org.eclipse.gmf.internal.common.migrate.MigrationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MigrationResource
extends ToolingResourceFactory.ToolResource {
    private MigrationHelper myMigrationHelper;

    protected MigrationResource(URI uri) {
        super(uri);
    }

    public final void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            super.doLoad(inputStream, options);
            this.handlePostLoadSuccess();
        }
        catch (IOException e) {
            this.handlePostLoadException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handlePostLoadException(e);
            throw e;
        }
    }

    protected void handlePostLoadSuccess() {
        if (this.myMigrationHelper != null && this.myMigrationHelper.isMigrationApplied()) {
            Diagnostic diagnostic = MigrationResource.createMessageDiagnostic((Resource)this, Messages.oldModelVersionLoadedMigrationRequired);
            this.getWarnings().add(0, (Object)diagnostic);
        }
    }

    protected void handlePostLoadException(Exception e) {
        if (this.myMigrationHelper != null && this.myMigrationHelper.isMigrationApplied()) {
            Diagnostic diagnostic = MigrationResource.createMessageDiagnostic((Resource)this, Messages.oldModelVersionLoadErrorMigrationMayBeRequired);
            this.getErrors().add(0, (Object)diagnostic);
        }
    }

    protected XMLHelper createXMLHelper() {
        MigrationDelegate delegate = this.createDelegate();
        assert (delegate != null);
        this.myMigrationHelper = new MigrationHelper((XMLResource)this, delegate);
        return this.myMigrationHelper;
    }

    protected abstract MigrationDelegate createDelegate();

    private static Diagnostic createMessageDiagnostic(Resource resource, String message) {
        String location = resource.getURI() == null ? null : resource.getURI().toString();
        return new Diagnostic(message, location);
    }

    public static class Diagnostic
    implements Resource.Diagnostic {
        private final String myMessage;
        private final String myLocation;

        Diagnostic(String message, String location) {
            this.myMessage = message;
            this.myLocation = location;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public String getLocation() {
            return this.myLocation;
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }
    }
}

