/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.ecore.part.EcoreDiagramUpdater;
import org.eclipse.gmf.ecore.part.EcoreLinkDescriptor;
import org.eclipse.gmf.ecore.part.EcoreNodeDescriptor;
import org.eclipse.gmf.ecore.part.EcoreVisualIDRegistry;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class EPackageCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    Set myFeaturesToSynchronize;

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = EcoreDiagramUpdater.getEPackage_1000SemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((EcoreNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        EcoreDiagramUpdater.isShortcutOrphaned(view);
        int visualID = EcoreVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return !semanticChildren.contains(view.getElement()) || visualID != EcoreVisualIDRegistry.getNodeVisualID((View)this.getHost().getModel(), view.getElement());
            }
        }
        return false;
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet();
            this.myFeaturesToSynchronize.add(EcorePackage.eINSTANCE.getEPackage_EClassifiers());
            this.myFeaturesToSynchronize.add(EcorePackage.eINSTANCE.getEPackage_ESubpackages());
            this.myFeaturesToSynchronize.add(EcorePackage.eINSTANCE.getEModelElement_EAnnotations());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection refreshConnections() {
        HashMap domain2NotationMap = new HashMap();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            int diagramLinkVisualID = EcoreVisualIDRegistry.getVisualID((View)nextDiagramLink);
            Iterator LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                EcoreLinkDescriptor nextLinkDescriptor = (EcoreLinkDescriptor)LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                LinkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Map domain2NotationMap) {
        LinkedList result = new LinkedList();
        switch (EcoreVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEClass_2001ContainedLinks(view));
                break;
            }
            case 2002: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEPackage_2002ContainedLinks(view));
                break;
            }
            case 2003: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEAnnotation_2003ContainedLinks(view));
                break;
            }
            case 2004: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEDataType_2004ContainedLinks(view));
                break;
            }
            case 2005: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEEnum_2005ContainedLinks(view));
                break;
            }
            case 3001: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEAttribute_3001ContainedLinks(view));
                break;
            }
            case 3002: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEOperation_3002ContainedLinks(view));
                break;
            }
            case 3003: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEAnnotation_3003ContainedLinks(view));
                break;
            }
            case 3004: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEClass_3004ContainedLinks(view));
                break;
            }
            case 3005: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEPackage_3005ContainedLinks(view));
                break;
            }
            case 3006: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEDataType_3006ContainedLinks(view));
                break;
            }
            case 3007: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEEnum_3007ContainedLinks(view));
                break;
            }
            case 3008: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEStringToStringMapEntry_3008ContainedLinks(view));
                break;
            }
            case 3009: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEEnumLiteral_3009ContainedLinks(view));
                break;
            }
            case 4002: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEReference_4002ContainedLinks(view));
                break;
            }
            case 4003: {
                domain2NotationMap.put(view.getElement(), view);
                result.addAll(EcoreDiagramUpdater.getEReference_4003ContainedLinks(view));
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Map domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (EcoreLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map domain2NotationMap) {
        View view = (View)domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }
}

