/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.List;
import java.util.Stack;
import junit.framework.TestCase;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.codeassist.FastAnalyzer;
import org.eclipse.gmf.internal.xpand.codeassist.LazyVar;
import org.eclipse.gmf.internal.xpand.codeassist.StackElement;
import org.eclipse.gmf.internal.xpand.editor.Activator;

public class FastAnalyzerTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        if (Activator.getDefault() == null) {
            new Activator();
        }
    }

    public final void testComputeStack1() {
        String txt = String.valueOf(this.tag("DEFINE test(String txt) FOR Entity")) + this.tag("FOREACH txt.list AS c") + this.tag("doStuff");
        Stack s = FastAnalyzer.computeStack((String)txt);
        FastAnalyzerTest.assertEquals((int)2, (int)s.size());
        StackElement se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"FOREACH", (String)se.block);
        LazyVar v = (LazyVar)se.variables.get("c");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"txt.list", (String)v.expression);
        FastAnalyzerTest.assertEquals((String)"c", (String)v.name);
        se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"DEFINE", (String)se.block);
        v = (LazyVar)se.variables.get("txt");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"String", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"txt", (String)v.name);
        v = (LazyVar)se.variables.get("this");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"Entity", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"this", (String)v.name);
    }

    public final void testComputeStackWithIterator() {
        String txt = String.valueOf(this.tag("DEFINE test(String txt) FOR Entity")) + this.tag("FOREACH txt.list AS c ITERATOR i") + this.tag("doStuff");
        Stack s = FastAnalyzer.computeStack((String)txt);
        FastAnalyzerTest.assertEquals((int)2, (int)s.size());
        StackElement se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"FOREACH", (String)se.block);
        LazyVar v = (LazyVar)se.variables.get("c");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"txt.list", (String)v.expression);
        FastAnalyzerTest.assertEquals((String)"c", (String)v.name);
        v = (LazyVar)se.variables.get("i");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"xpand2::Iterator", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"i", (String)v.name);
        se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"DEFINE", (String)se.block);
        v = (LazyVar)se.variables.get("txt");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"String", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"txt", (String)v.name);
        v = (LazyVar)se.variables.get("this");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"Entity", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"this", (String)v.name);
    }

    public final void testComputeStack11() {
        String txt = String.valueOf(this.tag("AROUND *test* (String txt) FOR Entity")) + this.tag("FOREACH txt.list AS c") + this.tag("doStuff");
        Stack s = FastAnalyzer.computeStack((String)txt);
        FastAnalyzerTest.assertEquals((int)2, (int)s.size());
        StackElement se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"FOREACH", (String)se.block);
        LazyVar v = (LazyVar)se.variables.get("c");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"txt.list", (String)v.expression);
        FastAnalyzerTest.assertEquals((String)"c", (String)v.name);
        se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"AROUND", (String)se.block);
        v = (LazyVar)se.variables.get("txt");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"String", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"txt", (String)v.name);
        v = (LazyVar)se.variables.get("this");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"Entity", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"this", (String)v.name);
    }

    public final void testComputeStack12() {
        String txt = String.valueOf(this.tag("AROUND *features(*) FOR ecore::EStructuralFeature ")) + this.tag("\nlogWarn(targetDef.name+\" FOR \"+targetDef.targetType) ") + this.tag("\ntarg") + this.tag("doStuff");
        Stack s = FastAnalyzer.computeStack((String)txt);
        FastAnalyzerTest.assertEquals((int)1, (int)s.size());
        StackElement se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"AROUND", (String)se.block);
        LazyVar v = (LazyVar)se.variables.get("this");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"ecore::EStructuralFeature", (String)v.typeName);
        v = (LazyVar)se.variables.get("targetDef");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)BuiltinMetaModel.DEFINITION_TYPE.getName(), (String)v.typeName);
    }

    public String tag(String txt) {
        return "\u00ab" + txt + "\u00bb";
    }

    public final void testComputeStack2() {
        String txt = String.valueOf(this.tag("DEFINE test(String txt, List[oaw::Type] typeList) FOR Entity")) + this.tag("FOREACH txt.list AS c") + this.tag("c.stuff") + this.tag("ENDFOREACH") + this.tag("LET stuff(txt+'holla') AS stuff") + this.tag("stuff.bla");
        Stack s = FastAnalyzer.computeStack((String)txt);
        FastAnalyzerTest.assertEquals((int)2, (int)s.size());
        StackElement se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"LET", (String)se.block);
        LazyVar v = (LazyVar)se.variables.get("stuff");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"stuff(txt+'holla')", (String)v.expression);
        FastAnalyzerTest.assertEquals((String)"stuff", (String)v.name);
        se = (StackElement)s.pop();
        FastAnalyzerTest.assertEquals((String)"DEFINE", (String)se.block);
        v = (LazyVar)se.variables.get("txt");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"String", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"txt", (String)v.name);
        v = (LazyVar)se.variables.get("typeList");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"List[oaw::Type]", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"typeList", (String)v.name);
        v = (LazyVar)se.variables.get("this");
        FastAnalyzerTest.assertNotNull((Object)v);
        FastAnalyzerTest.assertEquals((String)"Entity", (String)v.typeName);
        FastAnalyzerTest.assertEquals((String)"this", (String)v.name);
    }

    public final void testIsInTag() {
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTag((String)"test"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTag((String)"\u00bbtest"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTag((String)"\u00abtest\u00bb"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTag((String)"\u00abtest"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTag((String)"\u00abtest\u00bbtest\u00ab"));
    }

    public final void testIsInImport() {
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInImport((String)"\u00bbIMPORT"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInImport((String)"\u00abIMPORT \u00bb"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInImport((String)"IMPORT"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInImport((String)"\u00abIMPORT "));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInImport((String)"\u00abIMPORT org::oaw::"));
    }

    public final void testIsInExtensionImport() {
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInExtensionImport((String)"\u00bbEXTENSION"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInExtensionImport((String)"\u00abEXTENSION \u00bb"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInExtensionImport((String)"EXTENSION"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInExtensionImport((String)"\u00abEXTENSION "));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInExtensionImport((String)"\u00abEXTENSION org::oaw::"));
    }

    public final void testFindImports() {
        List imports = FastAnalyzer.findImports((String)(String.valueOf(this.tag("IMPORT 'a1'")) + this.tag("IMPORT 'a::b::c::d::x'")));
        FastAnalyzerTest.assertEquals((String)"a1", (String)((String)imports.get(0)));
        FastAnalyzerTest.assertEquals((String)"a::b::c::d::x", (String)((String)imports.get(1)));
        FastAnalyzerTest.assertEquals((int)2, (int)imports.size());
    }

    public final void testFindExetnsionImports() {
        List imports = FastAnalyzer.findExtensions((String)(String.valueOf(this.tag("EXTENSION a1")) + this.tag("EXTENSION a::b::c::d::x")));
        FastAnalyzerTest.assertEquals((String)"a1", (String)((String)imports.get(0)));
        FastAnalyzerTest.assertEquals((String)"a::b::c::d::x", (String)((String)imports.get(1)));
        FastAnalyzerTest.assertEquals((int)2, (int)imports.size());
    }

    public final void testIsInTypeDecl() {
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test("));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(Str"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s,"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s,oaw:"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s,String txt,"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s) FOR "));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s) FOR oaw"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String "));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s)"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s) FOR"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInTypeDecl((String)"\u00abDEFINE test(String s) FOR Test "));
    }

    public final void testIsInExpandStatement() {
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInExpand((String)"\u00abEXPAND test"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInExpand((String)"\u00abEXPAND test FOR"));
        FastAnalyzerTest.assertTrue((boolean)FastAnalyzer.isInExpand((String)"\u00abEXPAND test::Holla::test"));
        FastAnalyzerTest.assertFalse((boolean)FastAnalyzer.isInExpand((String)"\u00abEXPAND test::Test(s"));
    }
}

