/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.document;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.osgi.framework.Bundle;

public class DocumentProviderRegistry {
    private static DocumentProviderRegistry fgRegistry;
    public Map fExtensionMapping = new HashMap();
    public Map fInputTypeMapping = new HashMap();
    private Map fInstances = new HashMap();
    static /* synthetic */ Class class$0;

    public static DocumentProviderRegistry getDefault() {
        if (fgRegistry == null) {
            fgRegistry = new DocumentProviderRegistry();
        }
        return fgRegistry;
    }

    private DocumentProviderRegistry() {
        this.initialize();
    }

    private void read(Map map, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                HashSet<IConfigurationElement> s = (HashSet<IConfigurationElement>)map.get(token);
                if (s == null) {
                    s = new HashSet<IConfigurationElement>();
                    map.put(token, s);
                }
                s.add(element);
            }
        }
    }

    private void initialize() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EditorPlugin.getPluginId(), "documentProviders");
        if (extensionPoint == null) {
            String msg = NLS.bind((String)EditorMessages.DocumentProviderRegistry_error_extension_point_not_found, (Object)"org.eclipse.ui");
            Bundle bundle = Platform.getBundle((String)EditorPlugin.getPluginId());
            ILog log = Platform.getLog((Bundle)bundle);
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.read(this.fExtensionMapping, elements[i], "extensions");
            this.read(this.fInputTypeMapping, elements[i], "inputTypes");
            ++i;
        }
    }

    private IDocumentProvider getDocumentProvider(IConfigurationElement entry) {
        IDocumentProvider provider = (IDocumentProvider)this.fInstances.get(entry);
        if (provider == null) {
            try {
                provider = (IDocumentProvider)entry.createExecutableExtension("class");
                this.fInstances.put(entry, provider);
            }
            catch (CoreException coreException) {}
        }
        return provider;
    }

    private IConfigurationElement selectConfigurationElement(Collection set, IDocumentProviderSelector selector) {
        if (set != null && !set.isEmpty()) {
            Iterator e = set.iterator();
            while (e.hasNext()) {
                IConfigurationElement element = (IConfigurationElement)e.next();
                String docTypeClass = element.getAttribute("documentType");
                if (!selector.select(docTypeClass)) continue;
                return element;
            }
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider(String extension, IDocumentProviderSelector selector) {
        IConfigurationElement entry;
        Set set = (Set)this.fExtensionMapping.get(extension);
        if (set != null && (entry = this.selectConfigurationElement(set, selector)) != null) {
            return this.getDocumentProvider(entry);
        }
        return null;
    }

    private List computeClassList(Class type) {
        ArrayList result = new ArrayList();
        Class c = type;
        while (c != null) {
            result.add(c);
            c = c.getSuperclass();
        }
        return result;
    }

    private List computeInterfaceList(List classes) {
        ArrayList result = new ArrayList(4);
        Hashtable visited = new Hashtable(4);
        Iterator e = classes.iterator();
        while (e.hasNext()) {
            Class c = (Class)e.next();
            this.computeInterfaceList(c.getInterfaces(), result, visited);
        }
        return result;
    }

    private void computeInterfaceList(Class[] interfaces, List result, Hashtable visited) {
        Class iface;
        ArrayList<Class> toBeVisited = new ArrayList<Class>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            iface = interfaces[i];
            if (visited.get(iface) == null) {
                visited.put(iface, iface);
                result.add(iface);
                toBeVisited.add(iface);
            }
            ++i;
        }
        Iterator e = toBeVisited.iterator();
        while (e.hasNext()) {
            iface = (Class)e.next();
            this.computeInterfaceList(iface.getInterfaces(), result, visited);
        }
    }

    private Set getFirstInputTypeMapping(List classes) {
        Iterator e = classes.iterator();
        while (e.hasNext()) {
            Class c = (Class)e.next();
            Set mapping = (Set)this.fInputTypeMapping.get(c.getName());
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    private List getInputTypeMappings(List classes) {
        ArrayList mappings = new ArrayList();
        Iterator e = classes.iterator();
        while (e.hasNext()) {
            Class c = (Class)e.next();
            Set mapping = (Set)this.fInputTypeMapping.get(c.getName());
            if (mapping == null) continue;
            mappings.addAll(mapping);
        }
        return mappings;
    }

    protected Set findInputTypeMapping(Class type) {
        if (type == null) {
            return null;
        }
        Set mapping = (Set)this.fInputTypeMapping.get(type.getName());
        if (mapping != null) {
            return mapping;
        }
        List classList = this.computeClassList(type);
        mapping = this.getFirstInputTypeMapping(classList);
        if (mapping != null) {
            return mapping;
        }
        return this.getFirstInputTypeMapping(this.computeInterfaceList(classList));
    }

    private List findInputTypeMappings(Class type) {
        List classList;
        List clsMapping;
        ArrayList inputTypeMappings = new ArrayList();
        if (type == null) {
            return null;
        }
        Set mapping = (Set)this.fInputTypeMapping.get(type.getName());
        if (mapping != null) {
            inputTypeMappings.addAll(mapping);
        }
        if ((clsMapping = this.getInputTypeMappings(classList = this.computeClassList(type))) != null) {
            inputTypeMappings.addAll(clsMapping);
        }
        inputTypeMappings.addAll(this.getInputTypeMappings(this.computeInterfaceList(classList)));
        return inputTypeMappings;
    }

    public IDocumentProvider getDocumentProvider(IEditorInput editorInput, IDocumentProviderSelector selector) {
        IConfigurationElement entry;
        List inputTypeMappings;
        IFile file;
        IDocumentProvider provider = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)editorInput.getAdapter((Class)clazz)) != null) {
            provider = this.getDocumentProvider(file.getFileExtension(), selector);
        }
        if (provider == null && (inputTypeMappings = this.findInputTypeMappings(editorInput.getClass())) != null && (entry = this.selectConfigurationElement(inputTypeMappings, selector)) != null) {
            provider = this.getDocumentProvider(entry);
        }
        return provider;
    }

    public static interface IDocumentProviderSelector {
        public boolean select(String var1);
    }
}

