/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.gmf.codegen.gmfgen.StyleAttributes;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Direction;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.XYLayout;
import org.eclipse.gmf.gmfgraph.util.GMFGraphSwitch;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;

public class DefaultViewmapProducer
extends ViewmapProducer {
    private final LayoutTypeSwitch myLayoutTypeSwitch = new LayoutTypeSwitch();

    public Viewmap create(Canvas canvasElement) {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.draw2d.FreeformLayer");
        return v;
    }

    public Viewmap create(Node node) {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.draw2d.RoundedRectangle");
        return v;
    }

    public Viewmap create(Connection link) {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx");
        return v;
    }

    public Viewmap create(Compartment compartment) {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("XXX");
        return v;
    }

    public Viewmap create(DiagramLabel label) {
        FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
        v.setFigureQualifiedClassName("org.eclipse.draw2d.Label");
        return v;
    }

    protected final void setupResizeConstraints(Viewmap viewmap, Node diagramNode) {
        Direction direction = diagramNode.getResizeConstraint();
        if (direction == null || direction.getValue() == 29) {
            return;
        }
        ResizeConstraints constraints = GMFGenFactory.eINSTANCE.createResizeConstraints();
        constraints.setResizeHandles(direction.getValue());
        viewmap.getAttributes().add((Object)constraints);
    }

    protected final void setupLayoutType(Viewmap viewmap, Node diagramNode) {
        FigureHandle figure = diagramNode.getFigure();
        if (!(figure instanceof Layoutable)) {
            return;
        }
        ViewmapLayoutType type = this.myLayoutTypeSwitch.getLayoutType(((Layoutable)figure).getLayout());
        viewmap.setLayoutType(type);
    }

    protected final void setupStyleAttributes(Viewmap viewmap, FigureHandle handle) {
        if (viewmap == null || !(handle instanceof Figure)) {
            return;
        }
        Figure figure = (Figure)handle;
        StyleAttributes attributes = GMFGenFactory.eINSTANCE.createStyleAttributes();
        boolean fixedSomething = false;
        if (figure.getFont() != null) {
            attributes.setFixedFont(true);
            fixedSomething = true;
        }
        if (figure.getForegroundColor() != null) {
            attributes.setFixedForeground(true);
            fixedSomething = true;
        }
        if (figure.getBackgroundColor() != null) {
            attributes.setFixedBackground(true);
            fixedSomething = true;
        }
        if (fixedSomething) {
            viewmap.getAttributes().add((Object)attributes);
        }
    }

    private static class LayoutTypeSwitch
    extends GMFGraphSwitch {
        private LayoutTypeSwitch() {
        }

        public ViewmapLayoutType getLayoutType(Layout layout) {
            return layout == null ? ViewmapLayoutType.UNKNOWN_LITERAL : (ViewmapLayoutType)this.doSwitch((EObject)layout);
        }

        public Object caseLayout(Layout object) {
            return ViewmapLayoutType.UNKNOWN_LITERAL;
        }

        public Object caseFlowLayout(FlowLayout layout) {
            return layout.isForceSingleLine() ? ViewmapLayoutType.TOOLBAR_LAYOUT_LITERAL : ViewmapLayoutType.FLOW_LAYOUT_LITERAL;
        }

        public Object caseXYLayout(XYLayout object) {
            return ViewmapLayoutType.XY_LAYOUT_LITERAL;
        }
    }
}

