/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.ecore.expressions.EcoreAbstractExpression;
import org.eclipse.gmf.ecore.expressions.EcoreOCLFactory;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;

public class ElementInitializers {

    public static class Initializers {
        public static final IObjectInitializer EReference_4002 = new ObjectInitializer(EcorePackage.eINSTANCE.getEReference()){

            protected void init() {
                this.add(Initializers.createExpressionFeatureInitializer((EStructuralFeature)EcorePackage.eINSTANCE.getEReference_Containment(), EcoreOCLFactory.getExpression("false", (EClassifier)EcorePackage.eINSTANCE.getEReference())));
            }
        };
        public static final IObjectInitializer EReference_4003 = new ObjectInitializer(EcorePackage.eINSTANCE.getEReference()){

            protected void init() {
                this.add(Initializers.createExpressionFeatureInitializer((EStructuralFeature)EcorePackage.eINSTANCE.getEReference_Containment(), EcoreOCLFactory.getExpression("true", (EClassifier)EcorePackage.eINSTANCE.getEReference())));
            }
        };

        private Initializers() {
        }

        static IFeatureInitializer createNewElementFeatureInitializer(EStructuralFeature initFeature, ObjectInitializer[] newObjectInitializers) {
            final EStructuralFeature feature = initFeature;
            final ObjectInitializer[] initializers = newObjectInitializers;
            return new IFeatureInitializer(){

                public void init(EObject contextInstance) {
                    int i = 0;
                    while (i < initializers.length) {
                        EObject newInstance = initializers[i].element.getEPackage().getEFactoryInstance().create(initializers[i].element);
                        if (feature.isMany()) {
                            ((Collection)contextInstance.eGet(feature)).add(newInstance);
                        } else {
                            contextInstance.eSet(feature, (Object)newInstance);
                        }
                        initializers[i].init(newInstance);
                        ++i;
                    }
                }
            };
        }

        static IFeatureInitializer createExpressionFeatureInitializer(EStructuralFeature initFeature, EcoreAbstractExpression valueExpression) {
            final EStructuralFeature feature = initFeature;
            final EcoreAbstractExpression expression = valueExpression;
            return new IFeatureInitializer(){

                public void init(EObject contextInstance) {
                    expression.assignTo(feature, contextInstance);
                }
            };
        }

        static interface IFeatureInitializer {
            public void init(EObject var1);
        }

        public static interface IObjectInitializer {
            public void init(EObject var1);
        }

        static class Java {
            Java() {
            }
        }

        public static abstract class ObjectInitializer
        implements IObjectInitializer {
            final EClass element;
            private List featureInitializers = new ArrayList();

            ObjectInitializer(EClass element) {
                this.element = element;
                this.init();
            }

            protected abstract void init();

            protected final IFeatureInitializer add(IFeatureInitializer initializer) {
                this.featureInitializers.add(initializer);
                return initializer;
            }

            public void init(EObject instance) {
                for (IFeatureInitializer nextExpr : this.featureInitializers) {
                    try {
                        nextExpr.init(instance);
                    }
                    catch (RuntimeException e) {
                        EcoreDiagramEditorPlugin.getInstance().logError("Feature initialization failed", e);
                    }
                }
            }
        }
    }
}

