/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.clipboard;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics.GraphicsToGraphics2DAdaptor;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class DiagramImageGenerator
extends DiagramGenerator {
    private GC gc = null;
    private org.eclipse.swt.graphics.Image image = null;

    public DiagramImageGenerator(DiagramEditPart dgrmEP) {
        super(dgrmEP);
    }

    protected Graphics setUpGraphics(int width, int height) {
        Display display = Display.getDefault();
        this.image = new org.eclipse.swt.graphics.Image((Device)display, new org.eclipse.swt.graphics.Rectangle(0, 0, width, height));
        this.gc = new GC((Drawable)this.image);
        SWTGraphics swtG = new SWTGraphics(this.gc);
        return swtG;
    }

    protected void disposeGraphics(Graphics g) {
        super.disposeGraphics(g);
        this.image.dispose();
        if (this.gc != null) {
            this.gc.dispose();
        }
        this.gc = null;
    }

    protected ImageDescriptor getImageDescriptor(Graphics g) {
        return new ImageDescriptor(){
            ImageData imgData;
            {
                this.imgData = DiagramImageGenerator.this.image.getImageData();
            }

            public ImageData getImageData() {
                return this.imgData;
            }
        };
    }

    public Image createAWTImageForParts(List selectedObjects, org.eclipse.swt.graphics.Rectangle sourceRect) {
        BufferedImage awtImage = null;
        IMapMode mm = this.getMapMode();
        awtImage = new BufferedImage(mm.LPtoDP(sourceRect.width), mm.LPtoDP(sourceRect.height), 7);
        Graphics2D g2d = awtImage.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, awtImage.getWidth(), awtImage.getHeight());
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore.getBoolean("Global.enableAntiAlias")) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2d.clip(new java.awt.Rectangle(0, 0, awtImage.getWidth(), awtImage.getHeight()));
        GraphicsToGraphics2DAdaptor graphics = new GraphicsToGraphics2DAdaptor(g2d, new Rectangle(0, 0, mm.LPtoDP(sourceRect.width), mm.LPtoDP(sourceRect.height)));
        RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics((Graphics)graphics, mm);
        this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), selectedObjects);
        graphics.dispose();
        g2d.dispose();
        return awtImage;
    }

    public Image createConstrainedAWTImageForParts(List editParts, int maxDeviceWidth, int maxDeviceHeight, boolean useMargins) {
        BufferedImage awtImage = null;
        IMapMode mm = this.getMapMode();
        DiagramGenerator.ConstrainedImageRenderingData data = this.getConstrainedImageRenderingData(editParts, maxDeviceWidth, maxDeviceHeight, useMargins);
        awtImage = new BufferedImage(data.imageWidth, data.imageHeight, 7);
        Graphics2D g2d = awtImage.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, awtImage.getWidth(), awtImage.getHeight());
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore.getBoolean("Global.enableAntiAlias")) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2d.clip(new java.awt.Rectangle(0, 0, awtImage.getWidth(), awtImage.getHeight()));
        GraphicsToGraphics2DAdaptor graphics = new GraphicsToGraphics2DAdaptor(g2d, new org.eclipse.swt.graphics.Rectangle(0, 0, data.imageWidth, data.imageHeight));
        ScaledGraphics scaledGraphics = new ScaledGraphics((Graphics)graphics);
        RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics((Graphics)scaledGraphics, mm);
        g2d.translate(data.margin, data.margin);
        mapModeGraphics.scale(data.scalingFactor);
        PrecisionPoint location = new PrecisionPoint(data.imageOriginalBounds.preciseX(), data.imageOriginalBounds.preciseY());
        mm.DPtoLP((Translatable)location);
        this.renderToGraphics((Graphics)mapModeGraphics, (Point)location, editParts);
        graphics.dispose();
        g2d.dispose();
        return awtImage;
    }
}

