/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimatableScrollPane;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.OverlayScrollPaneLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class ResizableCompartmentFigure
extends NodeFigure {
    private boolean _horizontal = false;
    private Figure textPane = null;
    private WrapLabel titleLabel;
    private int minClientSize = 0;
    protected ScrollPane scrollPane;
    private boolean selected;
    private boolean isScrollPaneInitialized = false;
    public static final int MIN_CLIENT_DP = 11;

    public ResizableCompartmentFigure(String compartmentTitle, IMapMode mm) {
        this.minClientSize = mm.DPtoLP(11);
        this.setTextPane(new Figure(){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        });
        this.getTextPane().setLayoutManager((LayoutManager)new ConstrainedToolbarLayout());
        this.add((IFigure)this.getTextPane());
        this.scrollPane = this.createScrollPane(mm);
        this.add((IFigure)this.scrollPane);
        this.setLayoutManager((LayoutManager)new ConstrainedToolbarLayout());
        this.setTitle(compartmentTitle);
        this.setToolTip(compartmentTitle);
        this.setBorder((Border)new OneLineBorder());
    }

    protected AnimatableScrollPane createScrollpane() {
        return this.createScrollpane(MapModeUtil.getMapMode((IFigure)this));
    }

    protected AnimatableScrollPane createScrollpane(IMapMode mm) {
        this.scrollPane = new AnimatableScrollPane();
        this.scrollPane.getViewport().setContentsTracksWidth(true);
        this.scrollPane.getViewport().setContentsTracksHeight(false);
        this.scrollPane.setLayoutManager((LayoutManager)new OverlayScrollPaneLayout());
        this.scrollPane.setVerticalScrollBarVisibility(1);
        this.scrollPane.setHorizontalScrollBarVisibility(0);
        this.scrollPane.setContents((IFigure)new Figure());
        int half_minClient = this.getMinClientSize() / 2;
        this.scrollPane.getContents().setBorder((Border)new MarginBorder(1, half_minClient, 1, half_minClient));
        return (AnimatableScrollPane)this.scrollPane;
    }

    protected ScrollPane createScrollPane(IMapMode mm) {
        return this.createScrollpane(mm);
    }

    protected final int getMinClientSize() {
        return this.minClientSize;
    }

    public void setTitleVisibility(boolean visibility) {
        this.getTextPane().setVisible(visibility);
    }

    public void expand() {
        if (this.scrollPane instanceof AnimatableScrollPane) {
            ((AnimatableScrollPane)this.scrollPane).expand();
        }
        this.scrollPane.setVerticalScrollBarVisibility(1);
    }

    public void collapse() {
        this.scrollPane.setVerticalScrollBarVisibility(0);
        if (this.scrollPane instanceof AnimatableScrollPane) {
            ((AnimatableScrollPane)this.scrollPane).collapse();
        }
    }

    public void setExpanded() {
        if (this.scrollPane instanceof AnimatableScrollPane) {
            ((AnimatableScrollPane)this.scrollPane).setExpanded(true);
        }
        this.scrollPane.setVerticalScrollBarVisibility(1);
    }

    public void setCollapsed() {
        this.scrollPane.setVerticalScrollBarVisibility(0);
        if (this.scrollPane instanceof AnimatableScrollPane) {
            ((AnimatableScrollPane)this.scrollPane).setExpanded(false);
        }
    }

    public IFigure getContentPane() {
        return this.scrollPane.getContents();
    }

    public void setFont(Font f) {
        this.textPane.setFont(f);
    }

    public void setFontColor(Color c) {
        this.textPane.setForegroundColor(c);
    }

    public void setTitle(String title) {
        if (title == null) {
            if (this.titleLabel != null) {
                this.getTextPane().remove((IFigure)this.titleLabel);
            }
        } else if (this.titleLabel == null) {
            this.titleLabel = new WrapLabel(title);
            this.getTextPane().add((IFigure)this.titleLabel);
        } else {
            this.titleLabel.setText(title);
        }
    }

    public void setToolTip(String tooltip) {
        if (tooltip == null) {
            this.setToolTip(null);
        } else if (this.getToolTip() instanceof Label) {
            ((Label)this.getToolTip()).setText(tooltip);
        } else {
            this.setToolTip((IFigure)new Label(tooltip));
        }
    }

    public final ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final boolean isExpanded() {
        if (this.scrollPane instanceof AnimatableScrollPane) {
            return ((AnimatableScrollPane)this.scrollPane).isExpanded();
        }
        return true;
    }

    public final String getCompartmentTitle() {
        return this.titleLabel == null ? null : this.titleLabel.getText();
    }

    public final IFigure getAdjacentSibling(boolean before) {
        List siblings = this.getParent().getChildren();
        int index = siblings.indexOf((Object)this);
        if (before) {
            int i = index - 1;
            while (i >= 0) {
                IFigure sibling = (IFigure)siblings.get(i);
                if (sibling instanceof ResizableCompartmentFigure && sibling.isVisible()) {
                    return sibling;
                }
                --i;
            }
        } else {
            int i = index + 1;
            while (i < siblings.size()) {
                IFigure sibling = (IFigure)siblings.get(i);
                if (sibling instanceof ResizableCompartmentFigure && sibling.isVisible()) {
                    return sibling;
                }
                ++i;
            }
        }
        return null;
    }

    public void setSelected(boolean b) {
        if (this.selected == b) {
            return;
        }
        this.selected = b;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.selected) {
            graphics.setLineWidth(2);
            int shrink = MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
            graphics.drawRectangle(this.getClientArea().shrink(shrink, shrink));
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension p = super.getPreferredSize(wHint, hHint);
        return p.getUnioned(this.getMinimumSize(wHint, hHint));
    }

    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize = this.getLayoutManager().getMinimumSize((IFigure)this, w, h);
        }
        int minHeight = this.getMinClientDimension().height + this.getInsets().getHeight();
        this.minSize.height = Math.max(minHeight, this.minSize.height);
        if (h >= 0) {
            this.minSize.height = Math.min(this.minSize.height, h);
        }
        int minWidth = this.getMinClientDimension().width + this.getInsets().getWidth();
        this.minSize.width = Math.max(minWidth, this.minSize.width);
        if (w >= 0) {
            this.minSize.width = Math.min(this.minSize.width, w);
        }
        return this.minSize;
    }

    public final boolean isHorizontal() {
        return this._horizontal;
    }

    public final void setHorizontal(boolean horizontal) {
        this._horizontal = horizontal;
    }

    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize().getCopy();
        if (!this.isExpanded()) {
            if (this.isHorizontal()) {
                d.width = this.getPreferredSize().width;
            } else {
                d.height = this.getPreferredSize().height;
            }
        }
        return d;
    }

    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        super.invalidate();
    }

    public Figure getTextPane() {
        return this.textPane;
    }

    private void setTextPane(Figure textPane) {
        this.textPane = textPane;
    }

    public Dimension getMinClientDimension() {
        return new Dimension(this.getMinClientSize(), this.getMinClientSize());
    }

    public void validate() {
        super.validate();
        this.initializeScrollPane();
    }

    private void initializeScrollPane() {
        if (!this.isScrollPaneInitialized) {
            if (this.getScrollPane() != null) {
                Point topLeft = this.getScrollPane().getContents().getBounds().getTopLeft();
                if (topLeft.x < 0) {
                    this.getScrollPane().getViewport().getHorizontalRangeModel().setValue(topLeft.x);
                }
                if (topLeft.y < 0) {
                    this.getScrollPane().getViewport().getVerticalRangeModel().setValue(topLeft.y);
                }
            }
            this.isScrollPaneInitialized = true;
        }
    }
}

