/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.lite.edit.parts.update.ComposeableRefresherImpl;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IExternallyUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IUpdatableEditPart;

public class RefreshersRegistry {
    private HashMap<EStructuralFeature, CompositeConditionalRefresher> myFeature2Refreshers;

    public void add(EStructuralFeature feature, IUpdatableEditPart.Refresher refresher) {
        if (refresher == null) {
            return;
        }
        this.get(feature, true).add(refresher);
    }

    public void remove(EStructuralFeature feature, IUpdatableEditPart.Refresher refresher) {
        if (refresher == null) {
            return;
        }
        CompositeConditionalRefresher compositeRefresher = this.get(feature, false);
        if (compositeRefresher == null) {
            return;
        }
        compositeRefresher.remove(refresher);
    }

    private CompositeConditionalRefresher get(EStructuralFeature feature, boolean createIfMissing) {
        CompositeConditionalRefresher result;
        if (this.myFeature2Refreshers == null) {
            if (!createIfMissing) {
                return null;
            }
            this.myFeature2Refreshers = new HashMap();
        }
        if ((result = this.myFeature2Refreshers.get(feature)) == null && createIfMissing) {
            result = new CompositeConditionalRefresher();
            this.myFeature2Refreshers.put(feature, result);
        }
        return result;
    }

    public IUpdatableEditPart.Refresher getRefresher(EStructuralFeature feature, Notification msg) {
        CompositeConditionalRefresher compositeRefresher = this.get(feature, false);
        if (compositeRefresher == null) {
            return null;
        }
        return compositeRefresher.getFiltered(msg);
    }

    private static class CompositeConditionalRefresher {
        private Collection<IUpdatableEditPart.Refresher> myRefreshers;

        private CompositeConditionalRefresher() {
        }

        public void add(IUpdatableEditPart.Refresher refresher) {
            if (refresher == null) {
                return;
            }
            if (this.myRefreshers == null) {
                this.myRefreshers = new LinkedList<IUpdatableEditPart.Refresher>();
            }
            this.myRefreshers.add(refresher);
        }

        public void remove(IUpdatableEditPart.Refresher refresher) {
            if (refresher == null || this.myRefreshers == null) {
                return;
            }
            this.myRefreshers.remove(refresher);
        }

        public IUpdatableEditPart.Refresher getFiltered(Notification msg) {
            if (this.myRefreshers == null) {
                return null;
            }
            HashSet<IUpdatableEditPart.Refresher> result = new HashSet<IUpdatableEditPart.Refresher>();
            for (IUpdatableEditPart.Refresher next : this.myRefreshers) {
                if (!this.isAffecting(next, msg)) continue;
                result.add(next);
            }
            return new ComposeableRefresherImpl(result);
        }

        private boolean isAffecting(IUpdatableEditPart.Refresher refresher, Notification msg) {
            if (refresher instanceof IExternallyUpdatableEditPart.ExternalRefresher) {
                return ((IExternallyUpdatableEditPart.ExternalRefresher)refresher).isAffectingEvent(msg);
            }
            return true;
        }

        public void refresh() {
            if (this.myRefreshers == null) {
                return;
            }
            for (IUpdatableEditPart.Refresher next : this.myRefreshers) {
                next.refresh();
            }
        }
    }
}

