/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.gef.ui;

import junit.framework.TestCase;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.DiamondFigure;

public class FigureSlidableAnchorTests
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testStraightlineTolerance() {
        NodeFigure fig = new NodeFigure();
        fig.setBounds(new Rectangle(100, 100, 100, 100));
        Point p1 = new Point(150, 150);
        Point p2 = new Point(148, 300);
        ConnectionAnchor anchor = fig.getSourceConnectionAnchorAt(p1);
        Point reference = anchor.getLocation(p2);
        FigureSlidableAnchorTests.assertTrue((reference.x == p2.x ? 1 : 0) != 0);
        p1 = new Point(110, 200);
        p2 = new Point(112, 300);
        anchor = fig.getSourceConnectionAnchorAt(p1);
        reference = anchor.getLocation(p2);
        FigureSlidableAnchorTests.assertTrue((reference.x == p2.x ? 1 : 0) != 0);
    }

    public void testGetLocationFromReferenceOnBorder() {
        NodeFigure fig = new NodeFigure();
        fig.setBounds(new Rectangle(100, 100, 100, 100));
        Point p1 = new Point(200, 150);
        ConnectionAnchor anchor = fig.getSourceConnectionAnchorAt(p1);
        Point p2 = new Point(200, 175);
        Point reference = anchor.getLocation(new Point(200, 175));
        FigureSlidableAnchorTests.assertTrue((reference.y == p2.y ? 1 : 0) != 0);
    }

    public void testAnchorPosition() {
        NodeFigure fig = new NodeFigure();
        fig.setBounds(new Rectangle(-10, -10, 20, 20));
        Point p = new Point(3, 3);
        ConnectionAnchor anchor = fig.getSourceConnectionAnchorAt(p);
        Point reference = anchor.getReferencePoint();
        FigureSlidableAnchorTests.assertTrue((reference.x == 0 && reference.y == 0 ? 1 : 0) != 0);
        p = new Point(8, 8);
        anchor = fig.getSourceConnectionAnchorAt(p);
        reference = anchor.getReferencePoint();
        FigureSlidableAnchorTests.assertTrue((reference.x == p.x && reference.y == p.y ? 1 : 0) != 0);
        p = new Point(12, 12);
        anchor = fig.getSourceConnectionAnchorAt(p);
        reference = anchor.getReferencePoint();
        FigureSlidableAnchorTests.assertTrue((reference.x == 10 && reference.y == 10 ? 1 : 0) != 0);
        p = new Point(15, 0);
        anchor = fig.getSourceConnectionAnchorAt(p);
        reference = anchor.getReferencePoint();
        FigureSlidableAnchorTests.assertTrue((reference.x == 10 && reference.y == 0 ? 1 : 0) != 0);
    }

    public void testAnchorLocationOnPolygonFigure() {
        DiamondFigure fig = new DiamondFigure(new Dimension(1058, 1058));
        fig.setBounds(Rectangle.SINGLETON);
        fig.getBounds().setLocation(-10, -10);
        fig.getBounds().setSize(20, 20);
        Point reference = new Point(20, 0);
        Point position = new Point(2, 2);
        ConnectionAnchor anchor = fig.getSourceConnectionAnchorAt(position);
        Point location = anchor.getLocation(reference);
        FigureSlidableAnchorTests.assertTrue((location.x == 10 && location.y == 0 ? 1 : 0) != 0);
        position = new Point(-8, 0);
        anchor = fig.getSourceConnectionAnchorAt(position);
        location = anchor.getLocation(reference);
        FigureSlidableAnchorTests.assertTrue((location.x == 10 && location.y == 0 ? 1 : 0) != 0);
        position = new Point(10, 5);
        anchor = fig.getSourceConnectionAnchorAt(position);
        location = anchor.getLocation(reference);
        FigureSlidableAnchorTests.assertTrue((location.x == 10 && location.y == 0 ? 1 : 0) != 0);
        reference = new Point(-2, 5);
        location = anchor.getLocation(reference);
        FigureSlidableAnchorTests.assertTrue((location.x == -5 && location.y == 5 ? 1 : 0) != 0);
        reference = new Point(10, 5);
        location = anchor.getLocation(reference);
        FigureSlidableAnchorTests.assertTrue((location.x == 7 && location.y == 3 ? 1 : 0) != 0);
        reference = new Point(0, 0);
        position = new Point(0, 0);
        anchor = fig.getSourceConnectionAnchorAt(position);
        location = anchor.getLocation(reference);
        FigureSlidableAnchorTests.assertTrue((location.x == 0 && location.y == 0 ? 1 : 0) != 0);
    }
}

