/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.LabelHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;

public class ResizableShapeLabelEditPolicy
extends ResizableShapeEditPolicy {
    private Polyline tether = null;

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.tether != null) {
            this.removeFeedback((IFigure)this.tether);
        }
        this.tether = null;
    }

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure feedback = super.createDragSourceFeedbackFigure();
        this.tether = new Polyline();
        this.tether.setLineStyle(4);
        this.tether.setForegroundColor(((IGraphicalEditPart)this.getHost().getParent()).getFigure().getForegroundColor());
        this.addFeedback((IFigure)this.tether);
        return feedback;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        Point refPoint = this.getReferencePoint();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        this.adjustRect(rect);
        Point normalPoint = LabelHelper.offsetFromRelativeCoordinate(this.getHostFigure(), (Rectangle)rect, refPoint);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        SetBoundsCommand moveCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.MoveLabelCommand_Label_Location, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), normalPoint);
        return new ICommandProxy((ICommand)moveCommand);
    }

    protected void adjustRect(PrecisionRectangle rect) {
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(request);
        IFigure p = this.getDragSourceFeedbackFigure();
        Rectangle r = p.getBounds();
        Point refPoint = this.getReferencePoint();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        p.translateToRelative((Translatable)rect);
        p.setBounds((Rectangle)rect);
        PrecisionRectangle ref = new PrecisionRectangle(new Rectangle(refPoint.x, refPoint.y, 0, 0));
        this.getHostFigure().translateToAbsolute((Translatable)ref);
        p.translateToRelative((Translatable)ref);
        Point midTop = new Point(r.x + r.width / 2, r.y);
        Point midBottom = new Point(r.x + r.width / 2, r.y + r.height);
        Point midLeft = new Point(r.x, r.y + r.height / 2);
        Point midRight = new Point(r.x + r.width, r.y + r.height / 2);
        Point startPoint = midTop;
        int x = r.x + r.width / 2 - refPoint.x;
        int y = r.y + r.height / 2 - refPoint.y;
        startPoint = y > 0 && y > x && y > -x ? midTop : (y < 0 && y < x && y < -x ? midBottom : (x < 0 && y > x && y < -x ? midRight : midLeft));
        this.tether.setStart(startPoint);
        this.tether.setEnd(ref.getLocation());
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        View shapeView = (View)this.getHost().getModel();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Point refPoint = this.getReferencePoint();
        Point normalPoint = LabelHelper.offsetFromRelativeCoordinate(this.getHostFigure(), (Rectangle)rect, refPoint);
        SetBoundsCommand resizeCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)shapeView), new Rectangle(normalPoint, rect.getSize()));
        return new ICommandProxy((ICommand)resizeCommand);
    }

    private Point getReferencePoint() {
        if (this.getHost().getParent() instanceof AbstractConnectionEditPart) {
            PointList ptList = ((AbstractConnectionEditPart)this.getHost().getParent()).getConnectionFigure().getPoints();
            return PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)50, (boolean)true);
        }
        return ((GraphicalEditPart)this.getHost().getParent()).getFigure().getBounds().getLocation();
    }
}

