/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.osgi.framework.Bundle;

public class PropertiesConfigurationManager {
    private static final String PROPERTIES_CONFIGURATION_EXT_P_NAME = "propertiesConfiguration";
    private static final String PATH_ATTRIBUTE = "path";
    private static Map pluginIdToPropertiesMap = null;

    private PropertiesConfigurationManager() {
    }

    public static String getString(String pluginId, String key) {
        HashMap propertiesMap = (HashMap)PropertiesConfigurationManager.getPluginIdToPropertiesMap().get(pluginId);
        if (propertiesMap == null) {
            propertiesMap = new HashMap();
            PropertiesConfigurationManager.getPluginIdToPropertiesMap().put(pluginId, propertiesMap);
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(CommonCorePlugin.getPluginId(), PROPERTIES_CONFIGURATION_EXT_P_NAME).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                if (extensions[i].getContributor().getName().equals(pluginId)) {
                    PropertiesConfigurationManager.loadProperties(propertiesMap, extensions[i].getConfigurationElements());
                }
                ++i;
            }
        }
        return (String)propertiesMap.get(key);
    }

    private static Map getPluginIdToPropertiesMap() {
        if (pluginIdToPropertiesMap == null) {
            pluginIdToPropertiesMap = new HashMap();
        }
        return pluginIdToPropertiesMap;
    }

    private static void loadProperties(Map propertiesMap, IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            block17: {
                IConfigurationElement element = elements[i];
                String relativePath = element.getAttribute(PATH_ATTRIBUTE);
                Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
                assert (bundle != null);
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
                if (url == null) {
                    Log.error(CommonCorePlugin.getDefault(), 5, "Couldn't find relative path " + relativePath + " in " + element.getDeclaringExtension().getContributor().getName());
                }
                InputStream is = null;
                try {
                    try {
                        is = url.openStream();
                        Properties properties = new Properties();
                        properties.load(is);
                        propertiesMap.putAll(properties);
                    }
                    catch (IOException e) {
                        PropertiesConfigurationManager.handleException(e);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e2) {
                                PropertiesConfigurationManager.handleException(e2);
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            PropertiesConfigurationManager.handleException(e);
                        }
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        PropertiesConfigurationManager.handleException(e);
                    }
                }
            }
            ++i;
        }
    }

    private static void handleException(Exception e) {
        Trace.catching(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.EXCEPTIONS_CATCHING, PropertiesConfigurationManager.class, "configureProperties", e);
        Log.error(CommonCorePlugin.getDefault(), 5, e.getMessage(), e);
    }
}

