/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class WorkbenchPartActivator {
    private WorkbenchPartActivator() {
    }

    public static IViewPart showView(String viewId) {
        ShowViewRunnable runnable = new ShowViewRunnable(viewId);
        Display.getCurrent().syncExec((Runnable)runnable);
        return runnable.getViewPart();
    }

    public static IViewPart showTaskList() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.views.TaskList");
    }

    public static IViewPart showProblemView() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.views.ProblemView");
    }

    public static IViewPart showBookmarkNavigator() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.views.BookmarkView");
    }

    public static IViewPart showEditorArea() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.editorss");
    }

    public static IViewPart showContentOutline() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.views.ContentOutline");
    }

    public static IViewPart showPropertySheet() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.views.PropertySheet");
    }

    public static IViewPart showResourceNavigator() {
        return WorkbenchPartActivator.showView("org.eclipse.ui.navigator.ProjectExplorer");
    }

    private static class ShowViewRunnable
    implements Runnable {
        private IViewPart viewPart = null;
        private final String viewId;

        public ShowViewRunnable(String viewId) {
            this.viewId = viewId;
        }

        public void run() {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
            if (workbenchPage == null) {
                return;
            }
            try {
                this.viewPart = workbenchPage.showView(this.viewId);
            }
            catch (PartInitException pie) {
                Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)pie.getMessage(), (Throwable)pie);
                Log.warning((Plugin)CommonUIPlugin.getDefault(), (int)6, (String)pie.getMessage(), (Throwable)pie);
                String message = MessageFormat.format(CommonUIMessages.WorkbenchPartActivator_ErrorMessage, this.viewId);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), null, (String)message, (IStatus)new Status(4, CommonUIPlugin.getPluginId(), 6, pie.getLocalizedMessage(), (Throwable)pie));
            }
        }

        public IViewPart getViewPart() {
            return this.viewPart;
        }
    }
}

