/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import org.eclipse.draw2d.AbstractLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.LabelHelper;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class LabelLocator
extends AbstractLocator {
    protected IFigure parent;
    private int alignment;
    private Point offSet;
    private Dimension extent;

    public LabelLocator(IFigure parent, Point offSet, int alignment) {
        this.parent = parent;
        this.offSet = offSet;
        this.alignment = alignment;
    }

    public LabelLocator(IFigure parent, Rectangle bounds, int alignment) {
        this(parent, bounds.getLocation(), alignment);
        this.extent = bounds.getSize();
    }

    public Point getOffset() {
        return this.offSet;
    }

    public void setOffset(Point offset) {
        this.offSet = offset;
    }

    public void relocate(IFigure target) {
        if (this.extent != null) {
            LabelLocator currentConstraint = (LabelLocator)((Object)target.getParent().getLayoutManager().getConstraint(target));
            Dimension currentExtent = currentConstraint.getSize();
            Dimension size = new Dimension(currentExtent);
            if (currentExtent.width == -1) {
                size.width = target.getPreferredSize().width;
            }
            if (currentExtent.height == -1) {
                size.height = target.getPreferredSize().height;
            }
            target.setSize(size);
        } else {
            target.setSize(new Dimension(target.getPreferredSize().width, target.getPreferredSize().height));
        }
        Point location = LabelHelper.relativeCoordinateFromOffset(target, this.getReferencePoint(), this.offSet);
        target.setLocation(location);
    }

    protected Point getReferencePoint() {
        if (this.parent instanceof Connection) {
            PointList ptList = ((Connection)this.parent).getPoints();
            return PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)this.getLocation(), (boolean)true);
        }
        return this.parent.getBounds().getLocation();
    }

    private int getLocation() {
        switch (this.getAlignment()) {
            case 2: {
                return 85;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 50;
            }
        }
        return 50;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Dimension getSize() {
        return this.extent.getCopy();
    }

    protected PointList getPointList() {
        if (this.parent instanceof Connection) {
            return ((Connection)this.parent).getPoints();
        }
        PointList ptList = new PointList();
        ptList.addPoint(this.parent.getBounds().getLocation());
        return ptList;
    }
}

