/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.ImageFileDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDragSourceListener;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteService;
import org.eclipse.gmf.runtime.diagram.ui.tools.ConnectionCreationTool;
import org.eclipse.gmf.runtime.diagram.ui.tools.CreationTool;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteCustomizerEx;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteViewerEx;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;

public abstract class DiagramEditorWithFlyOutPalette
extends DiagramEditor {
    private IActivityManagerListener activityManagerListener;
    boolean fHasFlyoutPalette = true;
    protected static final int UNCOLLAPSED_PINNED = 4;
    protected static final int COLLAPSED = 2;
    private PaletteViewerProvider provider;
    private FlyoutPaletteComposite splitter;
    private CustomPalettePage page;
    KeyHandler paletteKeyHandler = null;
    MouseListener paletteMouseListener = null;

    public DiagramEditorWithFlyOutPalette() {
    }

    public DiagramEditorWithFlyOutPalette(boolean hasFlyout) {
        this.fHasFlyoutPalette = hasFlyout;
    }

    @Override
    protected void initializeGraphicalViewer() {
        if (this.fHasFlyoutPalette) {
            this.splitter.hookDropTargetListener(this.getGraphicalViewer());
            super.initializeGraphicalViewer();
            this.getDiagramGraphicalViewer().addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new ImageFileDropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer()));
            this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new PaletteToolTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        } else {
            super.initializeGraphicalViewer();
        }
    }

    protected boolean toolSupportsAccessibility(Tool t) {
        return t instanceof CreationTool || t instanceof ConnectionCreationTool;
    }

    protected PaletteViewer constructPaletteViewer() {
        return new PaletteViewerEx();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        assert (this.fHasFlyoutPalette);
        this.getEditDomain().setPaletteRoot(this.createPaletteRoot(null));
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            public PaletteViewer createPaletteViewer(Composite parent) {
                PaletteViewer pViewer = DiagramEditorWithFlyOutPalette.this.constructPaletteViewer();
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.getKeyHandler().setParent(this.getPaletteKeyHandler());
                viewer.getControl().addMouseListener(this.getPaletteMouseListener());
                viewer.addDragSourceListener((TransferDragSourceListener)new PaletteToolTransferDragSourceListener((EditPartViewer)viewer));
                viewer.setCustomizer(DiagramEditorWithFlyOutPalette.this.createPaletteCustomizer());
            }

            private KeyHandler getPaletteKeyHandler() {
                if (DiagramEditorWithFlyOutPalette.this.paletteKeyHandler == null) {
                    DiagramEditorWithFlyOutPalette.this.paletteKeyHandler = new KeyHandler(){

                        public boolean keyReleased(KeyEvent event) {
                            if (event.keyCode == 13) {
                                Tool tool = DiagramEditorWithFlyOutPalette.this.getPaletteViewer().getActiveTool().createTool();
                                if (DiagramEditorWithFlyOutPalette.this.toolSupportsAccessibility(tool)) {
                                    tool.keyUp(event, (EditPartViewer)DiagramEditorWithFlyOutPalette.this.getDiagramGraphicalViewer());
                                    DiagramEditorWithFlyOutPalette.this.getPaletteViewer().setActiveTool(null);
                                    return true;
                                }
                            }
                            return super.keyReleased(event);
                        }
                    };
                }
                return DiagramEditorWithFlyOutPalette.this.paletteKeyHandler;
            }

            private MouseListener getPaletteMouseListener() {
                if (DiagramEditorWithFlyOutPalette.this.paletteMouseListener == null) {
                    DiagramEditorWithFlyOutPalette.this.paletteMouseListener = new MouseListener(){
                        private boolean clearActiveTool = false;

                        public void mouseDoubleClick(MouseEvent e) {
                            Tool tool = DiagramEditorWithFlyOutPalette.this.getPaletteViewer().getActiveTool().createTool();
                            if (DiagramEditorWithFlyOutPalette.this.toolSupportsAccessibility(tool)) {
                                tool.setViewer((EditPartViewer)DiagramEditorWithFlyOutPalette.this.getDiagramGraphicalViewer());
                                tool.setEditDomain(DiagramEditorWithFlyOutPalette.this.getDiagramGraphicalViewer().getEditDomain());
                                tool.mouseDoubleClick(e, (EditPartViewer)DiagramEditorWithFlyOutPalette.this.getDiagramGraphicalViewer());
                                this.clearActiveTool = true;
                            }
                        }

                        public void mouseDown(MouseEvent e) {
                        }

                        public void mouseUp(MouseEvent e) {
                            if (this.clearActiveTool) {
                                DiagramEditorWithFlyOutPalette.this.getPaletteViewer().setActiveTool(null);
                                this.clearActiveTool = false;
                            }
                        }
                    };
                }
                return DiagramEditorWithFlyOutPalette.this.paletteMouseListener;
            }
        };
    }

    public void setFocus() {
        if (this.getGraphicalControl() != null) {
            this.getGraphicalControl().setFocus();
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        if (this.fHasFlyoutPalette) {
            FlyoutPreferencesImpl flyoutPrefs = new FlyoutPreferencesImpl(this.getPreferenceStore());
            this.splitter = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), (FlyoutPaletteComposite.FlyoutPreferences)flyoutPrefs);
            super.createPartControl((Composite)this.splitter);
            this.splitter.setGraphicalControl(this.getGraphicalControl());
            if (this.page != null) {
                this.splitter.setExternalViewer(this.getPaletteViewer());
                this.page = null;
            }
        } else {
            super.createPartControl(parent);
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return DiagramUIPlugin.getInstance().getPreferenceStore();
    }

    @Override
    public Object getAdapter(Class type) {
        if (this.fHasFlyoutPalette) {
            if (type == PalettePage.class) {
                if (this.splitter == null) {
                    this.page = new CustomPalettePage(this.getPaletteViewerProvider());
                    return this.page;
                }
                return new CustomPalettePage(this.getPaletteViewerProvider());
            }
            if (type == PaletteViewer.class) {
                return this.getPaletteViewer();
            }
        }
        return super.getAdapter(type);
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot paletteRoot;
        if (existingPaletteRoot == null) {
            paletteRoot = PaletteService.getInstance().createPalette((IEditorPart)this, this.getDefaultPaletteContent());
        } else {
            PaletteService.getInstance().updatePalette(existingPaletteRoot, (IEditorPart)this, this.getDefaultPaletteContent());
            paletteRoot = existingPaletteRoot;
        }
        this.applyCustomizationsToPalette(paletteRoot);
        return paletteRoot;
    }

    protected abstract Object getDefaultPaletteContent();

    protected final PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = this.createPaletteViewerProvider();
        }
        return this.provider;
    }

    protected int getInitialPaletteSize() {
        return 125;
    }

    protected int getInitialPaletteState() {
        return 4;
    }

    protected int getInitialDockLocation() {
        return 16;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        super.setEditDomain(ed);
    }

    protected void configurePaletteViewer() {
        assert (this.fHasFlyoutPalette);
        PaletteViewer viewer = this.getPaletteViewer();
        if (viewer == null) {
            return;
        }
        PaletteContextMenuProvider paletteContextProvider = new PaletteContextMenuProvider(viewer);
        this.getPaletteViewer().setContextMenu((MenuManager)paletteContextProvider);
    }

    private PaletteViewer getPaletteViewer() {
        return this.getEditDomain().getPaletteViewer();
    }

    protected void handlePaletteResized(int newSize) {
    }

    protected void handlePaletteDefaultStateChanged(int newState) {
    }

    @Override
    protected void startListening() {
        super.startListening();
        this.activityManagerListener = this.createActivityManagerListener();
        if (this.activityManagerListener != null) {
            PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this.activityManagerListener);
        }
    }

    @Override
    protected void stopListening() {
        if (this.activityManagerListener != null) {
            PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener(this.activityManagerListener);
            this.activityManagerListener = null;
        }
        super.stopListening();
    }

    protected IActivityManagerListener createActivityManagerListener() {
        return new ActivityManagerListener();
    }

    protected void applyCustomizationsToPalette(PaletteRoot paletteRoot) {
        PaletteCustomizer customizer;
        PaletteCustomizer paletteCustomizer = customizer = this.getPaletteViewer() != null ? this.getPaletteViewer().getCustomizer() : this.createPaletteCustomizer();
        if (customizer instanceof PaletteCustomizerEx) {
            ((PaletteCustomizerEx)customizer).applyCustomizationsToPalette(paletteRoot);
        }
    }

    protected PaletteCustomizer createPaletteCustomizer() {
        return new PaletteCustomizerEx(this.getPreferenceStore());
    }

    class ActivityManagerListener
    implements IActivityManagerListener {
        ActivityManagerListener() {
        }

        public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
            if (activityManagerEvent.haveEnabledActivityIdsChanged() && DiagramEditorWithFlyOutPalette.this.getEditDomain() != null && DiagramEditorWithFlyOutPalette.this.getEditDomain().getPaletteViewer() != null && DiagramEditorWithFlyOutPalette.this.getEditDomain().getPaletteViewer().getPaletteRoot() != null) {
                DiagramEditorWithFlyOutPalette.this.createPaletteRoot(DiagramEditorWithFlyOutPalette.this.getEditDomain().getPaletteViewer().getPaletteRoot());
            }
        }
    }

    protected class CustomPalettePage
    extends PaletteViewerPage {
        public CustomPalettePage(PaletteViewerProvider provider) {
            super(provider);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (DiagramEditorWithFlyOutPalette.this.splitter != null) {
                DiagramEditorWithFlyOutPalette.this.splitter.setExternalViewer(this.viewer);
            }
        }

        public void dispose() {
            if (DiagramEditorWithFlyOutPalette.this.splitter != null) {
                DiagramEditorWithFlyOutPalette.this.splitter.setExternalViewer(null);
            }
            super.dispose();
        }

        public PaletteViewer getPaletteViewer() {
            return this.viewer;
        }
    }

    private final class FlyoutPreferencesImpl
    implements FlyoutPaletteComposite.FlyoutPreferences {
        private static final String PALETTE_DOCK_LOCATION = "org.eclipse.gmf.pdock";
        private static final String PALETTE_SIZE = "org.eclipse.gmf.psize";
        private static final String PALETTE_STATE = "org.eclipse.gmf.pstate";
        private IPreferenceStore preferences;

        private FlyoutPreferencesImpl(IPreferenceStore preferenceStore) {
            this.preferences = preferenceStore;
        }

        public int getDockLocation() {
            if (this.preferences.contains(PALETTE_DOCK_LOCATION)) {
                return this.preferences.getInt(PALETTE_DOCK_LOCATION);
            }
            return DiagramEditorWithFlyOutPalette.this.getInitialDockLocation();
        }

        public int getPaletteState() {
            if (this.preferences.contains(PALETTE_STATE)) {
                return this.preferences.getInt(PALETTE_STATE);
            }
            return DiagramEditorWithFlyOutPalette.this.getInitialPaletteState();
        }

        public int getPaletteWidth() {
            if (this.preferences.contains(PALETTE_SIZE)) {
                return this.preferences.getInt(PALETTE_SIZE);
            }
            return DiagramEditorWithFlyOutPalette.this.getInitialPaletteSize();
        }

        public void setDockLocation(int location) {
            this.preferences.setValue(PALETTE_DOCK_LOCATION, location);
        }

        public void setPaletteState(int state) {
            this.preferences.setValue(PALETTE_STATE, state);
        }

        public void setPaletteWidth(int width) {
            this.preferences.setValue(PALETTE_SIZE, width);
        }
    }
}

