/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.util;

import org.eclipse.emf.ecore.EObject;

public abstract class BooleanPropertyHelper {
    private static final Integer INT_FALSE = new Integer(0);
    private static final Integer INT_TRUE = new Integer(1);
    private EObject element;

    public BooleanPropertyHelper(EObject element) {
        this.element = element;
    }

    public boolean isCompatible(Object obj) {
        return obj != null && obj instanceof Integer;
    }

    public void setValue(Object value) {
        if (!this.isCompatible(value)) {
            throw new IllegalArgumentException();
        }
        boolean boolValue = false;
        if ((Integer)value == 1) {
            boolValue = true;
        }
        this.setBooleanValue(boolValue);
    }

    protected abstract void setBooleanValue(boolean var1);

    public Integer getValue() {
        if (this.getBooleanValue()) {
            return INT_TRUE;
        }
        return INT_FALSE;
    }

    protected abstract boolean getBooleanValue();

    public EObject getElement() {
        return this.element;
    }
}

